/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.logic;

import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicExpressionParser;

class LogicExpressionParsers {
    public static final LogicExpressionParser<String> trivial = new LogicExpressionParser<String>(){

        @Override
        public Expression.Arg<String> factory(final String string) {
            return new Expression.Arg.Pred<String>(string){

                @Override
                public boolean apply(String entity) {
                    return "true".equals(string);
                }
            };
        }
    };
    public static final LogicExpressionParser<String> stringMatch = new LogicExpressionParser<String>(){

        @Override
        public Expression.Arg<String> factory(final String token) {
            return new Expression.Arg.Pred<String>(token){
                final String string;
                {
                    super(x0);
                    this.string = token.substring(1, token.length() - 1);
                }

                @Override
                public boolean apply(String entity) {
                    return entity.equals(this.string);
                }
            };
        }
    };

    LogicExpressionParsers() {
    }
}

