/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.XMLValidator;
import org.languagetool.rules.Category;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ErrorTriggeringExample;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.AbstractPatternRuleTest;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternTestTools;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RegexPatternRule;
import org.languagetool.rules.patterns.RuleIdValidator;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class PatternRuleTest
extends AbstractPatternRuleTest {
    private static final boolean CHECK_WITH_SENTENCE_SPLITTING = false;
    private static final Comparator<Match> MATCH_COMPARATOR = Comparator.comparingInt(Match::getTokenRef);
    @org.junit.Rule
    public final PatternRuleErrorCollector ruleErrors = this.createPatternRuleErrorCollector();

    public void testFake() {
    }

    protected PatternRuleErrorCollector createPatternRuleErrorCollector() {
        return new PatternRuleErrorCollector();
    }

    @Test
    public void testSupportsLanguage() {
        FakeLanguage fakeLanguage1 = new FakeLanguage("yy");
        FakeLanguage fakeLanguage2 = new FakeLanguage("zz");
        PatternRule patternRule1 = new PatternRule("ID", (Language)fakeLanguage1, Collections.emptyList(), "", "", "");
        Assert.assertTrue((boolean)patternRule1.supportsLanguage((Language)fakeLanguage1));
        Assert.assertFalse((boolean)patternRule1.supportsLanguage((Language)fakeLanguage2));
        FakeLanguage fakeLanguage1WithVariant1 = new FakeLanguage("zz", "VAR1");
        FakeLanguage fakeLanguage1WithVariant2 = new FakeLanguage("zz", "VAR2");
        PatternRule patternRuleVariant1 = new PatternRule("ID", (Language)fakeLanguage1WithVariant1, Collections.emptyList(), "", "", "");
        Assert.assertTrue((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1WithVariant1));
        Assert.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1));
        Assert.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage2));
        Assert.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1WithVariant2));
    }

    protected void runGrammarRulesFromXmlTest(Language ignoredLanguage) throws IOException {
        int count = 0;
        for (Language lang : Languages.get()) {
            if (ignoredLanguage.getShortCodeWithCountryAndVariant().equals(lang.getShortCodeWithCountryAndVariant())) continue;
            this.runGrammarRuleForLanguage(lang);
            ++count;
        }
        if (count == 0) {
            System.err.println("Warning: no languages found in classpath - cannot run any grammar rule tests");
        }
    }

    protected void runGrammarRulesFromXmlTest() throws IOException {
        for (Language lang : Languages.get()) {
            this.runGrammarRuleForLanguage(lang);
        }
        if (Languages.get().isEmpty()) {
            System.err.println("Warning: no languages found in classpath - cannot run any grammar rule tests");
        }
    }

    protected void runGrammarRuleForLanguage(Language lang) throws IOException {
        if (lang.getShortCode().equals("de")) {
            if (lang.getShortCodeWithCountryAndVariant().equals("de-DE")) {
                this.runTestForLanguage(lang);
                this.runTestForLanguage(Languages.getLanguageForShortCode((String)"de"));
            } else if (lang.getShortCodeWithCountryAndVariant().equals("de-CH")) {
                this.runTestForLanguage(lang);
            } else {
                System.out.println("Skipping " + lang + " because only de-DE and de-CH gets tested for German (assuming there are no de-AT specific rules)");
            }
        } else {
            if (this.skipCountryVariant(lang)) {
                System.out.println("Skipping " + lang + " because there are no specific rules for that variant");
                return;
            }
            this.runTestForLanguage(lang);
        }
    }

    private void runGrammarRulesFromXmlTestIgnoringLanguages(Set<Language> ignoredLanguages) throws IOException {
        System.out.println("Known languages: " + Languages.getWithDemoLanguage());
        for (Language lang : Languages.getWithDemoLanguage()) {
            if (ignoredLanguages != null && ignoredLanguages.contains(lang)) continue;
            this.runTestForLanguage(lang);
        }
    }

    public void runTestForLanguage(Language lang) throws IOException {
        this.validatePatternFile(lang);
        this.validateRemoteRulesFile(lang);
        System.out.println("Running pattern rule tests for " + lang.getName() + " (" + lang.getClass().getName() + ")... ");
        MultiThreadedJLanguageTool lt = PatternRuleTest.createToolForTesting(lang);
        MultiThreadedJLanguageTool allRulesLt = new MultiThreadedJLanguageTool(lang);
        this.validateRuleIds(lang, (JLanguageTool)allRulesLt);
        this.validateSentenceStartNotInMarker((JLanguageTool)allRulesLt);
        this.validateUnifyIgnoreAtTheStartOfUnify((JLanguageTool)allRulesLt);
        this.validateParenthesisInSynthesisMatches((JLanguageTool)allRulesLt);
        List<AbstractPatternRule> rules = this.getAllPatternRules(lang, (JLanguageTool)lt);
        this.testRegexSyntax(lang, rules);
        this.testMessages(lang, rules);
        this.testGrammarRulesFromXML(rules, (JLanguageTool)allRulesLt, lang);
        System.out.println(rules.size() + " rules tested.");
        allRulesLt.shutdown();
        lt.shutdown();
    }

    @NotNull
    protected static MultiThreadedJLanguageTool createToolForTesting(Language lang) {
        MultiThreadedJLanguageTool lt = new MultiThreadedJLanguageTool(lang);
        return lt;
    }

    protected void validatePatternFile(Language lang) throws IOException {
        this.validatePatternFile(this.getGrammarFileNames(lang));
    }

    protected void validatePatternFile(List<String> grammarFiles) throws IOException {
        XMLValidator validator = new XMLValidator();
        for (String grammarFile : grammarFiles) {
            System.out.println("Running XML validation for " + grammarFile + "...");
            String rulesDir = JLanguageTool.getDataBroker().getRulesDir();
            String ruleFilePath = rulesDir + "/" + grammarFile;
            InputStream xmlStream = this.getClass().getResourceAsStream(ruleFilePath);
            Throwable throwable = null;
            try {
                if (xmlStream == null) {
                    if (ruleFilePath.equals("/org/languagetool/rules/en/en-US/grammar-l2-de.xml") || ruleFilePath.equals("/org/languagetool/rules/en/en-US/grammar-l2-fr.xml") || ruleFilePath.equals("/org/languagetool/rules/de/de-DE/grammar.xml")) continue;
                    System.out.println("No rule file found at " + ruleFilePath + " in classpath. THIS SHOULD BE FIXED!");
                    continue;
                }
                if (grammarFiles.size() > 1 && !grammarFiles.get(0).equals(grammarFile)) {
                    validator.validateWithXmlSchema(rulesDir + "/" + grammarFiles.get(0), ruleFilePath, rulesDir + "/rules.xsd");
                    continue;
                }
                validator.validateWithXmlSchema(ruleFilePath, rulesDir + "/rules.xsd");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (xmlStream == null) continue;
                if (throwable != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                xmlStream.close();
            }
        }
    }

    protected void validateRemoteRulesFile(Language lang) throws IOException {
        XMLValidator validator = new XMLValidator();
        String rulesDir = JLanguageTool.getDataBroker().getRulesDir();
        String remoteRulesFile = rulesDir + "/" + lang.getShortCode() + "/remote-rule-filters.xml";
        InputStream xmlStream = JLanguageTool.getDataBroker().getAsStream(remoteRulesFile);
        if (xmlStream != null) {
            System.out.println("Running XML validation for " + remoteRulesFile + "...");
            validator.validateWithXmlSchema(remoteRulesFile, remoteRulesFile, rulesDir + "/remote-rules.xsd");
        }
    }

    protected void validateRuleIds(Language lang, JLanguageTool lt) {
        List allRules = lt.getAllRules();
        HashSet<String> categoryIds = new HashSet<String>();
        new RuleIdValidator(lang).validateUniqueness();
        for (Rule rule : allRules) {
            Category category;
            String catId;
            if (rule.getId().equalsIgnoreCase("ID")) {
                System.err.println("WARNING: " + lang.getShortCodeWithCountryAndVariant() + " has a rule with id 'ID', this should probably be changed");
            }
            if (rule.getId().startsWith("DB_")) {
                Assert.fail((String)("Rule ID must not start with 'DB_', this prefix is reserved for internal use: " + rule.getId()));
            }
            if (rule.getId().contains("[") || rule.getId().contains("]")) {
                Assert.fail((String)("Rule ID must not contain '[...]': " + rule.getId()));
            }
            if (rule.getId().contains(" ")) {
                Assert.fail((String)("Rule ID must not contain a space: '" + rule.getId() + "'"));
            }
            if (rule.getId().length() > 79) {
                Assert.fail((String)("Rule ID too long, keep it <= 79 chars: " + rule.getId()));
            }
            if ((catId = (category = rule.getCategory()).getId().toString()).matches("[A-Z0-9_-]+") || categoryIds.contains(catId)) continue;
            System.err.println("WARNING: category id '" + catId + "' doesn't match expected regexp [A-Z0-9_-]+");
            categoryIds.add(catId);
        }
    }

    protected void validateSentenceStartNotInMarker(JLanguageTool lt) {
        System.out.println("Check that sentence start tag is not included in <marker>....");
        List rules = lt.getAllRules();
        for (Rule rule : rules) {
            List patternTokens;
            if (!(rule instanceof AbstractPatternRule) || (patternTokens = ((AbstractPatternRule)rule).getPatternTokens()) == null) continue;
            boolean hasExplicitMarker = patternTokens.stream().anyMatch(PatternToken::isInsideMarker);
            for (PatternToken patternToken : patternTokens) {
                if (!patternToken.isInsideMarker() && hasExplicitMarker || !patternToken.isSentenceStart()) continue;
                System.err.println("WARNING: Sentence start in <marker>: " + rule.getFullId() + " (hasExplicitMarker: " + hasExplicitMarker + ") - please move the <marker> so the SENT_START is not covered");
            }
        }
    }

    protected void validateUnifyIgnoreAtTheStartOfUnify(JLanguageTool lt) {
        System.out.println("Check that <unify-ignore> is not at the start of <unify>....");
        List rules = lt.getAllRules();
        block0: for (Rule rule : rules) {
            boolean hasUnify;
            List patternTokens;
            if (!(rule instanceof AbstractPatternRule) || (patternTokens = ((AbstractPatternRule)rule).getPatternTokens()) == null || !(hasUnify = patternTokens.stream().anyMatch(PatternToken::isUnified))) continue;
            for (PatternToken patternToken : patternTokens) {
                if (!patternToken.isUnified()) continue;
                if (!patternToken.isUnificationNeutral()) continue block0;
                String failure = "<ignore-unify> at the start of <unify> - please move the token outside of <unify>";
                this.addError((AbstractPatternRule)rule, failure);
                continue block0;
            }
        }
    }

    protected void validateParenthesisInSynthesisMatches(JLanguageTool lt) {
        System.out.println("Check parenthesis and back references in synthesis matches...");
        List rules = lt.getAllRules();
        for (Rule rule : rules) {
            if (!(rule instanceof AbstractPatternRule)) continue;
            AbstractPatternRule apRule = (AbstractPatternRule)rule;
            ArrayList suggestionMatches = new ArrayList();
            if (apRule.getSuggestionMatches() != null) {
                suggestionMatches.addAll(apRule.getSuggestionMatches());
            }
            if (apRule.getSuggestionMatchesOutMsg() != null) {
                suggestionMatches.addAll(apRule.getSuggestionMatchesOutMsg());
            }
            for (Match suggestionMatch : suggestionMatches) {
                int maxBackReference;
                long openingNum;
                if (suggestionMatch.getPosTag() == null || suggestionMatch.getPosTagReplace() == null || (openingNum = suggestionMatch.getPosTag().chars().filter(ch -> ch == 40).count()) >= (long)(maxBackReference = this.getMaxBackReferenceNo(suggestionMatch.getPosTagReplace()))) continue;
                String failure = "Back reference number (" + maxBackReference + ") is greater than existing number of parenthesis.";
                this.addError((AbstractPatternRule)rule, failure);
            }
        }
    }

    private int getMaxBackReferenceNo(String message) {
        Pattern pattern = Pattern.compile("\\$[0-9]");
        Matcher matcher = pattern.matcher(message);
        int maxNo = -1;
        while (matcher.find()) {
            int no = Integer.parseInt(matcher.group().replace("$", ""));
            if (no <= maxNo) continue;
            maxNo = no;
        }
        return maxNo;
    }

    protected void validateRegexpInSynthesisMatches(JLanguageTool lt) {
        System.out.println("Check that synthesis matches with POS tag regexp have POS tag regexp in the pattern...");
        List rules = lt.getAllRules();
        for (Rule rule : rules) {
            if (!(rule instanceof AbstractPatternRule)) continue;
            AbstractPatternRule apRule = (AbstractPatternRule)rule;
            List patternTokens = apRule.getPatternTokens();
            ArrayList suggestionMatches = new ArrayList();
            if (apRule.getSuggestionMatches() != null) {
                suggestionMatches.addAll(apRule.getSuggestionMatches());
            }
            if (apRule.getSuggestionMatchesOutMsg() != null) {
                suggestionMatches.addAll(apRule.getSuggestionMatchesOutMsg());
            }
            List<Integer> matchNos = this.getMatchNos(((AbstractPatternRule)rule).getMessage() + ((AbstractPatternRule)rule).getSuggestionsOutMsg());
            int i = 0;
            for (Match suggestionMatch : suggestionMatches) {
                if (suggestionMatch.isPostagRegexp()) {
                    int no = matchNos.get(i);
                    if (patternTokens != null && no > patternTokens.size()) {
                        System.err.println("Warning: Rule " + rule.getFullId() + " refers to token \\" + no + " but has only " + patternTokens.size() + " tokens.");
                    } else if (((PatternToken)patternTokens.get(no - 1)).getPOStag() == null) {
                        System.err.println("Warning: Rule " + rule.getFullId() + " refers to token \\" + no + " with a postag regular expression, but the token in the pattern has no postag.");
                    }
                }
                ++i;
            }
        }
    }

    private List<Integer> getMatchNos(String message) {
        Pattern pattern = Pattern.compile("\\\\[0-9]+");
        Matcher matcher = pattern.matcher(message);
        ArrayList<Integer> noList = new ArrayList<Integer>();
        while (matcher.find()) {
            noList.add(Integer.parseInt(matcher.group().replace("\\", "")));
        }
        return noList;
    }

    private static void disableSpellingRules(JLanguageTool lt) {
        List allRules = lt.getAllRules();
        for (Rule rule : allRules) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            lt.disableRule(rule.getId());
        }
    }

    protected void testRegexSyntax(Language lang, List<AbstractPatternRule> rules) {
        System.out.println("Checking regexp syntax of " + rules.size() + " rules for " + lang + "...");
        for (AbstractPatternRule rule : rules) {
            PatternTestTools.warnIfRegexpSyntaxNotKosher(rule.getPatternTokens(), rule.getId(), rule.getSubId(), lang);
            List antiPatterns = rule.getAntiPatterns();
            for (DisambiguationPatternRule antiPattern : antiPatterns) {
                PatternTestTools.warnIfRegexpSyntaxNotKosher(antiPattern.getPatternTokens(), antiPattern.getId(), antiPattern.getSubId(), lang);
            }
        }
    }

    protected void testMessages(Language lang, List<AbstractPatternRule> rules) {
        System.out.println("Checking messages for 'TBD' etc of " + rules.size() + " rules for " + lang + "...");
        for (AbstractPatternRule rule : rules) {
            String msg = rule.getMessage().trim();
            if (msg.trim().isEmpty()) {
                Assert.fail((String)("Empty message of rule " + rule.getFullId()));
            }
            if (rule.isDefaultTempOff() || rule.isDefaultOff()) continue;
            if (msg.equalsIgnoreCase("todo") || msg.equalsIgnoreCase("lorem ipsum")) {
                Assert.fail((String)("Unfinished message ('todo' or 'lorem ipsum') of rule " + rule.getFullId() + ": '" + msg + "'"));
            }
            if (!lang.getShortCode().matches("xx|en|km") && msg.toLowerCase().contains("did you mean")) {
                System.err.println("*** WARNING: Non-English message with 'did you mean' for rule " + rule.getFullId() + ": '" + msg + "'");
            }
            if (msg.toLowerCase().contains("tbd")) {
                Assert.fail((String)("Unfinished message (contains 'tbd') of rule " + rule.getFullId() + ": '" + msg + "'"));
            }
            if (msg.startsWith(">")) {
                System.err.println("*** WARNING: Message of rule " + rule.getFullId() + " starts with '>', is this a typo?: '" + rule.getMessage() + "'");
            }
            if (lang.getShortCode().matches("de|en|fr|es|nl") && !msg.trim().equals(rule.getMessage())) {
                System.err.println("*** WARNING: Message of rule " + rule.getFullId() + " starts or ends with spaces: '" + rule.getMessage() + "'");
            }
            if (!lang.getShortCode().equals("de") || msg.equals("Failing for testing purposes")) continue;
            if (msg.trim().endsWith("!")) {
                Assert.fail((String)("Message ends in '!' for rule " + rule.getFullId() + ": '" + msg + "'"));
            }
            if (msg.trim().matches(".*[.?)'\"]$")) continue;
            Assert.fail((String)("Message doesn't end with [.?)'\"] for rule " + rule.getFullId() + ": '" + msg + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(AbstractPatternRule rule, String failure) {
        PatternRuleErrorCollector patternRuleErrorCollector = this.ruleErrors;
        synchronized (patternRuleErrorCollector) {
            this.ruleErrors.addError(new PatternRuleTestFailure(rule, failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testGrammarRulesFromXML(List<AbstractPatternRule> rules, JLanguageTool allRulesLt, Language lang) {
        if (System.getProperty("skipRules") != null) {
            System.out.println("SKIPPING: Checking example sentences of " + rules.size() + " rules for " + lang + "...");
            return;
        }
        System.out.println("Checking example sentences of " + rules.size() + " rules for " + lang + "...");
        int threadCount = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            ThreadLocal<MultiThreadedJLanguageTool> lt = ThreadLocal.withInitial(() -> PatternRuleTest.createToolForTesting(lang));
            HashMap complexRules = new HashMap();
            int skipCount = 0;
            AtomicInteger i = new AtomicInteger();
            for (AbstractPatternRule abstractPatternRule : rules) {
                String sourceFile = abstractPatternRule.getSourceFile();
                if (lang.isVariant() && sourceFile != null && sourceFile.matches("/org/languagetool/rules/" + lang.getShortCode() + "/grammar.*\\.xml") && !sourceFile.contains("-l2-") && !lang.getShortCodeWithCountryAndVariant().equals("de-DE-x-simple-language") && !lang.getClass().getName().contains("PremiumOnly")) {
                    ++skipCount;
                    continue;
                }
                futures.add(executor.submit(() -> {
                    this.testCorrectSentences((JLanguageTool)lt.get(), allRulesLt, rule);
                    this.testBadSentences((JLanguageTool)lt.get(), allRulesLt, lang, complexRules, rule);
                    this.testErrorTriggeringSentences((JLanguageTool)lt.get(), rule);
                    if (i.incrementAndGet() % 100 == 0) {
                        System.out.println("Testing rule " + i + "...");
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println("Skipped " + skipCount + " rules for variant language to avoid checking rules more than once");
            if (!complexRules.isEmpty()) {
                Set set = complexRules.keySet();
                ArrayList<AbstractPatternRule> arrayList = new ArrayList<AbstractPatternRule>();
                for (String aSet : set) {
                    AbstractPatternRule badRule = (AbstractPatternRule)complexRules.get(aSet);
                    if (!(badRule instanceof PatternRule)) continue;
                    ((PatternRule)badRule).notComplexPhrase();
                    badRule.setMessage("The rule contains a phrase that never matched any incorrect example.\n" + ((PatternRule)badRule).toPatternString());
                    arrayList.add(badRule);
                }
                if (!arrayList.isEmpty()) {
                    this.testGrammarRulesFromXML(arrayList, allRulesLt, lang);
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private void testBadSentences(JLanguageTool lt, JLanguageTool allRulesLt, Language lang, Map<String, AbstractPatternRule> complexRules, AbstractPatternRule rule) throws IOException {
        List badSentences = rule.getIncorrectExamples();
        if (badSentences.isEmpty()) {
            this.addError(rule, "No incorrect examples found.");
            return;
        }
        List rules = allRulesLt.getPatternRulesByIdAndSubId(rule.getId(), rule.getSubId());
        for (IncorrectExample origBadExample : badSentences) {
            String marker;
            String origBadSentence = origBadExample.getExample().replaceAll("[\\n\\t]+", "");
            List expectedCorrections = origBadExample.getCorrections();
            int expectedMatchStart = origBadSentence.indexOf("<marker>");
            int expectedMatchEnd = origBadSentence.indexOf("</marker>") - "<marker>".length();
            if (expectedMatchStart == -1 || expectedMatchEnd == -1) {
                this.addError(rule, "No error position markup ('<marker>...</marker>') in bad example.");
                continue;
            }
            String badSentence = ExampleSentence.cleanMarkersInExample((String)origBadSentence);
            if (badSentence.trim().length() <= 0) {
                this.addError(rule, "Empty incorrect example sentence after cleaning/trimming.");
                continue;
            }
            if (origBadSentence.startsWith(">") && badSentence.length() > 1) {
                System.err.println("*** WARNING: example of rule " + rule.getFullId() + " starts with '>', is this a typo?: '" + origBadSentence + "'");
            }
            if ((marker = origBadSentence.substring(expectedMatchStart + "<marker>".length(), origBadSentence.indexOf("</marker>"))).startsWith(", ") && origBadExample.getCorrections().stream().anyMatch(k -> !k.startsWith(" ") && !k.startsWith(",") && !k.startsWith("?") && !k.startsWith(".") && !k.startsWith(":") && !k.startsWith(";") && !k.startsWith("\u2026") && !k.startsWith("-") && !k.startsWith("\u2013"))) {
                System.err.println("*** WARNING: " + lang.getName() + " rule " + rule.getFullId() + " removes ', ' but doesn't have a space, comma, colon, semicolon, hyphen or dot at the start of the suggestion: " + origBadSentence + " => " + origBadExample.getCorrections());
            }
            List<Object> matches = new ArrayList<RuleMatch>();
            for (Rule auxRule : rules) {
                if (lang.getShortCode().matches("gl|eo|br|ca|zh")) {
                    matches.addAll(this.getMatchesForSingleSentence(auxRule, badSentence, lt));
                    continue;
                }
                matches.addAll(this.getMatchesForText(auxRule, badSentence, lt));
            }
            if (rule instanceof RegexPatternRule || rule instanceof PatternRule && !((PatternRule)rule).isWithComplexPhrase()) {
                if (matches.size() != 1) {
                    AnalyzedSentence analyzedSentence = lt.getAnalyzedSentence(badSentence);
                    StringBuilder sb = new StringBuilder("Analyzed token readings:");
                    for (AnalyzedTokenReadings atr : analyzedSentence.getTokens()) {
                        sb.append(' ').append(atr);
                    }
                    String info = "";
                    if (rule instanceof RegexPatternRule) {
                        info = "\nRegexp: " + ((RegexPatternRule)rule).getPattern();
                    }
                    String failure = "\"" + badSentence + "\"\nErrors expected: 1\nErrors found   : " + matches.size() + "\nMessage: " + rule.getMessage() + "\n" + sb + "\nMatches: " + matches + info;
                    this.addError(rule, failure);
                    continue;
                }
                int maxReference = 0;
                if (rule.getSuggestionMatches() != null) {
                    Optional<Match> opt = rule.getSuggestionMatches().stream().max(MATCH_COMPARATOR);
                    maxReference = opt.isPresent() ? opt.get().getTokenRef() : 0;
                }
                maxReference = Math.max(rule.getMessage() != null ? this.findLargestReference(rule.getMessage()) : 0, maxReference);
                if (rule.getPatternTokens() != null && maxReference > rule.getPatternTokens().size()) {
                    System.err.println("Warning: Rule " + rule.getFullId() + " refers to token \\" + maxReference + " but has only " + rule.getPatternTokens().size() + " tokens.");
                }
                if (expectedMatchStart != ((RuleMatch)matches.get(0)).getFromPos() || expectedMatchEnd != ((RuleMatch)matches.get(0)).getToPos()) {
                    String matchPositions = String.format("(expected match position: %d - %d, actual: %d - %d)", expectedMatchStart, expectedMatchEnd, ((RuleMatch)matches.get(0)).getFromPos(), ((RuleMatch)matches.get(0)).getToPos());
                    this.addError(rule, "Incorrect match position markup " + matchPositions + " in sentence: " + badSentence);
                    continue;
                }
                this.assertSuggestions(badSentence, expectedCorrections, rule, matches);
                if (((RuleMatch)matches.get(0)).getSuggestedReplacements().size() <= 0) continue;
                int fromPos = ((RuleMatch)matches.get(0)).getFromPos();
                int toPos = ((RuleMatch)matches.get(0)).getToPos();
                for (String replacement : ((RuleMatch)matches.get(0)).getSuggestedReplacements()) {
                    String fixedSentence = badSentence.substring(0, fromPos) + replacement + badSentence.substring(toPos);
                    matches = this.getMatchesForText((Rule)rule, fixedSentence, lt);
                    if (matches.size() <= 0) continue;
                    this.addError(rule, "Incorrect input:\n  " + badSentence + "\nCorrected sentence:\n  " + fixedSentence + "\nThe correction triggered an error itself:\n  " + matches.get(0) + "\n");
                }
                continue;
            }
            matches = this.getMatchesForText((Rule)rule, badSentence, lt);
            if (matches.isEmpty() && !complexRules.containsKey(rule.getId() + badSentence)) {
                complexRules.put(rule.getId() + badSentence, rule);
            }
            if (matches.size() == 0) continue;
            complexRules.put(rule.getId() + badSentence, null);
            if (matches.size() != 1) {
                this.addError(rule, "Did expect one error in: \"" + badSentence + "\" , got " + matches.size());
                continue;
            }
            if (expectedMatchStart != ((RuleMatch)matches.get(0)).getFromPos() || expectedMatchEnd != ((RuleMatch)matches.get(0)).getToPos()) {
                String matchPositions = String.format("(expected match position: %d - %d, actual: %d - %d)", expectedMatchStart, expectedMatchEnd, ((RuleMatch)matches.get(0)).getFromPos(), ((RuleMatch)matches.get(0)).getToPos());
                this.addError(rule, "Incorrect match position markup " + matchPositions + "in sentence: " + badSentence);
                continue;
            }
            this.assertSuggestions(badSentence, expectedCorrections, rule, matches);
            this.assertSuggestionsDoNotCreateErrors(badSentence, lt, rule, matches);
        }
    }

    private int findLargestReference(String message) {
        Pattern pattern = Pattern.compile("\\\\[0-9]+");
        Matcher matcher = pattern.matcher(message);
        int max = 0;
        while (matcher.find()) {
            max = Math.max(max, Integer.parseInt(matcher.group().replace("\\", "")));
        }
        return max;
    }

    private void testErrorTriggeringSentences(JLanguageTool lt, AbstractPatternRule rule) throws IOException {
        for (ErrorTriggeringExample example : rule.getErrorTriggeringExamples()) {
            String sentence = this.cleanXML(example.getExample());
            List<RuleMatch> matches = this.getMatchesForText((Rule)rule, sentence, lt);
            if (!matches.isEmpty()) continue;
            this.addError(rule, "Example sentence marked with 'triggers_error' didn't actually trigger an error: '" + sentence + "'");
        }
    }

    private boolean rangeIsOverlapping(int a, int b, int x, int y) {
        if (a < x) {
            return x <= b;
        }
        return a <= y;
    }

    private void assertSuggestions(String sentence, List<String> expectedCorrections, AbstractPatternRule rule, List<RuleMatch> matches) {
        if (!expectedCorrections.isEmpty()) {
            List realSuggestions;
            boolean expectedNonEmptyCorrection;
            boolean bl = expectedNonEmptyCorrection = expectedCorrections.get(0).length() > 0;
            if (expectedNonEmptyCorrection && !rule.getMessage().contains("<suggestion>") && !rule.getSuggestionsOutMsg().contains("<suggestion>") && rule.getFilter() == null) {
                this.addError(rule, "You specified a correction, but your message has no suggestions. rule.getMessage(): " + rule.getMessage() + ", rule.getSuggestionsOutMsg(): " + rule.getSuggestionsOutMsg() + ", rule.getFullId():" + rule.getFullId());
            }
            if ((realSuggestions = matches.get(0).getSuggestedReplacements()).isEmpty()) {
                boolean expectedEmptyCorrection;
                boolean bl2 = expectedEmptyCorrection = expectedCorrections.size() == 1 && expectedCorrections.get(0).length() == 0;
                if (!expectedEmptyCorrection) {
                    this.addError(rule, "Incorrect suggestions: Expected '" + expectedCorrections + "', got   <no suggestion> on input: '" + sentence + "'");
                }
            } else if (!expectedCorrections.equals(realSuggestions)) {
                this.addError(rule, "Incorrect suggestions: Expected '" + String.join((CharSequence)"|", expectedCorrections) + "', got: '" + String.join((CharSequence)"|", realSuggestions) + "' on input: '" + sentence + "'");
            }
        }
    }

    private void assertSuggestionsDoNotCreateErrors(String badSentence, JLanguageTool lt, AbstractPatternRule rule, List<RuleMatch> matches) throws IOException {
        if (matches.get(0).getSuggestedReplacements().size() > 0) {
            int fromPos = matches.get(0).getFromPos();
            int toPos = matches.get(0).getToPos();
            for (String replacement : matches.get(0).getSuggestedReplacements()) {
                String fixedSentence = badSentence.substring(0, fromPos) + replacement + badSentence.substring(toPos);
                List<RuleMatch> tempMatches = this.getMatchesForText((Rule)rule, fixedSentence, lt);
                if (0 == tempMatches.size()) continue;
                this.addError(rule, "Corrected sentence for rule " + rule.getFullId() + " triggered error: " + fixedSentence);
            }
        }
    }

    private void testCorrectSentences(JLanguageTool lt, JLanguageTool allRulesLt, AbstractPatternRule rule) throws IOException {
        List goodSentences = rule.getCorrectExamples();
        List rules = allRulesLt.getPatternRulesByIdAndSubId(rule.getId(), rule.getSubId());
        for (CorrectExample goodSentenceObj : goodSentences) {
            String goodSentence = goodSentenceObj.getExample().replaceAll("[\\n\\t]+", "");
            if ((goodSentence = this.cleanXML(goodSentence)).trim().length() <= 0) {
                this.addError(rule, "Empty correct example.");
                continue;
            }
            if (goodSentence.startsWith(">") && goodSentence.length() > 1) {
                System.err.println("*** WARNING: example of rule " + rule.getFullId() + " starts with '>', is this a typo?: '" + goodSentence + "'");
            }
            boolean isMatched = false;
            for (Rule auxRule : rules) {
                isMatched = isMatched || this.match(auxRule, goodSentence, lt);
            }
            if (!isMatched) continue;
            AnalyzedSentence analyzedSentence = lt.getAnalyzedSentence(goodSentence);
            StringBuilder sb = new StringBuilder("Analyzed token readings:");
            for (AnalyzedTokenReadings atr : analyzedSentence.getTokens()) {
                sb.append(' ').append(atr);
            }
            String failure = "Did not expect error in:\n  " + goodSentence + "\n  " + sb + "\n";
            this.addError(rule, failure);
        }
    }

    protected String cleanXML(String str) {
        return str.replaceAll("<([^<].*?)>", "");
    }

    private boolean match(Rule rule, String sentence, JLanguageTool lt) throws IOException {
        List analyzedSentences = lt.analyzeText(sentence);
        int matchCount = 0;
        for (AnalyzedSentence analyzedSentence : analyzedSentences) {
            RuleMatch[] matches = rule.match(analyzedSentence);
            matchCount += matches.length;
        }
        return matchCount > 0;
    }

    private List<RuleMatch> getMatchesForText(Rule rule, String sentence, JLanguageTool lt) throws IOException {
        List analyzedSentences = lt.analyzeText(sentence);
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int matchOffset = 0;
        for (AnalyzedSentence analyzedSentence : analyzedSentences) {
            List<RuleMatch> sentenceMatches = Arrays.asList(rule.match(analyzedSentence));
            for (RuleMatch match : sentenceMatches) {
                match.setOffsetPosition(match.getFromPos() + matchOffset, match.getToPos() + matchOffset);
            }
            matches.addAll(sentenceMatches);
            matchOffset += analyzedSentence.getText().length();
        }
        return matches;
    }

    private List<RuleMatch> getMatchesForSingleSentence(Rule rule, String sentence, JLanguageTool lt) throws IOException {
        AnalyzedSentence analyzedSentence = lt.getAnalyzedSentence(sentence);
        RuleMatch[] matches = rule.match(analyzedSentence);
        return Arrays.asList(matches);
    }

    protected PatternRule makePatternRule(String s, boolean caseSensitive, boolean regex) {
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        String[] parts = s.split(" ");
        boolean pos = false;
        for (String element : parts) {
            if (element.equals("SENT_START")) {
                pos = true;
            }
            PatternToken pToken = !pos ? new PatternToken(element, caseSensitive, regex, false) : new PatternToken("", caseSensitive, regex, false);
            if (pos) {
                pToken.setPosToken(new PatternToken.PosToken(element, false, false));
            }
            patternTokens.add(pToken);
            pos = false;
        }
        return new PatternRule("ID1", TestTools.getDemoLanguage(), patternTokens, "test rule", "user visible message", "short comment");
    }

    public static void main(String[] args) throws Throwable {
        PatternRuleTest test = new PatternRuleTest();
        System.out.println("Running XML pattern tests...");
        System.out.println("LanguageTool version " + JLanguageTool.VERSION + " (" + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID + ")");
        if (args.length == 0) {
            test.runGrammarRulesFromXmlTestIgnoringLanguages(null);
        } else {
            Set<Language> ignoredLanguages = TestTools.getLanguagesExcept(args);
            test.runGrammarRulesFromXmlTestIgnoringLanguages(ignoredLanguages);
        }
        test.ruleErrors.check();
        System.out.println("Tests finished!");
    }

    static class PatternRuleErrorCollector
    extends ErrorCollector {
        private final boolean expectToFail;

        PatternRuleErrorCollector() {
            this.expectToFail = false;
        }

        PatternRuleErrorCollector(boolean expectToFail) {
            this.expectToFail = expectToFail;
        }

        public void check() throws Throwable {
            this.verify();
        }

        protected void verify() throws Throwable {
            if (this.expectToFail) {
                Throwable throwable = Assert.assertThrows(Throwable.class, () -> super.verify());
                System.out.println("PatternRuleErrorCollector verify fails as expected.");
                throwable.printStackTrace();
            } else {
                super.verify();
            }
        }
    }

    static class PatternRuleTestFailure
    extends Exception {
        private final AbstractPatternRule rule;
        private final String message;

        public PatternRuleTestFailure(AbstractPatternRule rule, String message) {
            this.rule = rule;
            this.message = message;
        }

        @Override
        public String getMessage() {
            return String.format("Test failure for rule %s in file %s (line %d): %s", this.rule.getFullId(), this.rule.getSourceFile(), this.rule.getXmlLineNumber(), this.message);
        }
    }
}

