
use builtin;
use str;

set edit:completion:arg-completer[ein] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'ein'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'ein'= {
            cand -t 'The amount of threads to use. If unset, use all cores, if 0 use al physical cores'
            cand --threads 'The amount of threads to use. If unset, use all cores, if 0 use al physical cores'
            cand -q 'Do not display verbose messages and progress information'
            cand --quiet 'Do not display verbose messages and progress information'
            cand --progress 'Bring up a terminal user interface displaying progress visually'
            cand --progress-keep-open 'The progress TUI will stay up even though the work is already completed'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand init 'Initialize the repository in the current directory'
            cand initialize 'Initialize the repository in the current directory'
            cand tool 'A selection of useful tools'
            cand t 'A selection of useful tools'
            cand completions 'Generate shell completions to stdout or a directory'
            cand generate-completions 'Generate shell completions to stdout or a directory'
            cand shell-completions 'Generate shell completions to stdout or a directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;init'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;initialize'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand find 'Find all repositories in a given directory'
            cand organize 'Move all repositories found in a directory into a structure matching their clone URLs'
            cand estimate-hours 'Estimate hours worked based on a commit history'
            cand h 'Estimate hours worked based on a commit history'
            cand hours 'Estimate hours worked based on a commit history'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;t'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand find 'Find all repositories in a given directory'
            cand organize 'Move all repositories found in a directory into a structure matching their clone URLs'
            cand estimate-hours 'Estimate hours worked based on a commit history'
            cand h 'Estimate hours worked based on a commit history'
            cand hours 'Estimate hours worked based on a commit history'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;tool;find'= {
            cand -d 'If set, print additional information to help understand why the traversal is slow'
            cand --debug 'If set, print additional information to help understand why the traversal is slow'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;t;find'= {
            cand -d 'If set, print additional information to help understand why the traversal is slow'
            cand --debug 'If set, print additional information to help understand why the traversal is slow'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool;organize'= {
            cand -f 'The directory to use when finding input repositories to move into position'
            cand --repository-source 'The directory to use when finding input repositories to move into position'
            cand -t 'The directory to which to move repositories found in the repository-source'
            cand --destination-directory 'The directory to which to move repositories found in the repository-source'
            cand --execute 'The operation will be in dry-run mode unless this flag is set'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;t;organize'= {
            cand -f 'The directory to use when finding input repositories to move into position'
            cand --repository-source 'The directory to use when finding input repositories to move into position'
            cand -t 'The directory to which to move repositories found in the repository-source'
            cand --destination-directory 'The directory to which to move repositories found in the repository-source'
            cand --execute 'The operation will be in dry-run mode unless this flag is set'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool;estimate-hours'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool;h'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool;hours'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;t;estimate-hours'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;t;h'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;t;hours'= {
            cand -b 'Ignore github bots which match the `[bot]` search string'
            cand --no-bots 'Ignore github bots which match the `[bot]` search string'
            cand -f 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand --file-stats 'Collect additional information about file modifications, additions and deletions (without rename tracking)'
            cand -l 'Collect additional information about lines added and deleted (without rename tracking)'
            cand --line-stats 'Collect additional information about lines added and deleted (without rename tracking)'
            cand -p 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand --show-pii 'Show personally identifiable information before the summary. Includes names and email addresses'
            cand -i 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand --omit-unify-identities 'Omit unifying identities by name and email which can lead to the same author appear multiple times due to using different names or email addresses'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ein;tool;help'= {
            cand find 'Find all repositories in a given directory'
            cand organize 'Move all repositories found in a directory into a structure matching their clone URLs'
            cand estimate-hours 'Estimate hours worked based on a commit history'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;tool;help;find'= {
        }
        &'ein;tool;help;organize'= {
        }
        &'ein;tool;help;estimate-hours'= {
        }
        &'ein;tool;help;help'= {
        }
        &'ein;t;help'= {
            cand find 'Find all repositories in a given directory'
            cand organize 'Move all repositories found in a directory into a structure matching their clone URLs'
            cand estimate-hours 'Estimate hours worked based on a commit history'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;t;help;find'= {
        }
        &'ein;t;help;organize'= {
        }
        &'ein;t;help;estimate-hours'= {
        }
        &'ein;t;help;help'= {
        }
        &'ein;completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ein;generate-completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ein;shell-completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ein;help'= {
            cand init 'Initialize the repository in the current directory'
            cand tool 'A selection of useful tools'
            cand completions 'Generate shell completions to stdout or a directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ein;help;init'= {
        }
        &'ein;help;tool'= {
            cand find 'Find all repositories in a given directory'
            cand organize 'Move all repositories found in a directory into a structure matching their clone URLs'
            cand estimate-hours 'Estimate hours worked based on a commit history'
        }
        &'ein;help;tool;find'= {
        }
        &'ein;help;tool;organize'= {
        }
        &'ein;help;tool;estimate-hours'= {
        }
        &'ein;help;completions'= {
        }
        &'ein;help;help'= {
        }
    ]
    $completions[$command]
}
