/*
 * Decompiled with CFR 0.152.
 */
package gps;

import bt747.sys.Generic;
import gps.Txt;

public final class BT747Constants {
    public static String[] logFmtItems = Txt.logFmtItems;
    public static final int FMT_UTC_IDX = 0;
    public static final int FMT_VALID_IDX = 1;
    public static final int FMT_LATITUDE_IDX = 2;
    public static final int FMT_LONGITUDE_IDX = 3;
    public static final int FMT_HEIGHT_IDX = 4;
    public static final int FMT_SPEED_IDX = 5;
    public static final int FMT_HEADING_IDX = 6;
    public static final int FMT_DSTA_IDX = 7;
    public static final int FMT_DAGE_IDX = 8;
    public static final int FMT_PDOP_IDX = 9;
    public static final int FMT_HDOP_IDX = 10;
    public static final int FMT_VDOP_IDX = 11;
    public static final int FMT_NSAT_IDX = 12;
    public static final int FMT_MAX_SATS = 32;
    public static final int FMT_SID_IDX = 13;
    public static final int FMT_ELEVATION_IDX = 14;
    public static final int FMT_AZIMUTH_IDX = 15;
    public static final int FMT_SNR_IDX = 16;
    public static final int FMT_RCR_IDX = 17;
    public static final int FMT_MILLISECOND_IDX = 18;
    public static final int FMT_DISTANCE_IDX = 19;
    public static final int FMT_ROYALTEKNEW_IDX = 20;
    public static final int FMT_LOG_PTS_WITH_VALID_FIX_ONLY_IDX = 31;
    public static final byte[] logFmtByteSizes = new byte[]{4, 2, 8, 8, 4, 4, 4, 2, 4, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] logFmtByteSizesHolux = new byte[]{4, 2, 4, 4, 3, 4, 4, 2, 4, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int RCR_TIME_MASK = 1;
    public static final int RCR_SPEED_MASK = 2;
    public static final int RCR_DISTANCE_MASK = 4;
    public static final int RCR_BUTTON_MASK = 8;
    public static final int RCR_APP0_MASK = 16;
    public static final int RCR_APP1_MASK = 32;
    public static final int RCR_APP2_MASK = 64;
    public static final int RCR_APP3_MASK = 128;
    public static final int RCR_APP4_MASK = 256;
    public static final int RCR_APP5_MASK = 512;
    public static final int RCR_APP6_MASK = 1024;
    public static final int RCR_APP7_MASK = 2048;
    public static final int RCR_APP8_MASK = 4096;
    public static final int RCR_APP9_MASK = 8192;
    public static final int RCR_APPY_MASK = 16384;
    public static final int RCR_APPZ_MASK = 32768;
    public static final int RCR_ALL_APP_MASK = 65520;
    public static final String[] C_STR_RCR = Txt.C_STR_RCR;
    public static final int C_RCR_COUNT = 16;
    public static final int PMTK_LOG_SET = 1;
    public static final int PMTK_LOG_Q = 2;
    public static final int PMTK_LOG_DT = 3;
    public static final int PMTK_LOG_ON = 4;
    public static final int PMTK_LOG_OFF = 5;
    public static final int PMTK_LOG_ERASE = 6;
    public static final int PMTK_LOG_Q_LOG = 7;
    public static final int PMTK_LOG_DT_LOG = 8;
    public static final int PMTK_LOG_INIT = 9;
    public static final int PMTK_LOG_ENABLE = 10;
    public static final int PMTK_LOG_DISABLE = 11;
    public static final int PMTK_LOG_WRITE = 12;
    public static final int PMTK_LOG_USER = 1;
    public static final int PMTK_LOG_FLASH_STAT = 1;
    public static final int PMTK_LOG_FORMAT = 2;
    public static final int PMTK_LOG_TIME_INTERVAL = 3;
    public static final int PMTK_LOG_DISTANCE_INTERVAL = 4;
    public static final int PMTK_LOG_SPEED_INTERVAL = 5;
    public static final int PMTK_LOG_REC_METHOD = 6;
    public static final int PMTK_LOG_LOG_STATUS = 7;
    public static final int PMTK_LOG_MEM_USED = 8;
    public static final int PMTK_LOG_FLASH = 9;
    public static final int PMTK_LOG_NBR_LOG_PTS = 10;
    public static final int PMTK_LOG_FLASH_SECTORS = 11;
    public static final int PMTK_LOG_VERSION = 12;
    public static final int PMTK_TEST = 0;
    public static final int PMTK_ACK = 1;
    public static final int PMTK_SYS_MSG = 8;
    public static final int PMTK_CMD_HOT_START = 101;
    public static final int PMTK_CMD_WARM_START = 102;
    public static final int PMTK_CMD_COLD_START = 103;
    public static final int PMTK_CMD_FULL_COLD_START = 104;
    public static final int PMTK_CMD_EPO_CLEAR = 127;
    public static final int PMTK_CMD_LOG = 182;
    public static final int PMTK_SET_NMEA_BAUD_RATE = 251;
    public static final int PMTK_SET_BIN_MODE = 253;
    public static final int PMTK_API_SET_FIX_CTL = 300;
    public static final int PMTK_API_SET_DGPS_MODE = 301;
    public static final int PMTK_API_SET_SBAS = 313;
    public static final int PMTK_API_SET_NMEA_OUTPUT = 314;
    public static final int PMTK_API_SET_SBAS_TEST = 319;
    public static final int PMTK_API_SET_PWR_SAV_MODE = 320;
    public static final int PMTK_API_SET_DATUM = 330;
    public static final int PMTK_API_SET_DATUM_ADVANCE = 331;
    public static final int PMTK_API_SET_USER_OPTION = 390;
    public static final int PMTK_API_SET_BT_MAC_ADDR = 392;
    public static final int PMTK_API_Q_FIX_CTL = 400;
    public static final int PMTK_API_Q_DGPS_MODE = 401;
    public static final int PMTK_API_Q_SBAS = 413;
    public static final int PMTK_API_Q_NMEA_OUTPUT = 414;
    public static final int PMTK_API_Q_SBAS_TEST = 419;
    public static final int PMTK_API_Q_PWR_SAV_MOD = 420;
    public static final int PMTK_API_Q_DATUM = 430;
    public static final int PMTK_API_Q_DATUM_ADVANCE = 431;
    public static final int PMTK_API_Q_GET_USER_OPTION = 490;
    public static final int PMTK_API_Q_BT_MAC_ADDR = 492;
    public static final int PMTK_DT_FIX_CTL = 500;
    public static final int PMTK_DT_DGPS_MODE = 501;
    public static final int PMTK_DT_SBAS = 513;
    public static final int PMTK_DT_NMEA_OUTPUT = 514;
    public static final int PMTK_DT_SBAS_TEST = 519;
    public static final int PMTK_DT_PWR_SAV_MODE = 520;
    public static final int PMTK_DT_DATUM = 530;
    public static final int PMTK_DT_FLASH_USER_OPTION = 590;
    public static final int PMTK_DT_BT_MAC_ADDR = 592;
    public static final int PMTK_Q_DGPS_INFO = 602;
    public static final int PMTK_Q_VERSION = 604;
    public static final int PMTK_Q_EPO_INFO = 607;
    public static final int PMTK_Q_RELEASE = 605;
    public static final int PMTK_DT_DGPS_INFO = 702;
    public static final int PMTK_DT_VERSION = 704;
    public static final int PMTK_DT_RELEASE = 705;
    public static final int PMTK_DT_EPO_INFO = 707;
    public static final int PMTK_SET_EPO_DATA = 722;
    public static final int PMTK_ACK_INVALID = 0;
    public static final int PMTK_ACK_UNSUPPORTED = 1;
    public static final int PMTK_ACK_FAILED = 2;
    public static final int PMTK_ACK_SUCCEEDED = 3;
    public static final String PMTK_LOG_ERASE_YES_STR = "1";
    public static final String PMTK_LOG_USER_STR = "1";
    public static final String PMTK_LOG_FLASH_STAT_STR = "1";
    public static final String PMTK_LOG_FORMAT_STR = "2";
    public static final String PMTK_LOG_TIME_INTERVAL_STR = "3";
    public static final String PMTK_LOG_DISTANCE_INTERVAL_STR = "4";
    public static final String PMTK_LOG_SPEED_INTERVAL_STR = "5";
    public static final String PMTK_LOG_REC_METHOD_STR = "6";
    public static final String PMTK_LOG_LOG_STATUS_STR = "7";
    public static final String PMTK_LOG_MEM_USED_STR = "8";
    public static final String PMTK_LOG_FLASH_STR = "9";
    public static final String PMTK_LOG_NBR_LOG_PTS_STR = "10";
    public static final String PMTK_LOG_FLASH_SECTORS_STR = "11";
    public static final String PMTK_LOG_VERSION_STR = "12";
    public static final int PMTK_LOG_STATUS_LOGISFULL_MASK = 2048;
    public static final int PMTK_LOG_STATUS_LOGMUSTINIT_MASK = 1024;
    public static final int PMTK_LOG_STATUS_LOGDISABLED_MASK = 512;
    public static final int PMTK_LOG_STATUS_LOGENABLED_MASK = 256;
    public static final int PMTK_LOG_STATUS_LOGSTOP_OVER_MASK = 4;
    public static final int PMTK_LOG_STATUS_LOGONOF_MASK = 2;
    public static final String PMTK_TEST_STR = "000";
    public static final String PMTK_ACK_STR = "001";
    public static final String PMTK_SYS_MSG_STR = "010";
    public static final String PMTK_CMD_HOT_START_STR = "101";
    public static final String PMTK_CMD_WARM_START_STR = "102";
    public static final String PMTK_CMD_COLD_START_STR = "103";
    public static final String PMTK_CMD_FULL_COLD_START_STR = "104";
    public static final String PMTK_CMD_LOG_STR = "182";
    public static final String PMTK_SET_NMEA_BAUD_RATE_STR = "251";
    public static final String PMTK_SET_BIN_MODE_STR = "253";
    public static final String PMTK_API_SET_FIX_CTL_STR = "300";
    public static final String PMTK_API_SET_DGPS_MODE_STR = "301";
    public static final String PMTK_API_SET_SBAS_STR = "313";
    public static final String PMTK_API_SET_NMEA_OUTPUT_STR = "314";
    public static final String PMTK_API_SET_SBAS_TEST_STR = "319";
    public static final String PMTK_API_SET_PWR_SAV_MODE_STR = "320";
    public static final String PMTK_API_SET_DATUM_STR = "330";
    public static final String PMTK_API_SET_DATUM_ADVANCE_STR = "331";
    public static final String PMTK_API_SET_USER_OPTION_STR = "390";
    public static final String PMTK_API_Q_FIX_CTL_STR = "400";
    public static final String PMTK_API_Q_DGPS_MODE_STR = "401";
    public static final String PMTK_API_Q_SBAS_STR = "413";
    public static final String PMTK_API_Q_NMEA_OUTPUT_STR = "414";
    public static final String PMTK_API_Q_SBAS_TEST_STR = "419";
    public static final String PMTK_API_Q_PWR_SAV_MOD_STR = "420";
    public static final String PMTK_API_Q_DATUM_STR = "430";
    public static final String PMTK_API_Q_DATUM_ADVANCE_STR = "431";
    public static final String PMTK_API_GET_USER_OPTION_STR = "490";
    public static final String PMTK_DT_FIX_CTL_STR = "500";
    public static final String PMTK_DT_DGPS_MODE_STR = "501";
    public static final String PMTK_DT_SBAS_STR = "513";
    public static final String PMTK_DT_NMEA_OUTPUT_STR = "514";
    public static final String PMTK_DT_SBAS_TEST_STR = "519";
    public static final String PMTK_DT_PWR_SAV_MODE_STR = "520";
    public static final String PMTK_DT_DATUM_STR = "530";
    public static final String PMTK_DT_FLASH_USER_OPTION_STR = "590";
    public static final String PMTK_Q_VERSION_STR = "604";
    public static final String PMTK_Q_RELEASE_STR = "605";
    public static final String PMTK_Q_DGPS_INFO_STR = "602";
    public static final String PMTK_ACK_INVALID_STR = "0";
    public static final String PMTK_ACK_UNSUPPORTED_STR = "1";
    public static final String PMTK_ACK_FAILED_STR = "2";
    public static final String PMTK_ACK_SUCCEEDED_STR = "3";
    public static final String HOLUX_MAIN_CMD = "HOLUX241,";
    public static final int HOLUX_API_SET_CONN = 1;
    public static final int HOLUX_API_SET_DISCONN = 2;
    public static final int HOLUX_API_Q_FIRMWARE_VERSION = 3;
    public static final int HOLUX_API_SET_NAME = 4;
    public static final int HOLUX_API_Q_NAME = 5;
    public static final int HOLUX_API_KEEP_ALIVE = 6;
    public static final int HOLUX_API_Q_HW_VERSION = 7;
    public static final int HOLUX_API_SET_TZ_OFFSET = 9;
    public static final int HOLUX_API_Q_TZ_OFFSET = 10;
    public static final int HOLUX_API_DT_FIRMWARE_VERSION = 3;
    public static final int HOLUX_API_DT_NAME = 5;
    public static final int HOLUX_API_DT_HW_VERSION = 7;
    public static final int HOLUX_API_DT_TZ_OFFSET = 10;
    public static final int GPS_TYPE_DEFAULT = 0;
    public static final int GPS_TYPE_GISTEQ_GISTEQ_ITRACKU_SIRFIII = 3;
    public static final int GPS_TYPE_HOLUX_GR245 = 4;
    public static final int GPS_TYPE_HOLUX_M241 = 5;
    public static final int GPS_TYPE_SKYTRAQ = 6;
    public static final int GPS_TYPE_GISTEQ_ITRACKU_NEMERIX = 1;
    public static final int GPS_TYPE_GISTEQ_ITRACKU_PHOTOTRACKR = 2;
    public static final int C_NMEA_SEN_COUNT = 19;
    private static final String[] NMEA_STRINGS = new String[]{"GLL", "RMC", "VTG", "GGA", "GSA", "GSV", "GRS", "GST", "?8", "?9", "?10", "?11", "?12", "MALM", "MEPH", "MDGP", "MDBG", "ZDA", "MCHN"};
    public static final int NMEA_SEN_GLL_IDX = 0;
    public static final int NMEA_SEN_RMC_IDX = 1;
    public static final int NMEA_SEN_VTG_IDX = 2;
    public static final int NMEA_SEN_GGA_IDX = 3;
    public static final int NMEA_SEN_GSA_IDX = 4;
    public static final int NMEA_SEN_GSV_IDX = 5;
    public static final int NMEA_SEN_GRS_IDX = 6;
    public static final int NMEA_SEN_GST_IDX = 7;
    public static final int NMEA_SEN_TYPE8_IDX = 8;
    public static final int NMEA_SEN_TYPE9_IDX = 9;
    public static final int NMEA_SEN_TYPE10_IDX = 10;
    public static final int NMEA_SEN_TYPE11_IDX = 11;
    public static final int NMEA_SEN_TYPE12_IDX = 12;
    public static final int NMEA_SEN_MALM_IDX = 13;
    public static final int NMEA_SEN_MEPH_IDX = 14;
    public static final int NMEA_SEN_MDGP_IDX = 15;
    public static final int NMEA_SEN_MDBG_IDX = 16;
    public static final int NMEA_SEN_ZDA_IDX = 17;
    public static final int NMEA_SEN_MCHN_IDX = 18;
    public static final int NMEA_SEN_WPL_IDX = 19;
    private static final int SPI_MAN_ID_EON = 28;
    private static final int SPI_MAN_ID_STMICROELECTRONICS = 32;
    private static final int SPI_MAN_ID_MACRONIX = 194;
    private static FlashInfo lastFlashInfo = null;
    public static final int VALID_NO_FIX_MASK = 1;
    public static final int VALID_SPS_MASK = 2;
    public static final int VALID_DGPS_MASK = 4;
    public static final int VALID_PPS_MASK = 8;
    public static final int VALID_RTK_MASK = 16;
    public static final int VALID_FRTK_MASK = 32;
    public static final int VALID_ESTIMATED_MASK = 64;
    public static final int VALID_MANUAL_MASK = 128;
    public static final int VALID_SIMULATOR_MASK = 256;
    public static final int NO_ERROR = 0;
    public static final int ERROR_COULD_NOT_OPEN = -1;
    public static final int ERROR_NO_FILES_WERE_CREATED = -2;
    public static final int ERROR_READING_FILE = -3;
    public static final int ERROR_UNKNOWN_OUTPUT_FORMAT = -4;
    public static final int HEIGHT_MSL = 0;
    public static final int HEIGHT_WGS84 = 1;
    private static final int[][] INIT_REFERENCE_LIST = new int[][]{{1, 1}, {7, 0}, {4, 0}, {6, 0}, {3, 0}, {14, 0}, {5, 1}, {2, 0}, {9, 1}, {8, 1}, {10, 0}, {11, 0}, {12, 0}, {13, 1}, {19, 0}, {18, 0}, {20, 0}, {21, 1}, {22, 1}};
    private static final int[] heightReferenceList = new int[22];
    public static final int[] timeZones;

    public static final int logRecordMinSize(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = 0;
            byte[] byArray = BT747Constants.getByteSizes(n2);
            do {
                if ((n & 1) != 0) {
                    switch (n4) {
                        case 14: 
                        case 15: 
                        case 16: {
                            break;
                        }
                        default: {
                            n3 += byArray[n4];
                        }
                    }
                }
                ++n4;
            } while ((n >>>= 1) != 0);
        }
        catch (Exception exception) {
            Generic.debug("Bad log format", exception);
        }
        return n3;
    }

    public static final int logRecordAndChecksumSize(int n, int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                n4 = 2;
                break;
            }
            case 4: 
            case 5: {
                n4 = 1;
            }
        }
        return n4 + BT747Constants.logRecordSize(n, n2, n3);
    }

    public static final int logRecordSize(int n, int n2, int n3) {
        int n4 = 0;
        byte[] byArray = BT747Constants.getByteSizes(n2);
        if ((n & 0x2000) != 0) {
            n4 = (0 + byArray[13] + ((n & 0x4000) != 0 ? byArray[14] : 0) + ((n & 0x8000) != 0 ? byArray[15] : 0) + ((n & 0x10000) != 0 ? byArray[16] : 0)) * (n3 - 1);
        }
        return n4 + BT747Constants.logRecordMinSize(n, n2);
    }

    public static final int logRecordMaxSize(int n, int n2) {
        return BT747Constants.logRecordSize(n, n2, 32);
    }

    private static final byte[] getByteSizes(int n) {
        switch (n) {
            default: {
                return logFmtByteSizes;
            }
            case 4: 
            case 5: 
        }
        return logFmtByteSizesHolux;
    }

    public static final int[] logRecordSatOffsetAndSize(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = BT747Constants.getByteSizes(n2);
        do {
            if ((n & 1) != 0) {
                switch (n3) {
                    case 2: 
                    case 3: {
                        n4 += byArray[n3];
                        break;
                    }
                    case 4: {
                        n4 += byArray[n3];
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        n5 += byArray[n3];
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        n4 += byArray[n3];
                    }
                }
            }
            ++n3;
        } while ((n >>>= 1) != 0);
        return new int[]{n4, n5};
    }

    public static final String modelName(int n, String string) {
        String string2;
        switch (n) {
            case 0: 
            case 1: 
            case 19: 
            case 81: {
                string2 = "iBlue 737/Qstarz 810";
                break;
            }
            case 2: {
                string2 = "Qstarz 815/iBlue 747";
                break;
            }
            case 5: {
                string2 = "Holux M-241/QT-1000P";
                break;
            }
            case 7: {
                string2 = "Just Mobile(r) Bluecard";
                break;
            }
            case 17: 
            case 27: {
                string2 = "iBlue 747";
                break;
            }
            case 29: {
                string2 = "747/Q1000/BGL-32";
                break;
            }
            case 35: 
            case 51: {
                string2 = "Holux M-241";
                break;
            }
            case 53: 
            case 80: {
                string2 = "Holux M1000C";
                break;
            }
            case 305: {
                string2 = "EB-85A";
                break;
            }
            case 5000: {
                string2 = "757/ZI v1";
                break;
            }
            case 8987: {
                string2 = "ML7";
                break;
            }
            case 20994: {
                string2 = "757/ZI v2";
                break;
            }
            case 33536: {
                string2 = "Qstarz BT-1200";
                break;
            }
            default: {
                string2 = "?";
            }
        }
        if (string.length() != 0) {
            if (string.startsWith("TSI_747A+")) {
                string2 = "iBlue 747 A+";
            } else if (string.startsWith("MBT-1100")) {
                string2 = "Royaltek MBT-1100";
            } else if (string.startsWith("TSI747")) {
                string2 = "iBlue 747";
            } else if (string.startsWith("TSI757")) {
                string2 = "iBlue 757";
            } else if (string.startsWith("TSI_821")) {
                string2 = "iBlue 821";
            } else if (string.startsWith("TSI_887")) {
                string2 = "photoMate887";
            } else if (string.equals("QST1000P")) {
                string2 = "Qstarz BT-1000P";
            } else if (string.equals("QST1000")) {
                string2 = "Qstarz BT-1000X";
            } else if (string.equals("QST1300")) {
                string2 = "Qstarz BT-1300";
            } else if (string.equals("GR-245")) {
                string2 = "Holux GPSport 245";
            } else if (string.equals("R150+")) {
                string2 = "NCS-NAVI 150+";
            }
        }
        return string2;
    }

    public static final String getNmeaDescription(int n) {
        return NMEA_STRINGS[n];
    }

    public static final int getFlashSize(int n) {
        return BT747Constants.getFlashinfo((int)n).memSize;
    }

    public static final String getFlashDesc(int n) {
        return BT747Constants.getFlashinfo((int)n).flashDescription;
    }

    private static final FlashInfo getFlashinfo(int n) {
        if (lastFlashInfo != null && BT747Constants.lastFlashInfo.flashID == n) {
            return lastFlashInfo;
        }
        FlashInfo flashInfo = new FlashInfo(n);
        int n2 = 0x200000;
        String string = "(??)";
        int n3 = n >>> 24;
        int n4 = n >> 16 & 0xFF;
        switch (n3) {
            case 194: {
                if (n4 != 32 && n4 != 36) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(MX," + n2 / 0x100000 + "MB)";
                break;
            }
            case 28: {
                if (n4 != 32 && n4 != 49 && n4 != 48) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(EON," + n2 / 0x100000 + "MB)";
                break;
            }
            case 32: {
                if (n4 != 32) break;
                n2 = 1 << (n >> 8 & 0xFF);
                string = "(STM," + n2 / 0x100000 + "MB)";
            }
        }
        flashInfo.memSize = n2;
        flashInfo.flashDescription = string;
        return flashInfo;
    }

    public static final int getHeightReference(int n) {
        if (n >= 0 && n < heightReferenceList.length) {
            return heightReferenceList[n];
        }
        return 1;
    }

    private static final void initValues() {
        for (int i = 0; i < INIT_REFERENCE_LIST.length; ++i) {
            if (INIT_REFERENCE_LIST[i][0] >= heightReferenceList.length) continue;
            BT747Constants.heightReferenceList[BT747Constants.INIT_REFERENCE_LIST[i][0]] = INIT_REFERENCE_LIST[i][1];
        }
    }

    public static final String[] getUtcStrings(String string) {
        String[] stringArray = new String[timeZones.length];
        for (int i = 0; i < timeZones.length; ++i) {
            int n = timeZones[i] - 48;
            int n2 = n / 4;
            if ((n = n % 4 * 15) < 0) {
                n = -n;
            }
            String string2 = string;
            if (n2 >= 0) {
                string2 = string2 + "+";
            }
            string2 = string2 + n2;
            if (n != 0) {
                string2 = string2 + ":" + n;
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }

    public static final int getUtcIdx(int n) {
        for (int i = 0; i < timeZones.length; ++i) {
            if (timeZones[i] < n) continue;
            return i;
        }
        return 0;
    }

    static {
        BT747Constants.initValues();
        timeZones = new int[]{0, 4, 8, 10, 12, 16, 20, 24, 28, 30, 32, 34, 36, 40, 44, 48, 52, 56, 60, 62, 64, 66, 68, 70, 71, 72, 74, 76, 80, 83, 84, 86, 88, 90, 92, 94, 96, 99, 100, 104};
    }

    static final class FlashInfo {
        int flashID;
        int memSize;
        String flashDescription;

        public FlashInfo(int n) {
            this.flashID = n;
        }
    }
}

