#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

from typing import Any

from ...types import Numeric
from .base import UUID, PGCompiler, PGDialect, PGIdentifierPreparer
from .hstore import HSTORE
from .json import JSON, JSONB

class _PGNumeric(Numeric):
    def bind_processor(self, dialect) -> None: ...
    def result_processor(self, dialect, coltype): ...

class _PGHStore(HSTORE):
    def bind_processor(self, dialect): ...
    def result_processor(self, dialect, coltype): ...

class _PGJSON(JSON):
    def bind_processor(self, dialect): ...
    def result_processor(self, dialect, coltype): ...

class _PGJSONB(JSONB):
    def bind_processor(self, dialect): ...
    def result_processor(self, dialect, coltype): ...

class _PGUUID(UUID):
    def bind_processor(self, dialect): ...
    def result_processor(self, dialect, coltype): ...

class _PGCompiler(PGCompiler):
    def visit_mod_binary(self, binary, operator, **kw): ...
    def post_process_text(self, text): ...

class _PGIdentifierPreparer(PGIdentifierPreparer): ...

class PGDialect_pygresql(PGDialect):
    driver: str
    supports_statement_cache: bool
    statement_compiler: Any
    preparer: Any
    @classmethod
    def dbapi(cls): ...
    colspecs: Any
    dbapi_version: Any
    supports_unicode_statements: bool
    supports_unicode_binds: bool
    has_native_hstore: Any
    has_native_json: Any
    has_native_uuid: Any
    def __init__(self, **kwargs) -> None: ...
    def create_connect_args(self, url): ...
    def is_disconnect(self, e, connection, cursor): ...

dialect = PGDialect_pygresql
