/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.CodeInsightContextInfoUnionKt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.UnionCapableScope;
import com.intellij.psi.search.UnionFileEnumeration;
import com.intellij.psi.search.UnionScope$Companion$tryUniting$;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B!\b\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\u0013\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\u001dH\u0014J\r\u0010)\u001a\u00070\u0010\u00a2\u0006\u0002\b*H\u0016J\r\u0010+\u001a\u00070\u0010\u00a2\u0006\u0002\b*H\u0016J\u0010\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0016R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/intellij/psi/search/UnionScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/psi/search/impl/VirtualFileEnumerationAware;", "Lcom/intellij/psi/search/CodeInsightContextAwareSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "myScopes", "", "<init>", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/search/GlobalSearchScope;)V", "getMyScopes", "()[Lcom/intellij/psi/search/GlobalSearchScope;", "[Lcom/intellij/psi/search/GlobalSearchScope;", "extractFileEnumeration", "Lcom/intellij/psi/search/impl/VirtualFileEnumeration;", "getDisplayName", "", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "codeInsightContextInfo", "Lcom/intellij/psi/search/CodeInsightContextInfo;", "getCodeInsightContextInfo", "()Lcom/intellij/psi/search/CodeInsightContextInfo;", "getUnloadedModulesBelongingToScope", "", "Lcom/intellij/openapi/module/UnloadedModuleDescription;", "compare", "", "file1", "file2", "isSearchInModuleContent", "module", "Lcom/intellij/openapi/module/Module;", "testSources", "isSearchInLibraries", "equals", "other", "", "calcHashCode", "toString", "Lorg/jetbrains/annotations/NonNls;", "toFullString", "uniteWith", "scope", "Companion", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nUnionScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnionScope.kt\ncom/intellij/psi/search/UnionScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,210:1\n1#2:211\n12970#3,2:212\n10890#3,5:214\n12970#3,2:219\n12970#3,2:221\n12970#3,2:223\n*S KotlinDebug\n*F\n+ 1 UnionScope.kt\ncom/intellij/psi/search/UnionScope\n*L\n47#1:212,2\n57#1:214,5\n84#1:219,2\n90#1:221,2\n96#1:223,2\n*E\n"})
public final class UnionScope
extends GlobalSearchScope
implements VirtualFileEnumerationAware,
CodeInsightContextAwareSearchScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope[] myScopes;

    private UnionScope(Project project, GlobalSearchScope[] myScopes) {
        super(project);
        this.myScopes = myScopes;
        if (!(this.myScopes.length >= 2)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("expected >= 2 scopes but got: ");
            String string = Arrays.toString(this.myScopes);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final GlobalSearchScope[] getMyScopes() {
        return this.myScopes;
    }

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        List fileEnumerations = new SmartList();
        for (GlobalSearchScope scope : this.myScopes) {
            VirtualFileEnumeration fileEnumeration = VirtualFileEnumeration.extract(scope);
            if (fileEnumeration == null) {
                return null;
            }
            fileEnumerations.add(fileEnumeration);
        }
        return new UnionFileEnumeration(fileEnumerations);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        Object[] objectArray = new Object[]{this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName()};
        return CoreBundle.message("psi.search.scope.union", objectArray);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(file, "file");
            GlobalSearchScope[] $this$any$iv = this.myScopes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                GlobalSearchScope element$iv;
                GlobalSearchScope scope = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                if (!scope.contains(file)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        return CodeInsightContextInfoUnionKt.createCodeInsightContextInfoUnion(this.myScopes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        void var2_2;
        void $this$flatMapTo$iv;
        GlobalSearchScope[] globalSearchScopeArray = this.myScopes;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$flatMapTo$iv[i];
            boolean bl = false;
            Collection<UnloadedModuleDescription> collection = it.getUnloadedModulesBelongingToScope();
            Intrinsics.checkNotNullExpressionValue(collection, "getUnloadedModulesBelongingToScope(...)");
            Iterable list$iv = collection;
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return var2_2;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file1, "file1");
        Intrinsics.checkNotNullParameter(file2, "file2");
        Ref.IntRef result = new Ref.IntRef();
        ContainerUtil.process(this.myScopes, arg_0 -> UnionScope.compare$lambda$0(file1, file2, result, arg_0));
        return result.element;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(module, "module");
            GlobalSearchScope[] $this$any$iv = this.myScopes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                GlobalSearchScope element$iv;
                GlobalSearchScope scope = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!scope.isSearchInModuleContent(module)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module, boolean testSources) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(module, "module");
            GlobalSearchScope[] $this$any$iv = this.myScopes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                GlobalSearchScope element$iv;
                GlobalSearchScope scope = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!scope.isSearchInModuleContent(module, testSources)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isSearchInLibraries() {
        boolean bl;
        block1: {
            GlobalSearchScope[] $this$any$iv = this.myScopes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                GlobalSearchScope element$iv;
                GlobalSearchScope obj = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!obj.isSearchInLibraries()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnionScope)) {
            return false;
        }
        GlobalSearchScope[] globalSearchScopeArray = this.myScopes;
        HashSet<GlobalSearchScope> hashSet = SetsKt.hashSetOf(Arrays.copyOf(globalSearchScopeArray, globalSearchScopeArray.length));
        globalSearchScopeArray = ((UnionScope)other).myScopes;
        return Intrinsics.areEqual(hashSet, SetsKt.hashSetOf(Arrays.copyOf(globalSearchScopeArray, globalSearchScopeArray.length)));
    }

    @Override
    protected int calcHashCode() {
        return Arrays.hashCode(this.myScopes);
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default(this.myScopes, (CharSequence)",", (CharSequence)"Union: (", (CharSequence)")", 0, null, null, 56, null);
    }

    @Override
    @NotNull
    public String toFullString() {
        return ArraysKt.joinToString$default(this.myScopes, (CharSequence)",", (CharSequence)"Union: (", (CharSequence)")", 0, null, UnionScope::toFullString$lambda$0, 24, null);
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        if (scope instanceof UnionScope) {
            GlobalSearchScope[] globalSearchScopeArray = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
            Intrinsics.checkNotNullExpressionValue(globalSearchScopeArray, "mergeArrays(...)");
            GlobalSearchScope[] newScopes = globalSearchScopeArray;
            return Companion.create(newScopes);
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "uniteWith(...)");
        return globalSearchScope;
    }

    private static final boolean compare$lambda$0(VirtualFile $file1, VirtualFile $file2, Ref.IntRef $result, GlobalSearchScope scope) {
        if (!scope.contains($file1) || !scope.contains($file2)) {
            return true;
        }
        int cmp = scope.compare($file1, $file2);
        if ($result.element == 0) {
            $result.element = cmp;
            return true;
        }
        if (cmp == 0) {
            return true;
        }
        if ($result.element > 0 == cmp > 0) {
            return true;
        }
        $result.element = 0;
        return false;
    }

    private static final CharSequence toFullString$lambda$0(GlobalSearchScope it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.toFullString();
        Intrinsics.checkNotNullExpressionValue(string, "toFullString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final GlobalSearchScope create(@NotNull GlobalSearchScope[] scopes) {
        return Companion.create(scopes);
    }

    public /* synthetic */ UnionScope(Project project, GlobalSearchScope[] myScopes, DefaultConstructorMarker $constructor_marker) {
        this(project, myScopes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/psi/search/UnionScope$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/psi/search/GlobalSearchScope;", "scopes", "", "([Lcom/intellij/psi/search/GlobalSearchScope;)Lcom/intellij/psi/search/GlobalSearchScope;", "tryCreateUnionFor2Scopes", "tryUniting", "", "", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nUnionScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnionScope.kt\ncom/intellij/psi/search/UnionScope$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,210:1\n1#2:211\n10890#3,5:212\n477#4:217\n*S KotlinDebug\n*F\n+ 1 UnionScope.kt\ncom/intellij/psi/search/UnionScope$Companion\n*L\n138#1:212,5\n193#1:217\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final GlobalSearchScope create(@NotNull GlobalSearchScope[] scopes) {
            void destination$iv;
            void $this$flatMapTo$iv;
            Project project;
            block9: {
                GlobalSearchScope unionScope;
                Intrinsics.checkNotNullParameter(scopes, "scopes");
                if (scopes.length == 2 && (unionScope = this.tryCreateUnionFor2Scopes(scopes)) != null) {
                    return unionScope;
                }
                for (GlobalSearchScope p0 : scopes) {
                    boolean bl = false;
                    project = p0.getProject();
                    if (project == null) {
                        continue;
                    }
                    break block9;
                }
                project = null;
            }
            Project project2 = project;
            GlobalSearchScope[] globalSearchScopeArray = scopes;
            Collection collection = new HashSet();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv).length;
            for (int i = 0; i < n; ++i) {
                List<Object> list;
                void element$iv;
                void scope = element$iv = $this$flatMapTo$iv[i];
                boolean bl = false;
                if (scope instanceof UnionScope) {
                    GlobalSearchScope[] globalSearchScopeArray2 = ((UnionScope)scope).getMyScopes();
                    list = CollectionsKt.listOf(Arrays.copyOf(globalSearchScopeArray2, globalSearchScopeArray2.length));
                } else {
                    list = scope == GlobalSearchScope.EMPTY_SCOPE ? CollectionsKt.emptyList() : CollectionsKt.listOf(scope);
                }
                Iterable list$iv = list;
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            HashSet flattened = (HashSet)destination$iv;
            if (flattened.isEmpty()) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                Intrinsics.checkNotNullExpressionValue(globalSearchScope, "EMPTY_SCOPE");
                return globalSearchScope;
            }
            if (flattened.size() == 1) {
                return (GlobalSearchScope)CollectionsKt.single(flattened);
            }
            Collection<GlobalSearchScope> united = this.tryUniting(flattened);
            if (united.size() == 1) {
                return (GlobalSearchScope)CollectionsKt.single((Iterable)united);
            }
            Intrinsics.checkNotNullExpressionValue(GlobalSearchScope.EMPTY_ARRAY, "EMPTY_ARRAY");
            return new UnionScope(project2, (GlobalSearchScope[])UtilKt.toArray(united, (Object[])GlobalSearchScope.EMPTY_ARRAY), null);
        }

        private final GlobalSearchScope tryCreateUnionFor2Scopes(GlobalSearchScope[] scopes) {
            boolean bl;
            boolean bl2 = bl = scopes.length == 2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            GlobalSearchScope scope0 = scopes[0];
            GlobalSearchScope scope1 = scopes[1];
            if (scope0 == GlobalSearchScope.EMPTY_SCOPE) {
                return scope1;
            }
            if (scope1 == GlobalSearchScope.EMPTY_SCOPE) {
                return scope0;
            }
            if (scope0 instanceof UnionScope && scope1 instanceof UnionScope) {
                return null;
            }
            Project project = scope0.getProject();
            if (project == null) {
                project = scope1.getProject();
            }
            Project project2 = project;
            return scope0 instanceof UnionScope ? com.intellij.psi.search.UnionScope$Companion.tryCreateUnionFor2Scopes$unionWithUnionScope((UnionScope)scope0, scope1, project2) : (scope1 instanceof UnionScope ? com.intellij.psi.search.UnionScope$Companion.tryCreateUnionFor2Scopes$unionWithUnionScope((UnionScope)scope1, scope0, project2) : (GlobalSearchScope)new UnionScope(project2, scopes, null));
        }

        private final Collection<GlobalSearchScope> tryUniting(Set<? extends GlobalSearchScope> scopes) {
            if (!(scopes.size() >= 2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)scopes);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, Companion$tryUniting$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence unionCapable = sequence;
            Iterator iterator2 = unionCapable.iterator();
            while (iterator2.hasNext()) {
                UnionCapableScope scope = (UnionCapableScope)iterator2.next();
                Intrinsics.checkNotNull(scope, "null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
                Set<GlobalSearchScope> others = SetsKt.minus(scopes, (GlobalSearchScope)((Object)scope));
                UnionCapableScope.UnionResult unionResult = scope.uniteWith((Collection<? extends GlobalSearchScope>)others);
                if (unionResult == null) continue;
                UnionCapableScope.UnionResult unionResult2 = unionResult;
                GlobalSearchScope united = unionResult2.component1();
                Set<GlobalSearchScope> leftScopes = unionResult2.component2();
                if (leftScopes.isEmpty()) {
                    return CollectionsKt.listOf(united);
                }
                return CollectionsKt.plus((Collection)CollectionsKt.listOf(united), (Iterable)this.tryUniting(leftScopes));
            }
            return scopes;
        }

        private static final GlobalSearchScope tryCreateUnionFor2Scopes$unionWithUnionScope(UnionScope unionScope, GlobalSearchScope otherScope, Project project) {
            GlobalSearchScope globalSearchScope;
            GlobalSearchScope[] scopes = unionScope.getMyScopes();
            if (ArraysKt.contains(scopes, otherScope)) {
                globalSearchScope = unionScope;
            } else {
                Set<GlobalSearchScope> set;
                Set<GlobalSearchScope> $this$tryCreateUnionFor2Scopes_u24unionWithUnionScope_u24lambda_u240 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                CollectionsKt.addAll((Collection)$this$tryCreateUnionFor2Scopes_u24unionWithUnionScope_u24lambda_u240, scopes);
                $this$tryCreateUnionFor2Scopes_u24unionWithUnionScope_u24lambda_u240.add(otherScope);
                Set toUnite = SetsKt.build(set);
                Collection<GlobalSearchScope> united = Companion.tryUniting(toUnite);
                if (united.size() == 1) {
                    return (GlobalSearchScope)CollectionsKt.single((Iterable)united);
                }
                Intrinsics.checkNotNullExpressionValue(GlobalSearchScope.EMPTY_ARRAY, "EMPTY_ARRAY");
                globalSearchScope = new UnionScope(project, (GlobalSearchScope[])UtilKt.toArray(united, (Object[])GlobalSearchScope.EMPTY_ARRAY), null);
            }
            return globalSearchScope;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

