/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import com.jetbrains.fus.reporting.configuration.CachingSupplier;
import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.configuration.HttpClientProcessor;
import com.jetbrains.fus.reporting.configuration.RequestResult;
import com.jetbrains.fus.reporting.configuration.ResponseProcessor;
import com.jetbrains.fus.reporting.model.config.v4.Configuration;
import com.jetbrains.fus.reporting.model.config.v4.ConfigurationVersion;
import com.jetbrains.fus.reporting.model.exceptions.StatsResponseException;
import com.jetbrains.fus.reporting.model.http.HttpClient;
import com.jetbrains.fus.reporting.model.http.HttpRequest;
import com.jetbrains.fus.reporting.model.http.HttpResponse;
import com.jetbrains.fus.reporting.model.serialization.Serializer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/fus/reporting/configuration/RemoteConfigurationClient;", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "configurationUrl", "", "productCode", "productVersion", "httpClient", "Lcom/jetbrains/fus/reporting/model/http/HttpClient;", "httpRequest", "Lcom/jetbrains/fus/reporting/model/http/HttpRequest;", "serializer", "Lcom/jetbrains/fus/reporting/model/serialization/Serializer;", "cacheTimeoutMs", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/fus/reporting/model/http/HttpClient;Lcom/jetbrains/fus/reporting/model/http/HttpRequest;Lcom/jetbrains/fus/reporting/model/serialization/Serializer;J)V", "cachedConfigurationVersion", "Lcom/jetbrains/fus/reporting/configuration/CachingSupplier;", "Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationVersion;", "getConfigurationUrl", "()Ljava/lang/String;", "getProductCode", "calculateConfigurationVersion", "loadConfiguration", "configuration"})
public final class RemoteConfigurationClient
extends ConfigurationClient {
    @NotNull
    private final String configurationUrl;
    @NotNull
    private final String productCode;
    @NotNull
    private final String productVersion;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final HttpRequest httpRequest;
    @NotNull
    private final Serializer serializer;
    @NotNull
    private final CachingSupplier<ConfigurationVersion> cachedConfigurationVersion;

    public RemoteConfigurationClient(@NotNull String configurationUrl, @NotNull String productCode, @NotNull String productVersion, @NotNull HttpClient httpClient, @NotNull HttpRequest httpRequest, @NotNull Serializer serializer2, long cacheTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.configurationUrl = configurationUrl;
        this.productCode = productCode;
        this.productVersion = productVersion;
        this.httpClient = httpClient;
        this.httpRequest = httpRequest;
        this.serializer = serializer2;
        this.cachedConfigurationVersion = new CachingSupplier<ConfigurationVersion>(this::loadConfiguration, cacheTimeoutMs);
    }

    @Override
    @NotNull
    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    @Override
    @NotNull
    public String getProductCode() {
        return this.productCode;
    }

    @Override
    @Nullable
    public ConfigurationVersion calculateConfigurationVersion() {
        return this.cachedConfigurationVersion.get();
    }

    private final ConfigurationVersion loadConfiguration() {
        ResponseProcessor<ConfigurationVersion> processor2 = new ResponseProcessor<ConfigurationVersion>(this){
            final /* synthetic */ RemoteConfigurationClient this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public ConfigurationVersion onSucceed(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                InputStream responseContent = response.read();
                if (responseContent != null) {
                    Closeable closeable = responseContent;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Object object = charset;
                    Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n = 8192;
                    closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    object = null;
                    try {
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl = false;
                        object2 = TextStreamsKt.readText((Reader)reader);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    Object content = object2;
                    Configuration configuration = RemoteConfigurationClient.access$getSerializer$p(this.this$0).deserializeConfiguration((String)content);
                    return configuration.findProductVersion(RemoteConfigurationClient.access$getProductVersion$p(this.this$0));
                }
                return null;
            }
        };
        RequestResult statsRequestResult = HttpClientProcessor.INSTANCE.send(this.httpClient, this.httpRequest, processor2);
        Integer n = statsRequestResult.getErrorCode();
        int n2 = -1;
        if (n == null || n != n2) {
            throw new StatsResponseException("Http response status code to get fus reporting configuration: " + statsRequestResult.getErrorCode() + ". Configuration url: " + this.getConfigurationUrl() + ". Product code: " + this.getProductCode() + ". Product version: " + this.productVersion + ".");
        }
        return (ConfigurationVersion)statsRequestResult.getResult();
    }

    public static final /* synthetic */ Serializer access$getSerializer$p(RemoteConfigurationClient $this) {
        return $this.serializer;
    }

    public static final /* synthetic */ String access$getProductVersion$p(RemoteConfigurationClient $this) {
        return $this.productVersion;
    }
}

