/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import javax.naming.NamingException;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;

public class PojoMessageHandlerWholeBinary
extends PojoMessageHandlerWholeBase<ByteBuffer> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBinary.class);
    private final boolean isForInputStream;

    public PojoMessageHandlerWholeBinary(Object object, Method method, Session session, EndpointConfig endpointConfig, List<Class<? extends Decoder>> list, Object[] objectArray, int n, boolean bl, int n2, boolean bl2, long l) {
        super(object, method, session, objectArray, n, bl, n2, l);
        if (l > -1L && l > (long)session.getMaxBinaryMessageBufferSize()) {
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxBinaryMessageBufferSize((int)l);
        }
        try {
            if (list != null) {
                for (Class<? extends Decoder> clazz : list) {
                    Decoder.Binary binary;
                    if (Decoder.Binary.class.isAssignableFrom(clazz)) {
                        binary = (Decoder.Binary)this.createDecoderInstance(clazz);
                        binary.init(endpointConfig);
                        this.decoders.add(binary);
                        continue;
                    }
                    if (!Decoder.BinaryStream.class.isAssignableFrom(clazz)) continue;
                    binary = (Decoder.BinaryStream)this.createDecoderInstance(clazz);
                    binary.init(endpointConfig);
                    this.decoders.add(binary);
                }
            }
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.isForInputStream = bl2;
    }

    @Override
    protected Object decode(ByteBuffer byteBuffer) throws DecodeException {
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Binary) {
                if (!((Decoder.Binary)decoder).willDecode(byteBuffer)) continue;
                return ((Decoder.Binary)decoder).decode(byteBuffer);
            }
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                return ((Decoder.BinaryStream)decoder).decode((InputStream)byteArrayInputStream);
            }
            catch (IOException iOException) {
                throw new DecodeException(byteBuffer, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)iOException);
            }
        }
        return null;
    }

    @Override
    protected Object convert(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        if (this.isForInputStream) {
            return new ByteArrayInputStream(byArray);
        }
        return byArray;
    }
}

