/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.tomcat.util.json.JSONFilter;

public class JsonAccessLogValve
extends AccessLogValve {
    private static final Map<Character, String> PATTERNS;
    private static final Map<Character, String> SUB_OBJECT_PATTERNS;

    private boolean addSubkeyedItems(ListIterator<AbstractAccessLogValve.AccessLogElement> listIterator, List<JsonWrappedElement> list, String string) {
        if (!list.isEmpty()) {
            listIterator.add(new AbstractAccessLogValve.StringElement("\"" + string + "\": {"));
            for (JsonWrappedElement jsonWrappedElement : list) {
                listIterator.add(jsonWrappedElement);
                listIterator.add(new CharElement(','));
            }
            listIterator.previous();
            listIterator.remove();
            listIterator.add(new AbstractAccessLogValve.StringElement("},"));
            return true;
        }
        return false;
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement[] createLogElements() {
        HashMap hashMap = new HashMap();
        for (Character serializable2 : SUB_OBJECT_PATTERNS.keySet()) {
            hashMap.put(serializable2, new ArrayList());
        }
        boolean bl = false;
        ArrayList<AbstractAccessLogValve.AccessLogElement> arrayList = new ArrayList<AbstractAccessLogValve.AccessLogElement>(Arrays.asList(super.createLogElements()));
        ListIterator<AbstractAccessLogValve.AccessLogElement> listIterator = arrayList.listIterator();
        listIterator.add(new CharElement('{'));
        while (listIterator.hasNext()) {
            AbstractAccessLogValve.AccessLogElement accessLogElement = (AbstractAccessLogValve.AccessLogElement)listIterator.next();
            if (!(accessLogElement instanceof JsonWrappedElement)) {
                listIterator.remove();
                continue;
            }
            JsonWrappedElement jsonWrappedElement = (JsonWrappedElement)accessLogElement;
            AbstractAccessLogValve.AccessLogElement accessLogElement2 = jsonWrappedElement.getDelegate();
            if (accessLogElement2 instanceof AbstractAccessLogValve.HeaderElement) {
                ((List)hashMap.get(Character.valueOf('i'))).add(jsonWrappedElement);
                listIterator.remove();
                continue;
            }
            if (accessLogElement2 instanceof AbstractAccessLogValve.ResponseHeaderElement) {
                ((List)hashMap.get(Character.valueOf('o'))).add(jsonWrappedElement);
                listIterator.remove();
                continue;
            }
            if (accessLogElement2 instanceof AbstractAccessLogValve.RequestAttributeElement) {
                ((List)hashMap.get(Character.valueOf('r'))).add(jsonWrappedElement);
                listIterator.remove();
                continue;
            }
            if (accessLogElement2 instanceof AbstractAccessLogValve.SessionAttributeElement) {
                ((List)hashMap.get(Character.valueOf('s'))).add(jsonWrappedElement);
                listIterator.remove();
                continue;
            }
            if (accessLogElement2 instanceof AbstractAccessLogValve.CookieElement) {
                ((List)hashMap.get(Character.valueOf('c'))).add(jsonWrappedElement);
                listIterator.remove();
                continue;
            }
            listIterator.add(new CharElement(','));
        }
        for (Character c : SUB_OBJECT_PATTERNS.keySet()) {
            if (!this.addSubkeyedItems(listIterator, (List)hashMap.get(c), SUB_OBJECT_PATTERNS.get(c))) continue;
            bl = true;
        }
        listIterator.previous();
        listIterator.remove();
        if (bl) {
            listIterator.add(new AbstractAccessLogValve.StringElement("}}"));
        } else {
            listIterator.add(new CharElement('}'));
        }
        return arrayList.toArray(new AbstractAccessLogValve.AccessLogElement[0]);
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(String string, char c) {
        AbstractAccessLogValve.AccessLogElement accessLogElement = super.createAccessLogElement(string, c);
        return new JsonWrappedElement(c, string, true, accessLogElement);
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(char c) {
        AbstractAccessLogValve.AccessLogElement accessLogElement = super.createAccessLogElement(c);
        return new JsonWrappedElement(c, true, accessLogElement);
    }

    static {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('a'), "remoteAddr");
        hashMap.put(Character.valueOf('A'), "localAddr");
        hashMap.put(Character.valueOf('b'), "size");
        hashMap.put(Character.valueOf('B'), "byteSentNC");
        hashMap.put(Character.valueOf('D'), "elapsedTime");
        hashMap.put(Character.valueOf('F'), "firstByteTime");
        hashMap.put(Character.valueOf('h'), "host");
        hashMap.put(Character.valueOf('H'), "protocol");
        hashMap.put(Character.valueOf('I'), "threadName");
        hashMap.put(Character.valueOf('l'), "logicalUserName");
        hashMap.put(Character.valueOf('m'), "method");
        hashMap.put(Character.valueOf('p'), "port");
        hashMap.put(Character.valueOf('q'), "query");
        hashMap.put(Character.valueOf('r'), "request");
        hashMap.put(Character.valueOf('s'), "statusCode");
        hashMap.put(Character.valueOf('S'), "sessionId");
        hashMap.put(Character.valueOf('t'), "time");
        hashMap.put(Character.valueOf('T'), "elapsedTimeS");
        hashMap.put(Character.valueOf('u'), "user");
        hashMap.put(Character.valueOf('U'), "path");
        hashMap.put(Character.valueOf('v'), "localServerName");
        hashMap.put(Character.valueOf('X'), "connectionStatus");
        PATTERNS = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put(Character.valueOf('c'), "cookies");
        hashMap.put(Character.valueOf('i'), "requestHeaders");
        hashMap.put(Character.valueOf('o'), "responseHeaders");
        hashMap.put(Character.valueOf('r'), "requestAttributes");
        hashMap.put(Character.valueOf('s'), "sessionAttributes");
        SUB_OBJECT_PATTERNS = Collections.unmodifiableMap(hashMap);
    }

    private static class JsonWrappedElement
    implements AbstractAccessLogValve.AccessLogElement,
    AbstractAccessLogValve.CachedElement {
        private CharSequence attributeName;
        private boolean quoteValue;
        private AbstractAccessLogValve.AccessLogElement delegate;

        private CharSequence escapeJsonString(CharSequence charSequence) {
            return JSONFilter.escape((CharSequence)charSequence);
        }

        JsonWrappedElement(char c, String string, boolean bl, AbstractAccessLogValve.AccessLogElement accessLogElement) {
            this.quoteValue = bl;
            this.delegate = accessLogElement;
            String string2 = (String)PATTERNS.get(Character.valueOf(c));
            if (string2 == null) {
                string2 = "other-" + Character.toString(c);
            }
            this.attributeName = string != null && !"".equals(string) ? (SUB_OBJECT_PATTERNS.containsKey(Character.valueOf(c)) ? this.escapeJsonString(string) : this.escapeJsonString(string2 + "-" + string)) : this.escapeJsonString(string2);
        }

        JsonWrappedElement(char c, boolean bl, AbstractAccessLogValve.AccessLogElement accessLogElement) {
            this(c, null, bl, accessLogElement);
        }

        public AbstractAccessLogValve.AccessLogElement getDelegate() {
            return this.delegate;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.append('\"').append(this.attributeName).append('\"').append(':');
            if (this.quoteValue) {
                charArrayWriter.append('\"');
            }
            this.delegate.addElement(charArrayWriter, date, request, response, l);
            if (this.quoteValue) {
                charArrayWriter.append('\"');
            }
        }

        @Override
        public void cache(Request request) {
            if (this.delegate instanceof AbstractAccessLogValve.CachedElement) {
                ((AbstractAccessLogValve.CachedElement)((Object)this.delegate)).cache(request);
            }
        }
    }

    protected static class CharElement
    implements AbstractAccessLogValve.AccessLogElement {
        private final char ch;

        public CharElement(char c) {
            this.ch = c;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.write(this.ch);
        }
    }
}

