# This file has been autogenerated by the pywayland scanner

# Copyright 2018 The Chromium Authors
# Copyright 2023 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..tablet_v2 import ZwpTabletToolV2
from ..wayland import WlPointer
from .wp_cursor_shape_device_v1 import WpCursorShapeDeviceV1


class WpCursorShapeManagerV1(Interface):
    """Cursor shape manager

    This global offers an alternative, optional way to set cursor images. This
    new way uses enumerated cursors instead of a
    :class:`~pywayland.protocol.wayland.WlSurface` like
    :func:`WlPointer.set_cursor()
    <pywayland.protocol.wayland.WlPointer.set_cursor>` does.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_cursor_shape_manager_v1"
    version = 1


class WpCursorShapeManagerV1Proxy(Proxy[WpCursorShapeManagerV1]):
    interface = WpCursorShapeManagerV1

    @WpCursorShapeManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        Destroy the cursor shape manager.
        """
        self._marshal(0)
        self._destroy()

    @WpCursorShapeManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpCursorShapeDeviceV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def get_pointer(self, pointer: WlPointer) -> Proxy[WpCursorShapeDeviceV1]:
        """Manage the cursor shape of a pointer device

        Obtain a
        :class:`~pywayland.protocol.cursor_shape_v1.WpCursorShapeDeviceV1` for
        a :class:`~pywayland.protocol.wayland.WlPointer` object.

        :param pointer:
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.cursor_shape_v1.WpCursorShapeDeviceV1`
        """
        cursor_shape_device = self._marshal_constructor(1, WpCursorShapeDeviceV1, pointer)
        return cursor_shape_device

    @WpCursorShapeManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpCursorShapeDeviceV1),
        Argument(ArgumentType.Object, interface=ZwpTabletToolV2),
    )
    def get_tablet_tool_v2(self, tablet_tool: ZwpTabletToolV2) -> Proxy[WpCursorShapeDeviceV1]:
        """Manage the cursor shape of a tablet tool device

        Obtain a
        :class:`~pywayland.protocol.cursor_shape_v1.WpCursorShapeDeviceV1` for
        a :class:`~pywayland.protocol.tablet_v2.ZwpTabletToolV2` object.

        :param tablet_tool:
        :type tablet_tool:
            :class:`~pywayland.protocol.tablet_v2.ZwpTabletToolV2`
        :returns:
            :class:`~pywayland.protocol.cursor_shape_v1.WpCursorShapeDeviceV1`
        """
        cursor_shape_device = self._marshal_constructor(2, WpCursorShapeDeviceV1, tablet_tool)
        return cursor_shape_device


class WpCursorShapeManagerV1Resource(Resource):
    interface = WpCursorShapeManagerV1


class WpCursorShapeManagerV1Global(Global):
    interface = WpCursorShapeManagerV1


WpCursorShapeManagerV1._gen_c()
WpCursorShapeManagerV1.proxy_class = WpCursorShapeManagerV1Proxy
WpCursorShapeManagerV1.resource_class = WpCursorShapeManagerV1Resource
WpCursorShapeManagerV1.global_class = WpCursorShapeManagerV1Global
