/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.Collection;
import java.util.HashSet;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;

public class MappingCandidateHarvester
extends CandidateHarvester {
    protected TransportAddress mask;
    protected TransportAddress face;

    public MappingCandidateHarvester(TransportAddress mask, TransportAddress face) {
        this.mask = mask;
        this.face = face;
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        if (this.getMask() == null || this.getFace() == null) {
            return null;
        }
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        for (Candidate candidate : component.getLocalCandidates()) {
            if (!(candidate instanceof HostCandidate) || !candidate.getTransportAddress().getHostAddress().equals(this.getFace().getHostAddress()) || candidate.getTransport() != this.getFace().getTransport()) continue;
            HostCandidate hostCandidate = (HostCandidate)candidate;
            TransportAddress mappedAddress = new TransportAddress(this.getMask().getHostAddress(), hostCandidate.getHostAddress().getPort(), hostCandidate.getHostAddress().getTransport());
            ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(mappedAddress, hostCandidate, hostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
            if (hostCandidate.isSSL()) {
                mappedCandidate.setSSL(true);
            }
            if (candidates.contains(mappedCandidate) || !component.addLocalCandidate(mappedCandidate)) continue;
            candidates.add(mappedCandidate);
        }
        return candidates;
    }

    public TransportAddress getMask() {
        return this.mask;
    }

    public TransportAddress getFace() {
        return this.face;
    }
}

