/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.UsageView;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Key<Boolean> REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.REUSABLE_CONTENT_KEY");
    private final Key<Boolean> NOT_REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.NOT_REUSABLE_CONTENT_KEY");
    private final Key<UsageView> NEW_USAGE_VIEW_KEY = Key.create((String)"NEW_USAGE_VIEW_KEY");
    private final ContentManager myFindContentManager;

    public UsageViewManagerImpl(Project project, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.FIND, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
        toolWindow.setHelpId("ideaInterface.find");
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowFind);
        this.myFindContentManager = toolWindow.getContentManager();
        this.myFindContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                event.getContent().release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/usageView/impl/UsageViewManagerImpl$1", "contentRemoved"));
            }
        });
        new ContentManagerWatcher(toolWindow, this.myFindContentManager);
    }

    @NotNull
    public Content addContent(String contentName, boolean reusable, JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        Content content = this.addContent(contentName, null, null, reusable, component, toOpenInNewTab, isLockable);
        if (content == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(0);
        }
        return content;
    }

    @NotNull
    public Content addContent(String contentName, String tabName, String toolwindowTitle, boolean reusable, JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content contentToDelete = null;
        if (!toOpenInNewTab && reusable) {
            Content[] contents;
            for (Content content : contents = this.myFindContentManager.getContents()) {
                UsageView usageView;
                if (content.isPinned() || content.getUserData(contentKey) == null || (usageView = (UsageView)content.getUserData(this.NEW_USAGE_VIEW_KEY)) != null && usageView.isSearchInProgress()) continue;
                contentToDelete = content;
            }
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, contentName, isLockable);
        content.setTabName(tabName);
        content.setToolwindowTitle(toolwindowTitle);
        content.putUserData(contentKey, (Object)Boolean.TRUE);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myFindContentManager.addContent(content);
        if (contentToDelete != null) {
            this.myFindContentManager.removeContent(contentToDelete, true);
        }
        this.myFindContentManager.setSelectedContent(content);
        Content content2 = content;
        if (content2 == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(1);
        }
        return content2;
    }

    public int getReusableContentsCount() {
        return this.getContentCount(true);
    }

    private int getContentCount(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content[] contents = this.myFindContentManager.getContents();
        return (int)Arrays.stream(contents).filter(content -> content.getUserData(contentKey) != null).count();
    }

    public Content getSelectedContent(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.myFindContentManager.getSelectedContent();
        return selectedContent == null || selectedContent.getUserData(contentKey) == null ? null : selectedContent;
    }

    public Content getSelectedContent() {
        return this.myFindContentManager == null ? null : this.myFindContentManager.getSelectedContent();
    }

    public void closeContent(@NotNull Content content) {
        if (content == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(2);
        }
        this.myFindContentManager.removeContent(content, true);
        content.release();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/impl/UsageViewManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/impl/UsageViewManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "closeContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

