/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class TreeCollector<T> {
    private final AtomicReference<List<T>> reference;
    private final AtomicLong counter;
    private final BiPredicate<? super T, ? super T> predicate;

    private TreeCollector(@NotNull BiPredicate<? super T, ? super T> predicate) {
        if (predicate == null) {
            TreeCollector.$$$reportNull$$$0(0);
        }
        this.reference = new AtomicReference();
        this.counter = new AtomicLong();
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<T> get() {
        AtomicReference<List<T>> atomicReference = this.reference;
        // MONITORENTER : atomicReference
        List list3 = this.reference.getAndSet(null);
        List list2 = list3 != null ? list3 : Collections.emptyList();
        // MONITOREXIT : atomicReference
        if (list2 != null) return list2;
        TreeCollector.$$$reportNull$$$0(1);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NotNull T object) {
        if (object == null) {
            TreeCollector.$$$reportNull$$$0(2);
        }
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List<T> list2 = this.reference.get();
            if (list2 == null) {
                this.reference.set((List<T>)new SmartList(object));
            } else {
                for (T parent : list2) {
                    if (!this.predicate.test(parent, object)) continue;
                    return false;
                }
                list2.removeIf(t -> this.predicate.test(object, t));
                list2.add(object);
            }
            return true;
        }
    }

    public void processLater(@NotNull Invoker invoker, @NotNull Consumer<? super List<T>> consumer) {
        if (invoker == null) {
            TreeCollector.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            TreeCollector.$$$reportNull$$$0(4);
        }
        long count = this.counter.incrementAndGet();
        invoker.invokeLater(() -> {
            if (count == this.counter.get()) {
                consumer.accept(this.get());
            }
        }, 10);
    }

    public static TreeCollector<VirtualFile> createFileLeafsCollector() {
        return new TreeCollector<VirtualFile>((child2, parent) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child2, (boolean)false));
    }

    public static TreeCollector<VirtualFile> createFileRootsCollector() {
        return new TreeCollector<VirtualFile>((parent, child2) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child2, (boolean)false));
    }

    public static TreeCollector<TreePath> createPathLeafsCollector() {
        return new TreeCollector<TreePath>((child2, parent) -> parent.isDescendant((TreePath)child2));
    }

    public static TreeCollector<TreePath> createPathRootsCollector() {
        return new TreeCollector<TreePath>((parent, child2) -> parent.isDescendant((TreePath)child2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreeCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreeCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

