/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import java.awt.Color;

public final class ErrorStripe
implements Comparable<ErrorStripe> {
    private final Color myColor;
    private final int myLayer;

    private ErrorStripe(Color color, int layer) {
        this.myColor = color;
        this.myLayer = layer;
    }

    public static ErrorStripe create(Color color, int layer) {
        return color == null ? null : new ErrorStripe(color, layer);
    }

    public Color getColor() {
        return this.myColor;
    }

    public int getLayer() {
        return this.myLayer;
    }

    public int hashCode() {
        return this.myLayer + this.myColor.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ErrorStripe) {
            ErrorStripe stripe = (ErrorStripe)object;
            return stripe.myLayer == this.myLayer && stripe.myColor.getRGB() == this.myColor.getRGB();
        }
        return false;
    }

    @Override
    public int compareTo(ErrorStripe stripe) {
        if (stripe == this) {
            return 0;
        }
        if (stripe == null || stripe.myLayer < this.myLayer) {
            return -1;
        }
        if (stripe.myLayer > this.myLayer) {
            return 1;
        }
        int thisRGB = this.myColor.getRGB();
        int thatRGB = stripe.myColor.getRGB();
        if (thatRGB == thisRGB) {
            return 0;
        }
        return thatRGB < thisRGB ? -1 : 1;
    }
}

