/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedPsiCachedValueProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class InjectedLanguageUtil {
    private static final Logger LOG = Logger.getInstance(InjectedLanguageUtil.class);
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create((String)"INJECTED_FRAGMENT_TYPE");
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final Key<List<TokenInfo>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    private static final InjectedPsiCachedValueProvider INJECTED_PSI_PROVIDER = new InjectedPsiCachedValueProvider();
    private static final Key<ParameterizedCachedValue<InjectionResult, PsiElement>> INJECTED_PSI = Key.create((String)"INJECTED_PSI");
    private static final Key<ConcurrentList<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(1);
        }
        if (containingFile instanceof DummyHolder && (context = containingFile.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        PsiElement psiElement = host;
        if (psiElement == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public static List<TokenInfo> getHighlightTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(3);
        }
        return (List)file2.getUserData(HIGHLIGHT_TOKENS);
    }

    static void setHighlightTokens(@NotNull PsiFile file2, @NotNull List<TokenInfo> tokens) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(4);
        }
        if (tokens == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(5);
        }
        file2.putUserData(HIGHLIGHT_TOKENS, tokens);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(6);
        }
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtil.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(7);
        }
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return InjectedLanguageUtil.getShreds(myFileViewProvider.getDocument());
    }

    @NotNull
    private static Place getShreds(@NotNull DocumentWindow document) {
        if (document == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(8);
        }
        Place place = ((DocumentWindowImpl)document).getShreds();
        if (place == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(9);
        }
        return place;
    }

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement element;
        Segment[] ranges;
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(10);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(11);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(12);
        }
        Segment rangeMarker = (ranges = documentWindow.getHostRanges()).length > 0 ? ranges[0] : null;
        PsiElement psiElement = element = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element != null) {
            InjectedLanguageUtil.enumerate(element, hostPsiFile, true, visitor);
        }
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(13);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(14);
        }
        PsiFile containingFile = host.getContainingFile();
        PsiUtilCore.ensureValid((PsiElement)containingFile);
        return InjectedLanguageUtil.enumerate(host, containingFile, true, visitor);
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiDocumentManager documentManager;
        Document document;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(15);
        }
        if (containingFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(16);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(17);
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (context == null) {
                return false;
            }
            PsiFile file2 = context.getContainingFile();
            if (file2 == null || !file2.isPhysical() && file2.getOriginalFile() == file2) {
                return false;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return false;
        }
        PsiElement inTree = InjectedLanguageUtil.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)containingFile.getProject())).getDocument(containingFile)) == null || documentManager.isCommitted(document)) {
            InjectedLanguageUtil.probeElementsUp(host, containingFile, probeUp, visitor);
        }
        return true;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2, offset);
    }

    static boolean mightHaveInjectedFragmentAtCaret(@NotNull Project project, @NotNull Document hostDocument, int hostOffset) {
        PsiFile hostPsiFile;
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(18);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(19);
        }
        if ((hostPsiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(hostDocument)) == null || !hostPsiFile.isValid()) {
            return false;
        }
        List documents = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostPsiFile, TextRange.create((int)hostOffset, (int)hostOffset));
        for (DocumentWindow document : documents) {
            if (!document.isValid() || document.getHostRange(hostOffset) == null) continue;
            return true;
        }
        return false;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable Caret caret, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow || caret == null) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file2) {
        if (caret == null || file2 == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List files2;
        if (expression == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(20);
        }
        if (classToFind == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(21);
        }
        if ((files2 = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null) {
            return null;
        }
        for (Pair fileInfo : files2) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2, int offset) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(22);
        }
        Editor editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(23);
        }
        return editor;
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @NotNull Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(24);
        }
        if (hostCaret == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(25);
        }
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(26);
            }
            return editor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(27);
            }
            return editor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(28);
            }
            return editor;
        }
        if (!documentWindow.isValid()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(29);
            }
            return editor;
        }
        Editor editor = EditorWindowImpl.create(documentWindow, (EditorImpl)hostEditor, injectedFile);
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(30);
        }
        return editor;
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        PsiElement injected;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(31);
        }
        return (injected = InjectedLanguageManager.getInstance((Project)host.getProject()).findInjectedElementAt(host, offset)) == null ? null : injected.getContainingFile();
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(32);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result2 = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            result2 = InjectedLanguageUtil.tryOffset(file2, offset, documentManager);
            PsiElement injected = (PsiElement)result2.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result2 != null && baseLanguage == result2.third) {
            return (PsiElement)result2.second;
        }
        return viewProvider.findElementAt(offset, baseLanguage);
    }

    private static void probeElementsUp(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement current;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(33);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(34);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(35);
        }
        PsiManager psiManager = hostPsiFile.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        InjectionResult result2 = null;
        for (current = element; current != null && current != hostPsiFile && !(current instanceof PsiDirectory); current = current.getParent()) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current.getLanguage().getID())) break;
            ParameterizedCachedValue data = (ParameterizedCachedValue)current.getUserData(INJECTED_PSI);
            if (data == null || (result2 = (InjectionResult)data.getValue((Object)current)) == null || !result2.isValid()) {
                result2 = InjectedPsiCachedValueProvider.doCompute(current, injectedManager, project, hostPsiFile);
            }
            if (result2 == null) continue;
            if (result2.files != null) {
                for (PsiFile psiFile : result2.files) {
                    boolean intersects;
                    Place place = InjectedLanguageUtil.getShreds(psiFile);
                    if (!place.isValid() || !(intersects = InjectedLanguageUtil.intersects(element, place))) continue;
                    visitor.visit(psiFile, (List)((Object)place));
                }
            }
            if (result2.references == null || !(visitor instanceof InjectedReferenceVisitor)) break;
            InjectedReferenceVisitor refVisitor = (InjectedReferenceVisitor)visitor;
            for (Pair<ReferenceInjector, Place> pair : result2.references) {
                boolean intersects;
                Place place = (Place)((Object)pair.getSecond());
                if (!place.isValid() || !(intersects = InjectedLanguageUtil.intersects(element, place))) continue;
                ReferenceInjector injector = (ReferenceInjector)pair.getFirst();
                refVisitor.visitInjectedReference(injector, (List<? extends PsiLanguageInjectionHost.Shred>)((Object)place));
            }
            break;
        }
        if (probeUp) {
            for (PsiElement e = element; e != current && e != null && e != hostPsiFile; e = e.getParent()) {
                ProgressManager.checkCanceled();
                if (result2 == null) {
                    e.putUserData(INJECTED_PSI, null);
                    continue;
                }
                PsiParameterizedCachedValue cachedValue = (PsiParameterizedCachedValue)CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)INJECTED_PSI_PROVIDER, false);
                CachedValueProvider.Result result3 = CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, result2});
                cachedValue.setValue(result3);
                e.putUserData(INJECTED_PSI, (Object)cachedValue);
            }
        }
    }

    private static boolean intersects(@NotNull PsiElement hostElement, @NotNull Place place) {
        if (hostElement == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(36);
        }
        if (place == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(37);
        }
        TextRange hostElementRange = hostElement.getTextRange();
        boolean intersects = false;
        Iterator iterator = place.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null || !shredHost.getTextRange().intersects(hostElementRange)) continue;
            intersects = true;
            break;
        }
        return intersects;
    }

    static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset) {
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(38);
        }
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project = hostFile.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Trinity<PsiElement, PsiElement, Language> result2 = InjectedLanguageUtil.tryOffset(hostFile, offset, documentManager);
        return (PsiElement)result2.first;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset, @NotNull PsiDocumentManager documentManager) {
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(39);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(40);
        }
        FileViewProvider provider = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element = provider.findElementAt(offset, language);
            if (element != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element;
                }
                if ((injected2 = InjectedLanguageUtil.findInside(element, hostFile, offset, documentManager)) != null) {
                    Trinity trinity = Trinity.create((Object)injected2, (Object)element, (Object)language);
                    if (trinity == null) {
                        InjectedLanguageUtil.$$$reportNull$$$0(41);
                    }
                    return trinity;
                }
            }
            if (offset == 0 || element != null && element.getTextRange().getStartOffset() != offset || (leftElement = provider.findElementAt(offset - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset || (injected = InjectedLanguageUtil.findInside(leftElement, hostFile, offset, documentManager)) == null) continue;
            Trinity trinity = Trinity.create((Object)injected, (Object)element, (Object)language);
            if (trinity == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(42);
            }
            return trinity;
        }
        Trinity trinity = Trinity.create(null, leafElement, leafLanguage);
        if (trinity == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(43);
        }
        return trinity;
    }

    private static PsiElement findInside(@NotNull PsiElement element, @NotNull PsiFile hostFile, int hostOffset, @NotNull PsiDocumentManager documentManager) {
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(44);
        }
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(45);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(46);
        }
        Ref out = new Ref();
        InjectedLanguageUtil.enumerate(element, hostFile, true, (injectedPsi, places) -> {
            for (PsiLanguageInjectionHost.Shred place : places) {
                TextRange hostRange = place.getHost().getTextRange();
                if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                if (document == null) {
                    return;
                }
                int injectedOffset = document.hostToInjected(hostOffset);
                PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                out.set(injElement == null ? injectedPsi : injElement);
            }
        });
        return (PsiElement)out.get();
    }

    @Deprecated
    @NotNull
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        ConcurrentList injected;
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(47);
        }
        if ((injected = (ConcurrentList)hostPsiFile.getUserData(INJECTED_DOCS_KEY)) == null) {
            injected = (ConcurrentList)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createConcurrentList());
        }
        ConcurrentList concurrentList = injected;
        if (concurrentList == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(48);
        }
        return concurrentList;
    }

    @NotNull
    static List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range2) {
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(49);
        }
        if (range2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(50);
        }
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        List list2 = ContainerUtil.filter(injected, inj -> Arrays.stream(inj.getHostRanges()).anyMatch(arg_0 -> ((TextRange)range2).intersects(arg_0)));
        if (list2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(51);
        }
        return list2;
    }

    static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(52);
        }
        file2.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches(@NotNull PsiFile injected, @NotNull DocumentWindowImpl documentWindow) {
        if (injected == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(53);
        }
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(54);
        }
        VirtualFileWindowImpl virtualFile = (VirtualFileWindowImpl)injected.getVirtualFile();
        PsiManagerEx psiManagerEx = (PsiManagerEx)injected.getManager();
        if (psiManagerEx.getProject().isDisposed()) {
            return;
        }
        DebugUtil.performPsiModification("injected clearCaches", () -> psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null));
        VirtualFile delegate = virtualFile.getDelegate();
        if (!delegate.isValid()) {
            return;
        }
        FileViewProvider viewProvider = psiManagerEx.getFileManager().findCachedViewProvider(delegate);
        if (viewProvider == null) {
            return;
        }
        for (PsiFile hostFile : ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles()) {
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(hostFile);
                for (int i = cachedInjectedDocuments.size() - 1; i >= 0; --i) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i);
                }
            }
        }
    }

    public static Editor openEditorFor(@NotNull PsiFile file2, @NotNull Project project) {
        Editor editor;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(55);
        }
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(56);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            return EditorWindowImpl.create((DocumentWindowImpl)document, (EditorImpl)editor, file2);
        }
        return editor;
    }

    @Deprecated
    public static PsiFile getTopLevelFile(@NotNull PsiElement element) {
        PsiLanguageInjectionHost host;
        PsiFile containingFile;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(57);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(containingFile);
        if (document instanceof DocumentWindow && (host = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(58);
        }
        Editor editor2 = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        if (editor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(59);
        }
        return editor2;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element) {
        PsiFile injectedFile;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(60);
        }
        if ((injectedFile = element.getContainingFile()) == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element.getTextRange();
        List edibles = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiblesLength = edibles.stream().mapToInt(TextRange::getLength).sum();
        return combinedEdiblesLength != elementRange.getLength();
    }

    public static int hostToInjectedUnescaped(DocumentWindow window, int hostOffset) {
        Place shreds = ((DocumentWindowImpl)window).getShreds();
        Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker();
        if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
            return ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix().length();
        }
        StringBuilder chars = new StringBuilder();
        int unescaped = 0;
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            int prefixLength = shred.getPrefix().length();
            int suffixLength = shred.getSuffix().length();
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            LiteralTextEscaper escaper = host == null ? null : host.createLiteralTextEscaper();
            unescaped += prefixLength;
            Segment currentRange = shred.getHostRangeMarker();
            if (currentRange != null) {
                Segment nextRange;
                Segment segment = nextRange = i == shreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)shreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    hostOffset = Math.min(hostOffset, currentRange.getEndOffset());
                    int inHost = hostOffset - currentRange.getStartOffset();
                    if (escaper != null && escaper.decode(rangeInsideHost, chars)) {
                        int found = ObjectUtils.binarySearch((int)0, (int)inHost, index -> Comparing.compare((int)escaper.getOffsetInHost(index, TextRange.create((int)0, (int)host.getTextLength())), (int)inHost));
                        return unescaped + (found >= 0 ? found : -found - 1);
                    }
                    return unescaped + inHost;
                }
                unescaped = escaper != null && escaper.decode(rangeInsideHost, chars) ? (unescaped += chars.length()) : (unescaped += currentRange.getEndOffset() - currentRange.getStartOffset());
                unescaped += suffixLength;
            }
            chars.setLength(0);
        }
        return unescaped - ((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix().length();
    }

    @Deprecated
    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(61);
        }
        if (!host.isPhysical()) {
            return false;
        }
        Ref result2 = Ref.create((Object)false);
        InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> result2.set((Object)true));
        return (Boolean)result2.get();
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(62);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)file2.getProject())).getInjectionHost((PsiElement)file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(PsiElement element) {
                if (element == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtil.getUnescapedLeafText(element, false));
                } else {
                    super.visitElement(element);
                }
            }
        });
        return sb.toString();
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element, boolean strict) {
        String unescaped = (String)element.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element.getFirstChild() == null) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(63);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)virtualFile).getDocumentWindow();
        }
        return null;
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(64);
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        if (injectionHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(65);
        }
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (injectedPsi, places) -> ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable PsiElement psi) {
        if (psi == null) {
            return null;
        }
        PsiFile containingFile = psi.getContainingFile().getOriginalFile();
        PsiElement fileContext = containingFile.getContext();
        if (fileContext instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)fileContext;
        }
        Place shreds = InjectedLanguageUtil.getShreds(containingFile.getViewProvider());
        if (shreds == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                shreds = InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow());
            }
        }
        return shreds != null ? (PsiLanguageInjectionHost)shreds.getHostPointer().getElement() : null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable VirtualFile virtualFile) {
        return virtualFile instanceof VirtualFileWindow ? (PsiLanguageInjectionHost)InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow()).getHostPointer().getElement() : null;
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        PsiFile file2;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(66);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(67);
        }
        if (key == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(68);
        }
        if ((file2 = InjectedLanguageUtil.getCachedInjectedFileWithLanguage(element, language)) != null) {
            file2.putUserData(key, value);
        }
    }

    @Deprecated
    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value) {
        LOG.warn("use #putInjectedFileUserData(com.intellij.psi.PsiElement, com.intellij.lang.Language, com.intellij.openapi.util.Key, java.lang.Object)} instead");
        InjectionResult result2 = ((InjectionRegistrarImpl)registrar).getInjectedResult();
        if (result2 != null && result2.files != null) {
            List<? extends PsiFile> files2 = result2.files;
            PsiFile file2 = files2.get(files2.size() - 1);
            file2.putUserData(key, value);
        }
    }

    @Nullable
    public static PsiFile getCachedInjectedFileWithLanguage(@NotNull PsiElement element, @NotNull Language language) {
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(69);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(70);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getCachedInjectedDocumentsInRange(containingFile, element.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance((Project)containingFile.getProject()).getPsiFile((Document)documentWindow)).filter(file2 -> file2 != null && file2.getLanguage() == LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2.getVirtualFile(), file2.getProject())).findFirst().orElse(null);
    }

    public static void injectReference(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (registrar == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(71);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(72);
        }
        if (prefix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(73);
        }
        if (suffix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(74);
        }
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(75);
        }
        if (rangeInsideHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(76);
        }
        ((InjectionRegistrarImpl)registrar).injectReference(language, prefix, suffix, host, rangeInsideHost);
    }

    public static BooleanRunnable reparse(@NotNull PsiFile injectedPsiFile, @NotNull DocumentWindow injectedDocument, @NotNull PsiFile hostPsiFile, @NotNull Document hostDocument, @NotNull FileViewProvider hostViewProvider, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFile hostVirtualFile;
        InjectedFileViewProvider provider;
        VirtualFile oldInjectedVFile;
        Language language;
        BooleanRunnable runnable2;
        if (injectedPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(77);
        }
        if (injectedDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(78);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(79);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(80);
        }
        if (hostViewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(81);
        }
        if (indicator == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(82);
        }
        if (oldRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(83);
        }
        if (newRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(84);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(85);
        }
        if ((runnable2 = InjectionRegistrarImpl.reparse(language = injectedPsiFile.getLanguage(), (DocumentWindowImpl)injectedDocument, injectedPsiFile, (VirtualFileWindow)(oldInjectedVFile = (provider = (InjectedFileViewProvider)injectedPsiFile.getViewProvider()).getVirtualFile()), hostVirtualFile = hostViewProvider.getVirtualFile(), hostPsiFile, (DocumentEx)hostDocument, indicator, oldRoot, newRoot, documentManager)) == null) {
            EditorWindowImpl.disposeEditorFor(injectedDocument);
        }
        return runnable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 51: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 51: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 9: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 3: 
            case 4: 
            case 32: 
            case 52: 
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 11: 
            case 34: 
            case 47: 
            case 49: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 18: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToFind";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCaret";
                break;
            }
            case 33: 
            case 44: 
            case 57: 
            case 60: 
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElement";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 38: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 40: 
            case 46: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injected";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 67: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsiFile";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedDocument";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostViewProvider";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "tryOffset";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocuments";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTree";
                break;
            }
            case 2: 
            case 9: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 51: 
            case 59: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTokens";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightTokens";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getShreds";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mightHaveInjectedFragmentAtCaret";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedFile";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedPsiNoCommit";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtNoCommit";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "probeElementsUp";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedElementNoCommit";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tryOffset";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findInside";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocuments";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedInjectedFragmentsForFile";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelEditor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isInInjectedLanguagePrefixSuffix";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasInjections";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedStart";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findElementInInjected";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedFileWithLanguage";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 51: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TokenInfo {
        @NotNull
        public final IElementType type;
        @NotNull
        public final ProperTextRange rangeInsideInjectionHost;
        public final int shredIndex;

        public TokenInfo(@NotNull IElementType type, @NotNull ProperTextRange rangeInsideInjectionHost, int shredIndex) {
            if (type == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            if (rangeInsideInjectionHost == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.rangeInsideInjectionHost = rangeInsideInjectionHost;
            this.shredIndex = shredIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInsideInjectionHost";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$TokenInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

