/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    static final PersistentFS ourPersistence = PersistentFS.getInstance();
    private static final Key<String> SYMLINK_TARGET = Key.create((String)"local.vfs.symlink.target");
    static final int IS_WRITABLE_FLAG = 0x1000000;
    static final int IS_HIDDEN_FLAG = 0x2000000;
    private static final int INDEXED_FLAG = 0x4000000;
    static final int CHILDREN_CACHED = 0x8000000;
    static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
    private static final int DIRTY_FLAG = 0x10000000;
    static final int IS_SYMLINK_FLAG = 0x20000000;
    private static final int HAS_SYMLINK_FLAG = 0x40000000;
    static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;
    static final int ALL_FLAGS_MASK = -16777216;
    final VfsData.Segment mySegment;
    private final VirtualDirectoryImpl myParent;
    final int myId;

    VirtualFileSystemEntry(int id, @NotNull VfsData.Segment segment, @Nullable VirtualDirectoryImpl parent) {
        if (segment == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(0);
        }
        this.mySegment = segment;
        this.myId = id;
        this.myParent = parent;
    }

    void updateLinkStatus() {
        boolean isSymLink = this.is(VFileProperty.SYMLINK);
        if (isSymLink) {
            String target2 = this.getParent().getFileSystem().resolveSymLink((VirtualFile)this);
            this.setLinkTarget(target2 != null ? FileUtil.toSystemIndependentName((String)target2) : null);
        }
        this.setFlagInt(0x40000000, isSymLink || this.getParent().getFlagInt(0x40000000));
    }

    @NotNull
    public String getName() {
        String string = this.getNameSequence().toString();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public CharSequence getNameSequence() {
        CharSequence charSequence = FileNameCache.getVFileName(this.getNameId());
        if (charSequence == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    public final int getNameId() {
        return this.mySegment.getNameId(this.myId);
    }

    public VirtualDirectoryImpl getParent() {
        VirtualDirectoryImpl changedParent = this.mySegment.vfsData.getChangedParent(this.myId);
        return changedParent != null ? changedParent : this.myParent;
    }

    public boolean isDirty() {
        return this.getFlagInt(0x10000000);
    }

    public long getModificationStamp() {
        return this.mySegment.getModificationStamp(this.myId);
    }

    public void setModificationStamp(long modificationStamp) {
        this.mySegment.setModificationStamp(this.myId, modificationStamp);
    }

    boolean getFlagInt(int mask) {
        return this.mySegment.getFlag(this.myId, mask);
    }

    void setFlagInt(int mask, boolean value) {
        this.mySegment.setFlag(this.myId, mask, value);
    }

    public boolean isFileIndexed() {
        return this.getFlagInt(0x4000000);
    }

    public void setFileIndexed(boolean indexed) {
        this.setFlagInt(0x4000000, indexed);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file2 : this.getCachedChildren()) {
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
    }

    @NotNull
    protected char[] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
        CharSequence name = FileNameCache.getVFileName(this.mySegment.getNameId(this.myId));
        char[] chars = this.getParent().appendPathOnFileSystem(accumulatedPathLength + 1 + name.length(), positionRef);
        int i = positionRef[0];
        chars[i] = 47;
        positionRef[0] = VirtualFileSystemEntry.copyString(chars, i + 1, name);
        if (chars == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(3);
        }
        return chars;
    }

    protected static int copyString(@NotNull char[] chars, int pos, @NotNull CharSequence s) {
        if (chars == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(4);
        }
        if (s == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(5);
        }
        int length = s.length();
        CharArrayUtil.getChars((CharSequence)s, (char[])chars, (int)0, (int)pos, (int)length);
        return pos + length;
    }

    @NotNull
    public String getUrl() {
        String protocol = this.getFileSystem().getProtocol();
        int prefixLen = protocol.length() + "://".length();
        char[] chars = this.appendPathOnFileSystem(prefixLen, new int[]{prefixLen});
        VirtualFileSystemEntry.copyString(chars, VirtualFileSystemEntry.copyString(chars, 0, protocol), "://");
        String string = StringFactory.createShared((char[])chars);
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = StringFactory.createShared((char[])this.appendPathOnFileSystem(0, new int[]{0}));
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName)) {
            return;
        }
        this.validateName(newName);
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(9);
        }
        this.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(11);
        }
        if (copyName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(12);
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        VirtualFile virtualFile = EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> ourPersistence.copyFile(requestor, (VirtualFile)this, newParent, copyName));
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> {
            ourPersistence.moveFile(requestor, (VirtualFile)this, newParent);
            return this;
        });
    }

    public int getId() {
        return this.mySegment.vfsData.isFileValid(this.myId) ? this.myId : -this.myId;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof VirtualFileSystemEntry && this.myId == ((VirtualFileSystemEntry)((Object)o)).myId;
    }

    public int hashCode() {
        return this.myId;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(15);
        }
        this.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    private void validateName(@NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(17);
        }
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name}));
        }
    }

    public boolean exists() {
        return this.mySegment.vfsData.isFileValid(this.myId);
    }

    public boolean isValid() {
        return this.exists();
    }

    public String toString() {
        return this.getUrl();
    }

    public void setNewName(@NotNull String newName) {
        if (newName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(18);
        }
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IllegalArgumentException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        this.mySegment.setNameId(this.myId, FileNameCache.storeName(newName));
        parent.addChild(this);
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public void setParent(@NotNull VirtualFile newParent) {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        VirtualDirectoryImpl directory = (VirtualDirectoryImpl)newParent;
        this.mySegment.vfsData.changeParent(this.myId, directory);
        directory.addChild(this);
        this.updateLinkStatus();
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    public void invalidate() {
        this.mySegment.vfsData.invalidateFile(this.myId);
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.isCharsetSet() ? super.getCharset() : this.computeCharset();
        if (charset == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(20);
        }
        return charset;
    }

    @NotNull
    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else {
            FileType fileType = this.getFileType();
            if (this.isCharsetSet()) {
                Charset charset2 = super.getCharset();
                if (charset2 == null) {
                    VirtualFileSystemEntry.$$$reportNull$$$0(21);
                }
                return charset2;
            }
            try {
                byte[] content = VfsUtilCore.loadBytes((VirtualFile)this);
                charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, content, fileType);
            }
            catch (IOException e) {
                Charset charset3 = super.getCharset();
                if (charset3 == null) {
                    VirtualFileSystemEntry.$$$reportNull$$$0(22);
                }
                return charset3;
            }
        }
        Charset charset4 = charset;
        if (charset4 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(23);
        }
        return charset4;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().getHideKnownExtensionInTabs() && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(24);
        }
        if (property == VFileProperty.SPECIAL) {
            return this.getFlagInt(Integer.MIN_VALUE);
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.getFlagInt(0x20000000);
        }
        return super.is(property);
    }

    public void updateProperty(@NotNull String property, boolean value) {
        if (property == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(25);
        }
        if (property == "writable") {
            this.setFlagInt(0x1000000, value);
        }
        if (property == "HIDDEN") {
            this.setFlagInt(0x2000000, value);
        }
    }

    public void setLinkTarget(@Nullable String target2) {
        this.putUserData(SYMLINK_TARGET, target2);
    }

    public String getCanonicalPath() {
        if (this.getFlagInt(0x40000000)) {
            if (this.is(VFileProperty.SYMLINK)) {
                return (String)this.getUserData(SYMLINK_TARGET);
            }
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.getFlagInt(0x40000000)) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPathOnFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

