/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            ApplicationUtil.$$$reportNull$$$0(0);
        }
        Ref result2 = new Ref();
        ApplicationUtil.tryRunReadAction(() -> result2.set(computable.compute()));
        return (T)result2.get();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (computable == null) {
            ApplicationUtil.$$$reportNull$$$0(1);
        }
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw CannotRunReadActionException.create();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            ApplicationUtil.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ApplicationUtil.$$$reportNull$$$0(3);
        }
        Ref result2 = Ref.create();
        Ref error = Ref.create();
        Future<?> future2 = PooledThreadExecutor.INSTANCE.submit(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                result2.set(callable.call());
            }
            catch (Throwable t) {
                error.set((Object)t);
            }
        }, indicator));
        try {
            ApplicationUtil.runWithCheckCanceled(future2, indicator);
            ExceptionUtil.rethrowAll((Throwable)((Throwable)error.get()));
        }
        catch (ProcessCanceledException e) {
            future2.cancel(true);
            throw e;
        }
        return (T)result2.get();
    }

    public static void runWithCheckCanceled(@NotNull Future<?> future2, @NotNull ProgressIndicator indicator) throws Exception {
        if (future2 == null) {
            ApplicationUtil.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            ApplicationUtil.$$$reportNull$$$0(5);
        }
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                future2.cancel(true);
                throw e;
            }
            try {
                future2.get(25L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static void showDialogAfterWriteAction(@NotNull Runnable runnable2) {
        Application application;
        if (runnable2 == null) {
            ApplicationUtil.$$$reportNull$$$0(6);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            application.invokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/ApplicationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRunReadAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCheckCanceled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAfterWriteAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CannotRunReadActionException
    extends ProcessCanceledException {
        public static CannotRunReadActionException create() {
            return new CannotRunReadActionException();
        }

        private CannotRunReadActionException() {
        }
    }
}

