/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0000H\u0016R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventBaseAction;", "", "id", "", "(Ljava/lang/String;)V", "data", "", "getData", "()Ljava/util/Map;", "setData", "(Ljava/util/Map;)V", "getId", "()Ljava/lang/String;", "addData", "", "key", "value", "equals", "", "other", "hashCode", "", "increment", "isEventGroup", "shouldMerge", "next", "intellij.platform.ide.impl"})
public class LogEventBaseAction {
    @NotNull
    private Map<String, Object> data;
    @NotNull
    private final String id;

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    public final void setData(@NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.data = map;
    }

    public void increment() {
    }

    public boolean isEventGroup() {
        return false;
    }

    public boolean shouldMerge(@NotNull LogEventBaseAction next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (Intrinsics.areEqual((Object)this.id, (Object)next.id) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.data, next.data) ^ true);
    }

    public final void addData(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.data.isEmpty()) {
            HashMap hashMap = ContainerUtil.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap()");
            this.data = hashMap;
        }
        Object escapedValue = value instanceof String ? LogEventsKt.access$escape((String)value) : value;
        Map<String, Object> map = this.data;
        String string = LogEventsKt.access$escape(key);
        Object object = escapedValue;
        map.put(string, object);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventBaseAction");
        }
        LogEventBaseAction cfr_ignored_0 = (LogEventBaseAction)object2;
        if (Intrinsics.areEqual((Object)this.id, (Object)((LogEventBaseAction)other).id) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.data, ((LogEventBaseAction)other).data) ^ true);
    }

    public int hashCode() {
        return 31 * this.id.hashCode() + ((Object)this.data).hashCode();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public LogEventBaseAction(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.id = id;
        Map map = Collections.emptyMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.emptyMap()");
        this.data = map;
    }
}

