/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces = true;
    private boolean myShowTreeNodes = true;
    private final Project myProject;
    private PsiElement myRootPsiElement = null;
    private final Object myRootElement = new Object();

    public ViewerTreeStructure(Project project) {
        this.myProject = project;
    }

    public void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    public PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRootElement;
        if (object == null) {
            ViewerTreeStructure.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(1);
        }
        if (this.myRootElement == element) {
            if (this.myRootPsiElement == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    ViewerTreeStructure.$$$reportNull$$$0(2);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (!(this.myRootPsiElement instanceof PsiFile)) {
                Object[] objectArray = new Object[]{this.myRootPsiElement};
                if (objectArray == null) {
                    ViewerTreeStructure.$$$reportNull$$$0(3);
                }
                return objectArray;
            }
            List files2 = ((PsiFile)this.myRootPsiElement).getViewProvider().getAllFiles();
            Object[] objectArray = PsiUtilCore.toPsiFileArray((Collection)files2);
            if (objectArray == null) {
                ViewerTreeStructure.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        Object[][] children2 = new Object[][]{ArrayUtil.EMPTY_OBJECT_ARRAY};
        ApplicationManager.getApplication().runReadAction(() -> {
            Object[] result2;
            if (this.myShowTreeNodes) {
                ASTNode root;
                ArrayList<ASTNode> list2 = new ArrayList<ASTNode>();
                Object object = element instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)element) : (root = element instanceof ASTNode ? (ASTNode)element : null);
                if (element instanceof Inject) {
                    root = SourceTreeToPsiMap.psiElementToTree(((Inject)element).getPsi());
                }
                if (root != null) {
                    for (ASTNode child2 = root.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                        if (!this.myShowWhiteSpaces && child2.getElementType() == TokenType.WHITE_SPACE) continue;
                        PsiElement childElement = child2.getPsi();
                        list2.add((ASTNode)(childElement == null ? child2 : childElement));
                    }
                    PsiElement psi = root.getPsi();
                    if (psi instanceof PsiLanguageInjectionHost) {
                        InjectedLanguageManager.getInstance((Project)this.myProject).enumerate(psi, (injectedPsi, places) -> list2.add((ASTNode)new Inject(psi, (PsiElement)injectedPsi)));
                    }
                }
                result2 = ArrayUtil.toObjectArray(list2);
            } else {
                PsiElement[] elementChildren = ((PsiElement)element).getChildren();
                if (!this.myShowWhiteSpaces) {
                    ArrayList<PsiElement> childrenList = new ArrayList<PsiElement>(elementChildren.length);
                    for (PsiElement psiElement : elementChildren) {
                        if (!this.myShowWhiteSpaces && psiElement instanceof PsiWhiteSpace) continue;
                        childrenList.add(psiElement);
                    }
                    result2 = PsiUtilCore.toPsiElementArray(childrenList);
                } else {
                    result2 = elementChildren;
                }
            }
            children2[0] = result2;
        });
        Object[] objectArray = children2[0];
        if (objectArray == null) {
            ViewerTreeStructure.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(6);
        }
        if (element == this.myRootElement) {
            return null;
        }
        if (element == this.myRootPsiElement) {
            return this.myRootElement;
        }
        if (element instanceof PsiFile && InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element)) != null) {
            return new Inject((PsiElement)InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element)), (PsiElement)element);
        }
        return element instanceof Inject ? ((Inject)element).getParent() : ((PsiElement)element).getContext();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            ViewerTreeStructure.$$$reportNull$$$0(7);
        }
        if (element == this.myRootElement) {
            NodeDescriptor nodeDescriptor = new NodeDescriptor(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
            if (nodeDescriptor == null) {
                ViewerTreeStructure.$$$reportNull$$$0(8);
            }
            return nodeDescriptor;
        }
        ViewerNodeDescriptor viewerNodeDescriptor = new ViewerNodeDescriptor(this.myProject, element, parentDescriptor);
        if (viewerNodeDescriptor == null) {
            ViewerTreeStructure.$$$reportNull$$$0(9);
        }
        return viewerNodeDescriptor;
    }

    public boolean isShowWhiteSpaces() {
        return this.myShowWhiteSpaces;
    }

    public void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    public boolean isShowTreeNodes() {
        return this.myShowTreeNodes;
    }

    public void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/ViewerTreeStructure";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/ViewerTreeStructure";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Inject {
        private final PsiElement myParent;
        private final PsiElement myPsi;

        Inject(PsiElement parent, PsiElement psi) {
            this.myParent = parent;
            this.myPsi = psi;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public PsiElement getPsi() {
            return this.myPsi;
        }

        public String toString() {
            return "INJECTION " + this.myPsi.getLanguage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inject inject = (Inject)o;
            if (!this.myParent.equals(inject.myParent)) {
                return false;
            }
            return this.myPsi.equals(inject.myPsi);
        }

        public int hashCode() {
            int result2 = this.myParent.hashCode();
            result2 = 31 * result2 + this.myPsi.hashCode();
            return result2;
        }
    }
}

