/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;

public class ViewImpl
implements View {
    public static final Key<String> ID = Key.create((String)"ViewID");
    private String myID;
    private Tab myTab;
    private int myTabIndex;
    private int myWindow;
    private PlaceInGrid myPlaceInGrid;
    private boolean myMinimizedInGrid;

    public ViewImpl(String id, TabImpl tab, PlaceInGrid placeInGrid, boolean minimizedInGrid, int window) {
        this.myID = id;
        this.myTab = tab;
        this.myPlaceInGrid = placeInGrid;
        this.myMinimizedInGrid = minimizedInGrid;
        this.myWindow = window;
    }

    public ViewImpl(RunnerLayout settings, Element element) {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        this.assignTab(settings.getOrCreateTab(this.myTabIndex));
    }

    public Tab getTab() {
        return this.myTab;
    }

    public PlaceInGrid getPlaceInGrid() {
        return this.myPlaceInGrid;
    }

    public boolean isMinimizedInGrid() {
        return this.myMinimizedInGrid;
    }

    public void setID(String ID2) {
        this.myID = ID2;
    }

    public String getID() {
        return this.myID;
    }

    public void setMinimizedInGrid(boolean minimizedInGrid) {
        this.myMinimizedInGrid = minimizedInGrid;
    }

    public void setPlaceInGrid(PlaceInGrid placeInGrid) {
        this.myPlaceInGrid = placeInGrid;
    }

    public void assignTab(Tab tab) {
        this.myTab = tab;
    }

    public int getTabIndex() {
        return this.myTab != null ? this.myTab.getIndex() : this.myTabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.myTabIndex = tabIndex;
    }

    public int getWindow() {
        return this.myWindow;
    }

    public void setWindow(int windowNumber) {
        this.myWindow = windowNumber;
    }

    public static class Default {
        private final String myID;
        private final int myTabID;
        private final PlaceInGrid myPlaceInGrid;
        private final boolean myMinimizedInGrid;

        public Default(String ID2, int tabID, PlaceInGrid placeInGrid, boolean minimizedInGrid) {
            this.myID = ID2;
            this.myTabID = tabID;
            this.myPlaceInGrid = placeInGrid;
            this.myMinimizedInGrid = minimizedInGrid;
        }

        public ViewImpl createView(RunnerLayout settings) {
            TabImpl tab = this.myTabID == Integer.MAX_VALUE ? settings.createNewTab() : settings.getOrCreateTab(this.myTabID);
            return new ViewImpl(this.myID, tab, this.myPlaceInGrid, this.myMinimizedInGrid, 0);
        }

        public PlaceInGrid getPlaceInGrid() {
            return this.myPlaceInGrid;
        }
    }
}

