/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements DataProvider {
    @Nullable
    protected final Project myProject;
    @NotNull
    private final DataProvider myDataProvider;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    private final List<JComponent> myPersistentNotifications;
    @NotNull
    private final List<JComponent> myNotifications;
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final Wrapper myNotificationsPanel;
    @NotNull
    private final Wrapper myNorthPanel;
    @NotNull
    private final Wrapper mySouthPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project, @NotNull DataProvider provider, @NotNull DiffContext context) {
        if (provider == null) {
            DiffPanelBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DiffPanelBase.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myPersistentNotifications = new ArrayList<JComponent>();
        this.myNotifications = new ArrayList<JComponent>();
        this.myProject = project;
        this.myDataProvider = provider;
        this.myContext = context;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new Wrapper();
        this.myNorthPanel = new Wrapper();
        this.mySouthPanel = new Wrapper();
        this.add((Component)this.myContentPanel, "Center");
        this.add((Component)this.myNorthPanel, "North");
        this.add((Component)this.mySouthPanel, "South");
    }

    public void setTopPanel(@Nullable JComponent component) {
        this.myNorthPanel.setContent(component);
    }

    public void setBottomPanel(@Nullable JComponent component) {
        this.mySouthPanel.setContent(component);
    }

    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            DiffPanelBase.$$$reportNull$$$0(2);
        }
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        if (card == null) {
            DiffPanelBase.$$$reportNull$$$0(3);
        }
        Runnable task = () -> {
            this.myCardLayout.show(this.myContentPanel, card);
            this.myCurrentCard = card;
            this.myContentPanel.revalidate();
        };
        if (keepFocus) {
            DiffUtil.runPreservingFocus((FocusableContext)this.myContext, task);
        } else {
            task.run();
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DiffPanelBase.$$$reportNull$$$0(4);
        }
        return this.myDataProvider.getData(dataId);
    }

    public void setPersistentNotifications(@NotNull List<JComponent> components) {
        if (components == null) {
            DiffPanelBase.$$$reportNull$$$0(5);
        }
        this.myPersistentNotifications.clear();
        this.myPersistentNotifications.addAll(components);
        this.updateNotifications();
    }

    public void resetNotifications() {
        this.myNotifications.clear();
        this.updateNotifications();
    }

    public void addNotification(@NotNull JComponent notification) {
        if (notification == null) {
            DiffPanelBase.$$$reportNull$$$0(6);
        }
        this.myNotifications.add(notification);
        this.updateNotifications();
    }

    private void updateNotifications() {
        List notifications = ContainerUtil.concat(this.myPersistentNotifications, this.myNotifications);
        this.myNotificationsPanel.setContent(DiffUtil.createStackedComponents(notifications, DiffUtil.TITLE_GAP));
        this.validate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "card";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/base/DiffPanelBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentCard";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setPersistentNotifications";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

