/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByLine {
    @NotNull
    public static FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(0);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(3);
        }
        indicator.checkCanceled();
        FairDiffIterable fairDiffIterable = ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), policy, indicator);
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(4);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(5);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(6);
        }
        if (lines3 == null) {
            ByLine.$$$reportNull$$$0(7);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(9);
        }
        indicator.checkCanceled();
        List<MergeRange> list2 = ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), ByLine.getLines(lines3, policy), policy, indicator, false);
        if (list2 == null) {
            ByLine.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public static List<MergeRange> merge(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(11);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(12);
        }
        if (lines3 == null) {
            ByLine.$$$reportNull$$$0(13);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(15);
        }
        indicator.checkCanceled();
        List<MergeRange> list2 = ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), ByLine.getLines(lines3, policy), policy, indicator, true);
        if (list2 == null) {
            ByLine.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    static FairDiffIterable doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(17);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(18);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(20);
        }
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes2 = ByLine.compareSmart(lines1, lines2, indicator);
            changes2 = ByLine.optimizeLineChunks(lines1, lines2, changes2, indicator);
            FairDiffIterable fairDiffIterable = ByLine.expandRanges(lines1, lines2, changes2);
            if (fairDiffIterable == null) {
                ByLine.$$$reportNull$$$0(21);
            }
            return fairDiffIterable;
        }
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLine.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        FairDiffIterable fairDiffIterable = ByLine.correctChangesSecondStep(lines1, lines2, iwChanges);
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(22);
        }
        return fairDiffIterable;
    }

    @NotNull
    static List<MergeRange> doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator, boolean keepIgnoredChanges) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(23);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(24);
        }
        if (lines3 == null) {
            ByLine.$$$reportNull$$$0(25);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(26);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(27);
        }
        indicator.checkCanceled();
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = ByLine.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = ByLine.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLine.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLine.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLine.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLine.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLine.correctChangesSecondStep(lines2, lines3, iwChanges2);
        if (keepIgnoredChanges && policy != ComparisonPolicy.DEFAULT) {
            List<MergeRange> list2 = ComparisonMergeUtil.buildMerge(iterable1, iterable2, (index1, index2, index3) -> ByLine.equalsDefaultPolicy(lines1, lines2, lines3, index1, index2, index3), indicator);
            if (list2 == null) {
                ByLine.$$$reportNull$$$0(28);
            }
            return list2;
        }
        List<MergeRange> list3 = ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
        if (list3 == null) {
            ByLine.$$$reportNull$$$0(29);
        }
        return list3;
    }

    private static boolean equalsDefaultPolicy(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, int index1, int index2, int index3) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(30);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(31);
        }
        if (lines3 == null) {
            ByLine.$$$reportNull$$$0(32);
        }
        CharSequence content1 = lines1.get(index1).getContent();
        CharSequence content2 = lines2.get(index2).getContent();
        CharSequence content3 = lines3.get(index3).getContent();
        return StringUtil.equals((CharSequence)content2, (CharSequence)content1) && StringUtil.equals((CharSequence)content2, (CharSequence)content3);
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2, final @NotNull FairDiffIterable changes2) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(33);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(34);
        }
        if (changes2 == null) {
            ByLine.$$$reportNull$$$0(35);
        }
        final DiffIterableUtil.ExpandChangeBuilder builder2 = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = 0;
            private int last2 = 0;

            public void run() {
                for (Range range2 : changes2.iterateUnchanged()) {
                    int count = range2.end1 - range2.start1;
                    for (int i = 0; i < count; ++i) {
                        int index1 = range2.start1 + i;
                        int index2 = range2.start2 + i;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)line1.getContent())) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder2.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(changes2.getLength1(), changes2.getLength2());
            }

            private void flush(int line1, int line2) {
                int i;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, builder2.getIndex1());
                int start2 = Math.max(this.last2, builder2.getIndex2());
                TIntArrayList subLines1 = new TIntArrayList();
                TIntArrayList subLines2 = new TIntArrayList();
                for (i = start1; i < line1; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines1.get(i)).getContent())) continue;
                    subLines1.add(i);
                    this.last1 = i + 1;
                }
                for (i = start2; i < line2; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines2.get(i)).getContent())) continue;
                    subLines2.add(i);
                    this.last2 = i + 1;
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching(subLines1, subLines2);
                this.sample = null;
            }

            private void alignExactMatching(TIntArrayList subLines1, TIntArrayList subLines2) {
                boolean skipAligning;
                int n = Math.max(subLines1.size(), subLines2.size());
                boolean bl = skipAligning = n > 10 || subLines1.size() == subLines2.size();
                if (skipAligning) {
                    int count = Math.min(subLines1.size(), subLines2.size());
                    for (int i = 0; i < count; ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i = 0; i < subLines1.size(); ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(matching[i]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i = 0; i < subLines2.size(); ++i) {
                        int index1 = subLines1.get(matching[i]);
                        int index2 = subLines2.get(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder2.finish());
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(36);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static int[] getBestMatchingAlignment(final @NotNull TIntArrayList subLines1, final @NotNull TIntArrayList subLines2, final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2) {
        if (subLines1 == null) {
            ByLine.$$$reportNull$$$0(37);
        }
        if (subLines2 == null) {
            ByLine.$$$reportNull$$$0(38);
        }
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(39);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(40);
        }
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i = 0; i < size; ++i) {
            best[i] = i;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start2, int n, int k) {
                if (k == size) {
                    this.processCombination();
                    return;
                }
                for (int i = start2; i <= n; ++i) {
                    comb[k] = i;
                    this.combinations(i + 1, n, k + 1);
                }
            }

            private void processCombination() {
                int weight2 = 0;
                for (int i = 0; i < size; ++i) {
                    int index1 = subLines1.get(i);
                    int index2 = subLines2.get(comb[i]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight2;
                }
                if (weight2 > this.bestWeight) {
                    this.bestWeight = weight2;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        if (best == null) {
            ByLine.$$$reportNull$$$0(41);
        }
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(42);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(43);
        }
        if (iterable == null) {
            ByLine.$$$reportNull$$$0(44);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(45);
        }
        FairDiffIterable fairDiffIterable = new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(46);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ProgressIndicator indicator) {
        int threshold;
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(47);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(48);
        }
        if (indicator == null) {
            ByLine.$$$reportNull$$$0(49);
        }
        if ((threshold = ComparisonUtil.getUnimportantLineCharCount()) == 0) {
            FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(lines1, lines2, indicator);
            if (fairDiffIterable == null) {
                ByLine.$$$reportNull$$$0(50);
            }
            return fairDiffIterable;
        }
        Pair<List<Line>, TIntArrayList> bigLines1 = ByLine.getBigLines(lines1, threshold);
        Pair<List<Line>, TIntArrayList> bigLines2 = ByLine.getBigLines(lines2, threshold);
        FairDiffIterable changes2 = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        FairDiffIterable fairDiffIterable = new ChangeCorrector.SmartLineChangeCorrector((TIntArrayList)bigLines1.second, (TIntArrayList)bigLines2.second, lines1, lines2, changes2, indicator).build();
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(51);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static Pair<List<Line>, TIntArrayList> getBigLines(@NotNull List<? extends Line> lines2, int threshold) {
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(52);
        }
        ArrayList<Line> bigLines = new ArrayList<Line>(lines2.size());
        TIntArrayList indexes = new TIntArrayList(lines2.size());
        for (int i = 0; i < lines2.size(); ++i) {
            Line line = lines2.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i);
        }
        Pair pair = Pair.create(bigLines, (Object)indexes);
        if (pair == null) {
            ByLine.$$$reportNull$$$0(53);
        }
        return pair;
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable) {
        if (lines1 == null) {
            ByLine.$$$reportNull$$$0(54);
        }
        if (lines2 == null) {
            ByLine.$$$reportNull$$$0(55);
        }
        if (iterable == null) {
            ByLine.$$$reportNull$$$0(56);
        }
        ArrayList<Range> changes2 = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes2.add(expanded);
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.create(changes2, lines1.size(), lines2.size()));
        if (fairDiffIterable == null) {
            ByLine.$$$reportNull$$$0(57);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static List<Line> getLines(@NotNull List<? extends CharSequence> text, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            ByLine.$$$reportNull$$$0(58);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(59);
        }
        List list2 = ContainerUtil.map(text, line -> new Line((CharSequence)line, policy));
        if (list2 == null) {
            ByLine.$$$reportNull$$$0(60);
        }
        return list2;
    }

    @NotNull
    private static List<Line> convertMode(@NotNull List<? extends Line> original, @NotNull ComparisonPolicy policy) {
        if (original == null) {
            ByLine.$$$reportNull$$$0(61);
        }
        if (policy == null) {
            ByLine.$$$reportNull$$$0(62);
        }
        ArrayList<Line> result2 = new ArrayList<Line>(original.size());
        for (Line line : original) {
            Line newLine = line.myPolicy != policy ? new Line(line.getContent(), policy) : line;
            result2.add(newLine);
        }
        ArrayList<Line> arrayList = result2;
        if (arrayList == null) {
            ByLine.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines1";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 18: 
            case 24: 
            case 31: 
            case 34: 
            case 40: 
            case 43: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines2";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 19: 
            case 26: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 20: 
            case 27: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByLine";
                break;
            }
            case 7: 
            case 13: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines3";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subLines1";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subLines2";
                break;
            }
            case 44: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByLine";
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 21: 
            case 22: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "correctChangesSecondStep";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestMatchingAlignment";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeLineChunks";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "compareSmart";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigLines";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "expandRanges";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 63: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "equalsDefaultPolicy";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "correctChangesSecondStep";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBestMatchingAlignment";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "optimizeLineChunks";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "compareSmart";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBigLines";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "expandRanges";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "convertMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Line {
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final ComparisonPolicy myPolicy;
        private final int myHash;
        private final int myNonSpaceChars;

        Line(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
            if (text == null) {
                Line.$$$reportNull$$$0(0);
            }
            if (policy == null) {
                Line.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myPolicy = policy;
            this.myHash = Line.hashCode(text, policy);
            this.myNonSpaceChars = Line.countNonSpaceChars(text);
        }

        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                Line.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myPolicy == line.myPolicy);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return Line.equals(this.getContent(), line.getContent(), this.myPolicy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static int countNonSpaceChars(@NotNull CharSequence text) {
            if (text == null) {
                Line.$$$reportNull$$$0(3);
            }
            int nonSpace = 0;
            int len = text.length();
            for (int offset = 0; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
            }
            return nonSpace;
        }

        private static boolean equals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            if (text1 == null) {
                Line.$$$reportNull$$$0(4);
            }
            if (text2 == null) {
                Line.$$$reportNull$$$0(5);
            }
            if (policy == null) {
                Line.$$$reportNull$$$0(6);
            }
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
                }
                case TRIM_WHITESPACES: {
                    return StringUtil.equalsTrimWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
            }
            throw new IllegalArgumentException(policy.toString());
        }

        private static int hashCode(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
            if (text == null) {
                Line.$$$reportNull$$$0(7);
            }
            if (policy == null) {
                Line.$$$reportNull$$$0(8);
            }
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.stringHashCode((CharSequence)text);
                }
                case TRIM_WHITESPACES: {
                    int offset1 = TrimUtil.trimStart(text, 0, text.length());
                    int offset2 = TrimUtil.trimEnd(text, offset1, text.length());
                    return StringUtil.stringHashCode((CharSequence)text, (int)offset1, (int)offset2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)text);
                }
            }
            throw new IllegalArgumentException(policy.name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByLine$Line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByLine$Line";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "countNonSpaceChars";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "equals";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hashCode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

