/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetUpdateTagAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    private static final String EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY = "emmet.recent.update.abbreviations";
    private static final String EMMET_LAST_UPDATE_ABBREVIATIONS_KEY = "emmet.last.update.abbreviations";
    private static final String DOCUMENTATION = "Update HTML tag with Emmet abbreviation:<br/>.class[attribute] to overwrite value;<br/>.+class[attribute] to append value;<br/>.-class[attribute] to remove value.<br/><p/>For example, <code>.+c2[title=Hello]</code> abbreviation updates<br/><code>&lt;div class=\"c1\"&gt;</code> to<br/><code>&lt;div class=\"c1 c2\" title=\"Hello\"&gt;</code>.";
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp("Update HTML tag with Emmet abbreviation:<br/>.class[attribute] to overwrite value;<br/>.+class[attribute] to append value;<br/>.-class[attribute] to remove value.<br/><p/>For example, <code>.+c2[title=Hello]</code> abbreviation updates<br/><code>&lt;div class=\"c1\"&gt;</code> to<br/><code>&lt;div class=\"c1 c2\" title=\"Hello\"&gt;</code>.");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file2) {
                XmlTag tag;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((tag = EmmetUpdateTagAction.findTag(editor, file2)) != null) {
                    new EmmetAbbreviationBalloon(EmmetUpdateTagAction.EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY, EmmetUpdateTagAction.EMMET_LAST_UPDATE_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

                        @Override
                        public void onEnter(@NotNull String abbreviation) {
                            if (abbreviation == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                EmmetUpdateTagAction.this.doUpdateTag(abbreviation, tag, file2, editor);
                            }
                            catch (EmmetException emmetException) {
                                // empty catch block
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1$1", "onEnter"));
                        }
                    }, CONTEXT_HELP).show(new CustomTemplateCallback(editor, file2));
                }
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (codeInsightActionHandler == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(0);
        }
        return codeInsightActionHandler;
    }

    public void doUpdateTag(@NotNull String abbreviation, @NotNull XmlTag tag, @NotNull PsiFile file2, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(1);
        }
        if (tag == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(4);
        }
        if (tag.isValid()) {
            String templateText = EmmetUpdateTagAction.expandTemplate(abbreviation, file2, editor);
            LinkedHashSet classNames = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addAll((Collection)classNames, HtmlUtil.splitClassNames(tag.getAttributeValue("class")));
            LinkedHashMap attributes = ContainerUtil.newLinkedHashMap();
            Ref newTagName = Ref.create();
            EmmetUpdateTagAction.processTags(file2.getProject(), templateText, (PairProcessor<? super XmlTag, ? super Boolean>)((PairProcessor)(tag1, firstTag) -> {
                if (firstTag.booleanValue() && !abbreviation.isEmpty() && StringUtil.isJavaIdentifierPart((char)abbreviation.charAt(0))) {
                    newTagName.set((Object)tag1.getName());
                }
                for (String clazz : HtmlUtil.splitClassNames(tag1.getAttributeValue("class"))) {
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'+')) {
                        classNames.add(clazz.substring(1));
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'-')) {
                        classNames.remove(clazz.substring(1));
                        continue;
                    }
                    classNames.clear();
                    classNames.add(clazz);
                }
                if (!firstTag.booleanValue()) {
                    classNames.add(tag1.getName());
                }
                for (XmlAttribute xmlAttribute : tag1.getAttributes()) {
                    if ("class".equalsIgnoreCase(xmlAttribute.getName())) continue;
                    attributes.put(xmlAttribute.getName(), StringUtil.notNullize((String)xmlAttribute.getValue()));
                }
                return true;
            }));
            WriteCommandAction.writeCommandAction((Project)file2.getProject(), (PsiFile[])new PsiFile[]{file2}).run(EmmetUpdateTagAction.doUpdateTagAttributes(tag, file2, (String)newTagName.get(), classNames, attributes));
        }
    }

    @Nullable
    private static String expandTemplate(@NotNull String abbreviation, @NotNull PsiFile file2, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(7);
        }
        CollectCustomTemplateCallback callback2 = new CollectCustomTemplateCallback(editor, file2);
        ZenCodingTemplate.expand(abbreviation, callback2, XmlZenCodingGeneratorImpl.INSTANCE, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        TemplateImpl template = callback2.getGeneratedTemplate();
        return template != null ? template.getTemplateText() : null;
    }

    private static void processTags(@NotNull Project project, @Nullable String templateText, @NotNull PairProcessor<? super XmlTag, ? super Boolean> processor2) {
        if (project == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)templateText)) {
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
            XmlFile xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.HTML, (CharSequence)templateText);
            XmlTag tag = xmlFile.getRootTag();
            boolean firstTag = true;
            while (tag != null) {
                processor2.process((Object)tag, (Object)firstTag);
                firstTag = false;
                tag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            }
        }
    }

    @NotNull
    private static ThrowableRunnable<RuntimeException> doUpdateTagAttributes(@NotNull XmlTag tag, @NotNull PsiFile file2, @Nullable String newTagName, @NotNull Collection<String> classes, @NotNull Map<String, String> attributes) {
        if (tag == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(11);
        }
        if (classes == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(12);
        }
        if (attributes == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(13);
        }
        ThrowableRunnable throwableRunnable = () -> {
            if (tag.isValid() && !ReadonlyStatusHandler.getInstance((Project)file2.getProject()).ensureFilesWritable(new VirtualFile[]{file2.getVirtualFile()}).hasReadonlyFiles()) {
                tag.setAttribute("class", StringUtil.join((Collection)classes, (String)" ").trim());
                for (Map.Entry attribute : attributes.entrySet()) {
                    XmlAttribute existingAttribute;
                    String attributeName = (String)attribute.getKey();
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'+')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute != null) {
                            existingAttribute.setValue(StringUtil.notNullize((String)(existingAttribute.getValue() + (String)attribute.getValue())));
                            continue;
                        }
                        tag.setAttribute(attributeName.substring(1), (String)attribute.getValue());
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'-')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute == null) continue;
                        existingAttribute.delete();
                        continue;
                    }
                    tag.setAttribute(attributeName, (String)attribute.getValue());
                }
                if (newTagName != null) {
                    tag.setName(newTagName);
                }
            }
        };
        if (throwableRunnable == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(14);
        }
        return throwableRunnable;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(15);
        }
        super.update(event);
        event.getPresentation().setVisible(event.getPresentation().isEnabled());
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(18);
        }
        return super.isValidForFile(project, editor, file2) && EmmetOptions.getInstance().isEmmetEnabled() && EmmetUpdateTagAction.findTag(editor, file2) != null;
    }

    @Nullable
    private static XmlTag findTag(@NotNull Editor editor, @NotNull PsiFile file2) {
        XmlTag tag;
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(20);
        }
        return (tag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), (Class[])new Class[]{XmlTag.class})) != null && HtmlUtil.isHtmlTag(tag) ? tag : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateTagAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTag";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processTags";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTagAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

