/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeCalculatorTask
extends BaseMergeTask {
    public static final String PROP_BUNCH_SIZE = "idea.svn.quick.merge.bunch.size";
    private static final int BUNCH_SIZE = 100;
    @Nullable
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;
    @NotNull
    private final OneShotMergeInfoHelper myMergeChecker;
    @NotNull
    private final List<SvnChangeList> myChangeLists;
    @NotNull
    private final Consumer<MergeCalculatorTask> myCallback;
    private boolean myAllListsLoaded;

    public MergeCalculatorTask(@NotNull QuickMerge mergeProcess, @Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, @NotNull Consumer<MergeCalculatorTask> callback) {
        if (mergeProcess == null) {
            MergeCalculatorTask.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            MergeCalculatorTask.$$$reportNull$$$0(1);
        }
        super(mergeProcess);
        this.myCopyPoint = copyPoint;
        this.myCallback = callback;
        this.myChangeLists = ContainerUtil.newArrayList();
        this.myMergeChecker = new OneShotMergeInfoHelper(this.myMergeContext);
    }

    public boolean areAllListsLoaded() {
        return this.myAllListsLoaded;
    }

    @NotNull
    public MergeChecker getMergeChecker() {
        OneShotMergeInfoHelper oneShotMergeInfoHelper = this.myMergeChecker;
        if (oneShotMergeInfoHelper == null) {
            MergeCalculatorTask.$$$reportNull$$$0(2);
        }
        return oneShotMergeInfoHelper;
    }

    @NotNull
    public List<SvnChangeList> getChangeLists() {
        List<SvnChangeList> list = this.myChangeLists;
        if (list == null) {
            MergeCalculatorTask.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void run() throws VcsException {
        ProgressManager.progress((String)"Collecting merge information");
        this.myMergeChecker.prepare();
        if (this.myCopyPoint != null) {
            this.myChangeLists.addAll(this.getNotMergedChangeLists(this.getChangeListsAfter(this.myCopyPoint.getTrue().getTargetRevision())));
            this.myAllListsLoaded = true;
        } else {
            Pair<List<SvnChangeList>, Boolean> loadResult = MergeCalculatorTask.loadChangeLists(this.myMergeContext, -1L, MergeCalculatorTask.getBunchSize(-1));
            this.myChangeLists.addAll((Collection)loadResult.first);
            this.myAllListsLoaded = (Boolean)loadResult.second;
        }
        if (!this.myChangeLists.isEmpty()) {
            this.myCallback.consume((Object)this);
        } else {
            this.myMergeProcess.end("Everything is up-to-date", false);
        }
    }

    @NotNull
    private List<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsAfter(long revision) throws VcsException {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.CHANGE_AFTER = Long.toString(revision);
        settings.USE_CHANGE_AFTER_FILTER = true;
        List<Pair<SvnChangeList, LogHierarchyNode>> list = MergeCalculatorTask.getChangeLists(this.myMergeContext, settings, revision, -1, Pair::create);
        if (list == null) {
            MergeCalculatorTask.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<SvnChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        if (changeLists == null) {
            MergeCalculatorTask.$$$reportNull$$$0(5);
        }
        ArrayList result = ContainerUtil.newArrayList();
        ProgressManager.progress((String)"Collecting not merged revisions");
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            SvnChangeList changeList = (SvnChangeList)pair.getFirst();
            ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", changeList.getNumber()));
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)this.myMergeChecker.checkList(changeList)) || this.myMergeChecker.checkListForPaths((LogHierarchyNode)pair.getSecond())) continue;
            result.add(changeList);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            MergeCalculatorTask.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Pair<List<SvnChangeList>, Boolean> loadChangeLists(@NotNull MergeContext mergeContext, long beforeRevision, int n) throws VcsException {
        void size;
        if (mergeContext == null) {
            MergeCalculatorTask.$$$reportNull$$$0(7);
        }
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        if (beforeRevision > 0L) {
            settings.CHANGE_BEFORE = String.valueOf(beforeRevision);
            settings.USE_CHANGE_BEFORE_FILTER = true;
        }
        List changeLists = MergeCalculatorTask.getChangeLists(mergeContext, settings, beforeRevision, (int)size, (changeList, tree) -> changeList);
        Pair pair = Pair.create(changeLists.subList(0, Math.min((int)size, changeLists.size())), (Object)(changeLists.size() < size + true ? 1 : 0));
        if (pair == null) {
            MergeCalculatorTask.$$$reportNull$$$0(8);
        }
        return pair;
    }

    public static int getBunchSize(int size) {
        Integer configuredSize = Integer.getInteger(PROP_BUNCH_SIZE);
        return configuredSize != null ? configuredSize : (size > 0 ? size : 100);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static <T> List<T> getChangeLists(@NotNull MergeContext mergeContext, @NotNull ChangeBrowserSettings settings, long revisionToExclude, int size, @NotNull PairFunction<SvnChangeList, LogHierarchyNode, T> pairFunction) throws VcsException {
        void resultProvider;
        if (mergeContext == null) {
            MergeCalculatorTask.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            MergeCalculatorTask.$$$reportNull$$$0(10);
        }
        if (pairFunction == null) {
            MergeCalculatorTask.$$$reportNull$$$0(11);
        }
        ArrayList result = ContainerUtil.newArrayList();
        ((SvnCommittedChangesProvider)mergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(mergeContext.getSourceUrl()), size > 0 ? size + (revisionToExclude > 0L ? 2 : 1) : 0, (PairConsumer<SvnChangeList, LogHierarchyNode>)((PairConsumer)(arg_0, arg_1) -> MergeCalculatorTask.lambda$getChangeLists$1(revisionToExclude, result, (PairFunction)resultProvider, arg_0, arg_1)));
        ArrayList arrayList = result;
        if (arrayList == null) {
            MergeCalculatorTask.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void lambda$getChangeLists$1(long revisionToExclude, List result, PairFunction resultProvider, SvnChangeList changeList, LogHierarchyNode tree) {
        if (revisionToExclude != changeList.getNumber()) {
            result.add(resultProvider.fun((Object)changeList, (Object)tree));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/MergeCalculatorTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/MergeCalculatorTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeChecker";
                break;
            }
            case 3: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeListsAfter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotMergedChangeLists";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNotMergedChangeLists";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadChangeLists";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangeLists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

