/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run.docutils;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rest.RestFileType;
import com.jetbrains.rest.run.RestRunConfiguration;
import com.jetbrains.rest.run.RestRunConfigurationType;
import com.jetbrains.rest.run.docutils.DocutilsRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocutilsConfigurationProducer
extends RuntimeConfigurationProducer
implements Cloneable {
    public DocutilsConfigurationProducer() {
        super(RestRunConfigurationType.getInstance().DOCUTILS_FACTORY);
    }

    public PsiElement getSourceElement() {
        return this.restoreSourceElement();
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        VirtualFile parent;
        PsiFile script = location.getPsiElement().getContainingFile();
        if (script == null || script.getFileType() != RestFileType.INSTANCE) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)script);
        this.storeSourceElement((PsiElement)script);
        Project project = script.getProject();
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(project, context);
        DocutilsRunConfiguration configuration = (DocutilsRunConfiguration)settings.getConfiguration();
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        configuration.setInputFile(vFile.getPath());
        configuration.setName(script.getName());
        String outputPath = vFile.getPath();
        int index = outputPath.lastIndexOf(46);
        if (index > 0) {
            outputPath = outputPath.substring(0, index);
        }
        outputPath = outputPath + ".html";
        VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
        if (outputFile == null) {
            configuration.setOutputFile(outputPath);
            configuration.setOpenInBrowser(true);
        }
        if (configuration.getTask().isEmpty()) {
            configuration.setTask("rst2html");
        }
        if ((parent = vFile.getParent()) != null) {
            configuration.setWorkingDirectory(parent.getPath());
        }
        configuration.setName(configuration.suggestedName());
        if (module != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module);
        }
        return settings;
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        PsiFile script;
        if (existingConfigurations == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((script = location.getPsiElement().getContainingFile()) == null) {
            return null;
        }
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        String path = vFile.getPath();
        for (RunnerAndConfigurationSettings configuration : existingConfigurations) {
            String scriptName = ((RestRunConfiguration)configuration.getConfiguration()).getInputFile();
            if (!FileUtil.toSystemIndependentName((String)scriptName).equals(FileUtil.toSystemIndependentName((String)path))) continue;
            return configuration;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "com/jetbrains/rest/run/docutils/DocutilsConfigurationProducer", "findExistingByElement"));
    }
}

