/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnionType
implements PyType {
    private final Set<PyType> myMembers;

    PyUnionType(Collection<PyType> members) {
        this.myMembers = new LinkedHashSet<PyType>(members);
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyUnionType.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            PyUnionType.$$$reportNull$$$0(1);
        }
        if (resolveContext == null) {
            PyUnionType.$$$reportNull$$$0(2);
        }
        SmartList ret = new SmartList();
        boolean allNulls = true;
        for (PyType member : this.myMembers) {
            List<? extends RatedResolveResult> result;
            if (member == null || (result = member.resolveMember(name, location, direction, resolveContext)) == null) continue;
            allNulls = false;
            ret.addAll(result);
        }
        return allNulls ? null : ret;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        HashSet variants = new HashSet();
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            Collections.addAll(variants, member.getCompletionVariants(completionPrefix, location, context));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    @Override
    public String getName() {
        return StringUtil.join(this.myMembers, (Function)((NullableFunction)type -> type != null ? type.getName() : null), (String)" | ");
    }

    @Override
    public boolean isBuiltin() {
        for (PyType one : this.myMembers) {
            if (one != null && one.isBuiltin()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assertValid(String message) {
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            member.assertValid(message);
        }
    }

    @Nullable
    public static PyType union(@Nullable PyType type1, @Nullable PyType type2) {
        LinkedHashSet<PyType> members = new LinkedHashSet<PyType>();
        if (type1 instanceof PyUnionType) {
            members.addAll(((PyUnionType)type1).myMembers);
        } else {
            members.add(type1);
        }
        if (type2 instanceof PyUnionType) {
            members.addAll(((PyUnionType)type2).myMembers);
        } else {
            members.add(type2);
        }
        if (members.size() == 1) {
            return (PyType)members.iterator().next();
        }
        return new PyUnionType(members);
    }

    @Nullable
    public static PyType union(Collection<PyType> members) {
        int n = members.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return members.iterator().next();
        }
        Iterator<PyType> it = members.iterator();
        PyType res = PyUnionType.unit(it.next());
        while (it.hasNext()) {
            res = PyUnionType.union(res, it.next());
        }
        return res;
    }

    @Nullable
    public static PyType createWeakType(@Nullable PyType type) {
        PyUnionType unionType;
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType && (unionType = (PyUnionType)type).isWeak()) {
            return unionType;
        }
        return PyUnionType.union(type, null);
    }

    public boolean isWeak() {
        for (PyType member : this.myMembers) {
            if (member != null) continue;
            return true;
        }
        return false;
    }

    public Collection<PyType> getMembers() {
        return this.myMembers;
    }

    @Nullable
    public PyType exclude(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUnionType.$$$reportNull$$$0(3);
        }
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PyType m : this.getMembers()) {
            if (type == null) {
                if (m == null) continue;
                members.add(m);
                continue;
            }
            if (PyTypeChecker.match(type, m, context)) continue;
            members.add(m);
        }
        return PyUnionType.union(members);
    }

    @Nullable
    public PyType excludeNull(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyUnionType.$$$reportNull$$$0(4);
        }
        return this.exclude(null, context);
    }

    private static PyType unit(@Nullable PyType type) {
        if (type instanceof PyUnionType) {
            LinkedHashSet<PyType> members = new LinkedHashSet<PyType>(((PyUnionType)type).getMembers());
            return new PyUnionType(members);
        }
        return new PyUnionType(Collections.singletonList(type));
    }

    public boolean equals(Object other) {
        if (other instanceof PyUnionType) {
            PyUnionType otherType = (PyUnionType)other;
            return this.myMembers.equals(otherType.myMembers);
        }
        return false;
    }

    public int hashCode() {
        return this.myMembers.hashCode();
    }

    public String toString() {
        return "PyUnionType: " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/types/PyUnionType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveMember";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "exclude";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeNull";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

