/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyTypingTypeAliasStubImpl;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyTypingAliasStub;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingAliasStubType
extends CustomTargetExpressionStubType<PyTypingAliasStub> {
    private static final int STRING_LITERAL_LENGTH_THRESHOLD = 100;
    private static final Pattern TYPE_ANNOTATION_LIKE = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(\\[.*])?$");
    private static final TokenSet VALID_TYPE_ANNOTATION_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.REFERENCE_EXPRESSION, PyElementTypes.SUBSCRIPTION_EXPRESSION, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.STRING_LITERAL_EXPRESSION, PyElementTypes.NONE_LITERAL_EXPRESSION});

    @Override
    @Nullable
    public PyTypingAliasStub createStub(PyTargetExpression psi) {
        PyExpression value = PyTypingAliasStubType.getAssignedValueIfTypeAliasLike(psi, true);
        return value != null ? new PyTypingTypeAliasStubImpl(value.getText()) : null;
    }

    @Nullable
    private static PyExpression getAssignedValueIfTypeAliasLike(@NotNull PyTargetExpression target, boolean forStubCreation) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(0);
        }
        if (!PyUtil.isTopLevel(target) || !PyTypingAliasStubType.looksLikeTypeAliasTarget(target)) {
            return null;
        }
        PyExpression value = target.findAssignedValue();
        if (value == null || !PyTypingAliasStubType.looksLikeTypeHint(value, forStubCreation)) {
            return null;
        }
        return value;
    }

    private static boolean looksLikeTypeAliasTarget(@NotNull PyTargetExpression target) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(1);
        }
        if (target.isQualified()) {
            return false;
        }
        String name = target.getName();
        if (name == null || PyUtil.isSpecialName(name)) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyAssignmentStatement.class);
        if (assignment == null) {
            return false;
        }
        PyExpression[] targets = assignment.getRawTargets();
        return targets.length == 1 && targets[0] == target;
    }

    private static boolean looksLikeTypeHint(@NotNull PyExpression expression, boolean forStubCreation) {
        PyCallExpression call;
        if (expression == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(2);
        }
        if ((call = PyUtil.as(expression, PyCallExpression.class)) != null) {
            PyReferenceExpression callee = PyUtil.as(call.getCallee(), PyReferenceExpression.class);
            return callee != null && "TypeVar".equals(callee.getReferencedName());
        }
        PyStringLiteralExpression pyString = PyUtil.as(expression, PyStringLiteralExpression.class);
        if (pyString != null) {
            if (pyString.getStringNodes().size() != 1 || pyString.getTextLength() > 100) {
                return false;
            }
            String content2 = pyString.getStringValue();
            return TYPE_ANNOTATION_LIKE.matcher(content2).matches();
        }
        if (!forStubCreation && expression instanceof PyReferenceExpression || expression instanceof PySubscriptionExpression) {
            return PyTypingAliasStubType.isSyntacticallyValidAnnotation(expression);
        }
        return false;
    }

    private static boolean isSyntacticallyValidAnnotation(@NotNull PyExpression expression) {
        if (expression == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(3);
        }
        return PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (element instanceof ASTDelegatePsiElement) {
                if (!VALID_TYPE_ANNOTATION_ELEMENTS.contains(element.getNode().getElementType())) {
                    return false;
                }
                if (element instanceof PyReferenceExpression) {
                    return ((PyReferenceExpression)element).asQualifiedName() != null;
                }
            }
            return true;
        });
    }

    @Override
    @Nullable
    public PyTypingAliasStub deserializeStub(StubInputStream stream) throws IOException {
        String ref = stream.readNameString();
        return ref != null ? new PyTypingTypeAliasStubImpl(ref) : null;
    }

    @Nullable
    public static PyExpression getAssignedValueStubLike(@NotNull PyTargetExpression target) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(4);
        }
        PyTargetExpressionStub stub = (PyTargetExpressionStub)target.getStub();
        PyExpression result = null;
        if (stub != null) {
            PyTypingAliasStub aliasStub = stub.getCustomStub(PyTypingAliasStub.class);
            String aliasText = null;
            if (aliasStub != null) {
                aliasText = aliasStub.getText();
            } else if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                aliasText = Objects.toString(stub.getInitializer(), null);
            }
            if (aliasText != null) {
                result = PyUtil.createExpressionFromFragment(aliasText, (PsiElement)target.getContainingFile());
            }
        } else {
            result = PyTypingAliasStubType.getAssignedValueIfTypeAliasLike(target, false);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyTypingAliasStubType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignedValueIfTypeAliasLike";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeTypeAliasTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeTypeHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSyntacticallyValidAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignedValueStubLike";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

