/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.patterns;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.patterns.PyElementPattern;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPatterns
extends PlatformPatterns {
    private static final int STRING_LITERAL_LIMIT = 10000;

    public static PyElementPattern.Capture<PyLiteralExpression> pyLiteralExpression() {
        return new PyElementPattern.Capture<PyLiteralExpression>(new InitialPatternCondition<PyLiteralExpression>(PyLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof PyLiteralExpression;
            }
        });
    }

    public static PyElementPattern.Capture<PyStringLiteralExpression> pyStringLiteralMatches(String regexp) {
        final Pattern pattern = Pattern.compile(regexp, 34);
        return new PyElementPattern.Capture<PyStringLiteralExpression>(new InitialPatternCondition<PyStringLiteralExpression>(PyStringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                PyStringLiteralExpression expr;
                if (o instanceof PyStringLiteralExpression && !DocStringUtil.isDocStringExpression(expr = (PyStringLiteralExpression)o) && expr.getTextLength() < 10000) {
                    String value = expr.getStringValue();
                    return pattern.matcher(value).find();
                }
                return false;
            }
        });
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyArgument(final @Nullable String functionName, final int index) {
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return PythonPatterns.isCallArgument(o, functionName, index);
            }
        });
        if (capture == null) {
            PythonPatterns.$$$reportNull$$$0(0);
        }
        return capture;
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyModuleFunctionArgument(final @Nullable String functionName, final int index, final @NotNull String moduleName) {
        if (moduleName == null) {
            PythonPatterns.$$$reportNull$$$0(1);
        }
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return StreamEx.of((Collection)PythonPatterns.multiResolveCalledFunction(o, functionName, index)).select(PyFunction.class).map(ScopeUtil::getScopeOwner).select(PyFile.class).anyMatch(file -> moduleName.equals(FileUtil.getNameWithoutExtension((String)file.getName())));
            }
        });
        if (capture == null) {
            PythonPatterns.$$$reportNull$$$0(2);
        }
        return capture;
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyMethodArgument(final @Nullable String functionName, final int index, final @NotNull String classQualifiedName) {
        if (classQualifiedName == null) {
            PythonPatterns.$$$reportNull$$$0(3);
        }
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return StreamEx.of((Collection)PythonPatterns.multiResolveCalledFunction(o, functionName, index)).select(PyFunction.class).map(ScopeUtil::getScopeOwner).select(PyClass.class).anyMatch(cls -> classQualifiedName.equals(cls.getQualifiedName()));
            }
        });
        if (capture == null) {
            PythonPatterns.$$$reportNull$$$0(4);
        }
        return capture;
    }

    @NotNull
    private static List<PyCallable> multiResolveCalledFunction(@Nullable Object expression, @Nullable String functionName, int index) {
        if (!PythonPatterns.isCallArgument(expression, functionName, index)) {
            List<PyCallable> list = Collections.emptyList();
            if (list == null) {
                PythonPatterns.$$$reportNull$$$0(5);
            }
            return list;
        }
        PyCallExpression call = (PyCallExpression)((PyExpression)expression).getParent().getParent();
        PyResolveContext context = PyResolveContext.noImplicits().withTypeEvalContext(TypeEvalContext.codeAnalysis(call.getProject(), call.getContainingFile()));
        List<PyCallable> list = call.multiResolveCalleeFunction(context);
        if (list == null) {
            PythonPatterns.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isCallArgument(@Nullable Object expression, @Nullable String functionName, int index) {
        if (!(expression instanceof PyExpression)) {
            return false;
        }
        PsiElement argumentList = ((PyExpression)expression).getParent();
        if (!(argumentList instanceof PyArgumentList)) {
            return false;
        }
        PsiElement call = argumentList.getParent();
        if (!(call instanceof PyCallExpression)) {
            return false;
        }
        PyExpression referenceToCallee = ((PyCallExpression)call).getCallee();
        if (!(referenceToCallee instanceof PyReferenceExpression)) {
            return false;
        }
        String referencedName = ((PyReferenceExpression)referenceToCallee).getReferencedName();
        if (referencedName == null || !referencedName.equals(functionName)) {
            return false;
        }
        PsiElement[] arguments = argumentList.getChildren();
        return index < arguments.length && expression == arguments[index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/patterns/PythonPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pyArgument";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/patterns/PythonPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pyModuleFunctionArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pyMethodArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalledFunction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pyModuleFunctionArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pyMethodArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

