/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return pythonFileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text2, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        text2 = text2.trim();
        PyExpressionCodeFragmentImpl fragment = new PyExpressionCodeFragmentImpl(project, "fragment.py", text2, true);
        PsiElement element = PyDebuggerEditorsProvider.getContextElement(project, sourcePosition);
        fragment.setContext(element);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        if (document == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        return document;
    }

    @Nullable
    @VisibleForTesting
    public static PsiElement getContextElement(Project project, XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            int offset;
            Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null && (offset = sourcePosition.getOffset()) >= 0 && offset < document.getTextLength()) {
                PsiElement element;
                int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
                do {
                    if ((element = psiFile.findElementAt(offset)) == null || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
                    return PyPsiUtils.getStatement(element);
                } while ((offset = element.getTextRange().getEndOffset()) < lineEndOffset);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

