/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HintUpdateSupply {
    private static final Key<HintUpdateSupply> HINT_UPDATE_MARKER = Key.create((String)"HINT_UPDATE_MARKER");
    @Nullable
    private JBPopup myHint;
    private JComponent myComponent;

    @Nullable
    public static HintUpdateSupply getSupply(@NotNull JComponent component) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(0);
        }
        return (HintUpdateSupply)component.getClientProperty(HINT_UPDATE_MARKER);
    }

    public static void hideHint(@NotNull JComponent component) {
        HintUpdateSupply supply;
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(1);
        }
        if ((supply = HintUpdateSupply.getSupply(component)) != null) {
            supply.hideHint();
        }
    }

    public static void installSimpleHintUpdateSupply(@NotNull JComponent component) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(2);
        }
        HintUpdateSupply.installHintUpdateSupply(component, (Function<Object, ? extends PsiElement>)((Function)o -> o instanceof PsiElement ? (PsiElement)o : null));
    }

    public static void installDataContextHintUpdateSupply(@NotNull JComponent component) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(3);
        }
        HintUpdateSupply.installHintUpdateSupply(component, (Function<Object, ? extends PsiElement>)((Function)o -> o instanceof PsiElement ? (PsiElement)o : CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext(component))));
    }

    public static void installHintUpdateSupply(@NotNull JComponent component, final Function<Object, ? extends PsiElement> provider) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(4);
        }
        HintUpdateSupply supply = new HintUpdateSupply(component){

            @Override
            @Nullable
            protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                return (PsiElement)provider.fun(selectedValue);
            }
        };
        if (component instanceof JList) {
            supply.installListListener((JList)component);
        }
        if (component instanceof JTree) {
            supply.installTreeListener((JTree)component);
        }
        if (component instanceof JTable) {
            supply.installTableListener((JTable)component);
        }
    }

    protected HintUpdateSupply(@NotNull JComponent component) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(5);
        }
        this.installSupply(component);
    }

    public HintUpdateSupply(@NotNull JBTable table) {
        if (table == null) {
            HintUpdateSupply.$$$reportNull$$$0(6);
        }
        this.installSupply(table);
        this.installTableListener(table);
    }

    public HintUpdateSupply(@NotNull Tree tree) {
        if (tree == null) {
            HintUpdateSupply.$$$reportNull$$$0(7);
        }
        this.installSupply(tree);
        this.installTreeListener(tree);
    }

    public HintUpdateSupply(@NotNull JBList list) {
        if (list == null) {
            HintUpdateSupply.$$$reportNull$$$0(8);
        }
        this.installSupply(list);
        this.installListListener(list);
    }

    protected void installTableListener(final @NotNull JTable table) {
        if (table == null) {
            HintUpdateSupply.$$$reportNull$$$0(9);
        }
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.this.shouldUpdateHint()) {
                    return;
                }
                int selected = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
                int rowCount = table.getRowCount();
                if (selected == -1 || rowCount == 0) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(table.getValueAt(Math.min(selected, rowCount - 1), 0));
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(listener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    protected void installTreeListener(final @NotNull JTree tree) {
        if (tree == null) {
            HintUpdateSupply.$$$reportNull$$$0(10);
        }
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiElement psiElement;
                if (!HintUpdateSupply.this.shouldUpdateHint()) {
                    return;
                }
                TreePath path2 = tree.getSelectionPath();
                if (path2 != null && (psiElement = HintUpdateSupply.this.getPsiElementForHint(path2.getLastPathComponent())) != null && psiElement.isValid()) {
                    HintUpdateSupply.this.updateHint(psiElement);
                }
            }
        });
    }

    protected void installListListener(@NotNull JList list) {
        if (list == null) {
            HintUpdateSupply.$$$reportNull$$$0(11);
        }
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.this.shouldUpdateHint()) {
                    return;
                }
                Object[] selectedValues = ((JList)e.getSource()).getSelectedValues();
                if (selectedValues.length != 1) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(selectedValues[0]);
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        });
    }

    @Nullable
    protected abstract PsiElement getPsiElementForHint(@Nullable Object var1);

    private void installSupply(@NotNull JComponent component) {
        if (component == null) {
            HintUpdateSupply.$$$reportNull$$$0(12);
        }
        component.putClientProperty(HINT_UPDATE_MARKER, this);
        this.myComponent = component;
    }

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (HintUpdateSupply.isHintVisible(this.myHint)) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (!HintUpdateSupply.isHintVisible(this.myHint)) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    public boolean shouldUpdateHint() {
        return HintUpdateSupply.isHintVisible(this.myHint) && !HintUpdateSupply.isSelectedByMouse(this.myComponent);
    }

    @Contract(value="!null->true")
    private static boolean isHintVisible(JBPopup hint) {
        return hint != null && hint.isVisible();
    }

    private static boolean isSelectedByMouse(@NotNull JComponent c) {
        if (c == null) {
            HintUpdateSupply.$$$reportNull$$$0(13);
        }
        return Boolean.TRUE.equals(c.getClientProperty("byMouseEvent"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/popup/HintUpdateSupply";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSupply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hideHint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installSimpleHintUpdateSupply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installDataContextHintUpdateSupply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installHintUpdateSupply";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "installTableListener";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "installTreeListener";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "installListListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "installSupply";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelectedByMouse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

