/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementCreator
implements WriteActionAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ElementCreator");
    private final Project myProject;
    private final String myErrorTitle;

    protected ElementCreator(Project project, String errorTitle) {
        this.myProject = project;
        this.myErrorTitle = errorTitle;
    }

    protected abstract PsiElement[] create(String var1) throws Exception;

    protected abstract String getActionName(String var1);

    public PsiElement[] tryCreate(@NotNull String inputString) {
        if (inputString == null) {
            ElementCreator.$$$reportNull$$$0(0);
        }
        if (inputString.length() == 0) {
            Messages.showMessageDialog(this.myProject, IdeBundle.message("error.name.should.be.specified", new Object[0]), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
            return PsiElement.EMPTY_ARRAY;
        }
        Ref createdElements = Ref.create();
        Exception exception = this.executeCommand(this.getActionName(inputString), (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            Object[] psiElements = this.create(inputString);
            SmartPointerManager manager = SmartPointerManager.getInstance(this.myProject);
            createdElements.set((Object)ContainerUtil.map((Object[])psiElements, manager::createSmartPsiElementPointer));
        }));
        if (exception != null) {
            this.handleException(exception);
            return PsiElement.EMPTY_ARRAY;
        }
        return ContainerUtil.mapNotNull((Collection)((Collection)createdElements.get()), SmartPsiElementPointer::getElement).toArray(PsiElement.EMPTY_ARRAY);
    }

    @Nullable
    private Exception executeCommand(String commandName, ThrowableRunnable<Exception> invokeCreate) {
        Exception[] exception = new Exception[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(commandName);
            try {
                if (this.startInWriteAction()) {
                    WriteAction.run(invokeCreate);
                } else {
                    invokeCreate.run();
                }
            }
            catch (Exception ex) {
                exception[0] = ex;
            }
            finally {
                action.finish();
            }
        }, commandName, null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return exception[0];
    }

    private void handleException(Exception t) {
        LOG.info((Throwable)t);
        String errorMessage = ElementCreator.getErrorMessage(t);
        Messages.showMessageDialog(this.myProject, errorMessage, this.myErrorTitle, Messages.getErrorIcon());
    }

    public static String getErrorMessage(Throwable t) {
        String errorMessage = CreateElementActionBase.filterMessage(t.getMessage());
        if (errorMessage == null || errorMessage.length() == 0) {
            errorMessage = t.toString();
        }
        return errorMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/intellij/ide/actions/ElementCreator", "tryCreate"));
    }
}

