/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEditor;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseUnstructuredEditor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitInteractiveRebaseEditorHandler
implements Closeable,
GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitInteractiveRebaseEditorHandler.class);
    private final GitRebaseEditorService myService;
    private final Project myProject;
    private final VirtualFile myRoot;
    @NotNull
    private final UUID myHandlerNo;
    private boolean myIsClosed;
    protected boolean myRebaseEditorShown;
    private boolean myCommitListCancelled;
    private boolean myUnstructuredEditorCancelled;

    public GitInteractiveRebaseEditorHandler(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root) {
        if (service == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(1);
        }
        if (root == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(2);
        }
        this.myRebaseEditorShown = false;
        this.myService = service;
        this.myProject = project;
        this.myRoot = root;
        this.myHandlerNo = service.registerHandler(this, (Disposable)project);
    }

    @Override
    public int editCommits(@NotNull String path) {
        if (path == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(3);
        }
        this.ensureOpen();
        try {
            if (this.myRebaseEditorShown) {
                this.myUnstructuredEditorCancelled = !this.handleUnstructuredEditor(path);
                return this.myUnstructuredEditorCancelled ? 2 : 0;
            }
            this.setRebaseEditorShown();
            boolean success = this.handleInteractiveEditor(path);
            if (success) {
                return 0;
            }
            this.myCommitListCancelled = true;
            return 2;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + path, (Throwable)e);
            return 2;
        }
    }

    protected boolean handleUnstructuredEditor(@NotNull String path) throws IOException {
        String encoding;
        File file;
        String initialText;
        String newText;
        if (path == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(4);
        }
        if ((newText = this.showUnstructuredEditor(initialText = StringUtil.trimLeading((String)GitInteractiveRebaseEditorHandler.ignoreComments(FileUtil.loadFile((File)(file = new File(path)), (String)(encoding = GitConfigUtil.getCommitEncoding(this.myProject, this.myRoot))))))) == null) {
            return false;
        }
        FileUtil.writeToFile((File)file, (byte[])newText.getBytes(encoding));
        return true;
    }

    @NotNull
    private static String ignoreComments(@NotNull String text) {
        if (text == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(5);
        }
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
        String string = ((StreamEx)StreamEx.of((Object[])lines).filter(line -> !line.startsWith("\u0001"))).joining();
        if (string == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private String showUnstructuredEditor(@NotNull String initialText) {
        if (initialText == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(7);
        }
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRebaseUnstructuredEditor editor = new GitRebaseUnstructuredEditor(this.myProject, this.myRoot, initialText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    protected boolean handleInteractiveEditor(@NotNull String path) throws IOException {
        if (path == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(8);
        }
        GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.myProject, this.myRoot, path);
        try {
            List<GitRebaseEntry> entries = rebaseFile.load();
            List<GitRebaseEntry> newEntries = this.showInteractiveRebaseEditor(entries);
            if (newEntries != null) {
                rebaseFile.save(newEntries);
                return true;
            }
            rebaseFile.cancel();
            return false;
        }
        catch (GitInteractiveRebaseFile.NoopException e) {
            return this.confirmNoopRebase();
        }
    }

    @Nullable
    private List<GitRebaseEntry> showInteractiveRebaseEditor(@NotNull List<GitRebaseEntry> entries) {
        if (entries == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(9);
        }
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRebaseEditor editor = new GitRebaseEditor(this.myProject, this.myRoot, entries);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set(editor.getEntries());
            }
        });
        return (List)newText.get();
    }

    private boolean confirmNoopRebase() {
        LOG.info("Noop situation while rebasing " + this.myRoot);
        String message = "There are no commits to rebase because the current branch is directly below the base branch, or they point to the same commit (the 'noop' situation).\nDo you want to continue (this will reset the current branch to the base branch)?";
        Ref result2 = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)(0 == DialogManager.showOkCancelDialog(this.myProject, message, "Git Rebase", CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? 1 : 0)));
        return (Boolean)result2.get();
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    private void ensureOpen() {
        if (this.myIsClosed) {
            throw new IllegalStateException("The handler was already closed");
        }
    }

    @Override
    public void close() {
        this.ensureOpen();
        this.myIsClosed = true;
        this.myService.unregisterHandler(this.myHandlerNo);
    }

    @Override
    @NotNull
    public UUID getHandlerNo() {
        UUID uUID = this.myHandlerNo;
        if (uUID == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(10);
        }
        return uUID;
    }

    @Override
    public boolean wasCommitListEditorCancelled() {
        return this.myCommitListCancelled;
    }

    @Override
    public boolean wasUnstructuredEditorCancelled() {
        return this.myUnstructuredEditorCancelled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitInteractiveRebaseEditorHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitInteractiveRebaseEditorHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoreComments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerNo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editCommits";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleUnstructuredEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ignoreComments";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showUnstructuredEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleInteractiveEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showInteractiveRebaseEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

