/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourcesFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        Project project;
        if (viewSettings == null) {
            ResourcesFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        ResourceBundle[] resourceBundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(context);
        if (resourceBundles != null) {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (ResourceBundle bundle : resourceBundles) {
                result.add((AbstractTreeNode)new ResourceBundleNode(project, bundle, viewSettings));
            }
            return result;
        }
        return null;
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        if (element instanceof ResourceBundle) {
            ResourceBundle bundle = (ResourceBundle)element;
            List<PropertiesFile> propertiesFiles = bundle.getPropertiesFiles();
            for (PropertiesFile file : propertiesFiles) {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null || !vFile.getPath().equals(virtualFile.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        return -1;
    }

    public String getElementLocation(Object element) {
        return null;
    }

    public boolean isInvalidElement(Object element) {
        ResourceBundle resourceBundle;
        List<PropertiesFile> propertiesFiles;
        return element instanceof ResourceBundle && (propertiesFiles = (resourceBundle = (ResourceBundle)element).getPropertiesFiles()).size() == 1;
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("resource_bundle" == null) {
            ResourcesFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        return "resource_bundle";
    }

    public String getElementUrl(Object element) {
        if (element instanceof ResourceBundleImpl) {
            return ((ResourceBundleImpl)element).getUrl();
        }
        if (element instanceof PsiFile[]) {
            PsiFile[] files = (PsiFile[])element;
            ResourceBundle bundle = null;
            for (PsiFile file : files) {
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
                if (propertiesFile == null) {
                    return null;
                }
                ResourceBundle currentBundle = propertiesFile.getResourceBundle();
                if (bundle == null) {
                    bundle = currentBundle;
                    continue;
                }
                if (PsiManager.getInstance((Project)bundle.getProject()).areElementsEquivalent((PsiElement)bundle.getDefaultPropertiesFile().getContainingFile(), (PsiElement)currentBundle.getDefaultPropertiesFile().getContainingFile())) continue;
                return null;
            }
            return this.getElementUrl(bundle);
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        return new Object[]{PropertiesImplUtil.createByUrl(url, project)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/ResourcesFavoriteNodeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/ResourcesFavoriteNodeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

