/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;

public abstract class OWLEntityIcon
implements Icon {
    private static final int BASE_SIZE = 16;
    private final FillType fillType;

    protected OWLEntityIcon(FillType fillType) {
        this.fillType = fillType;
    }

    public abstract Color getEntityColor();

    public FillType getFillType() {
        return this.fillType;
    }

    public int getBaseSize() {
        return 16;
    }

    protected int getBaseline(Component c, int defaultBaseline) {
        if (c == null) {
            return defaultBaseline;
        }
        Font f = c.getFont();
        if (f == null) {
            return defaultBaseline;
        }
        FontMetrics fm = c.getFontMetrics(f);
        return fm.getAscent() + fm.getLeading();
    }

    @Override
    public int getIconWidth() {
        return this.getBaseSize();
    }

    @Override
    public int getIconHeight() {
        return this.getBaseSize();
    }

    public static enum FillType {
        FILLED,
        HOLLOW;

    }
}

