/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CoverageModule {
    @JRubyMethod(module=true)
    public static IRubyObject start(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            runtime2.getCoverageData().setCoverageEnabled(runtime2, true);
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject result(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        IRubyObject result2 = CoverageModule.convertCoverageToRuby(context, runtime2, runtime2.getCoverageData().getCoverage());
        runtime2.getCoverageData().resetCoverage(runtime2);
        return result2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject peek_result(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        return CoverageModule.convertCoverageToRuby(context, runtime2, runtime2.getCoverageData().getCoverage());
    }

    @JRubyMethod(name={"running?"}, module=true)
    public static IRubyObject running_p(ThreadContext context, IRubyObject self2) {
        return context.runtime.getCoverageData().isCoverageEnabled() ? context.tru : context.fals;
    }

    private static IRubyObject convertCoverageToRuby(ThreadContext context, Ruby runtime2, Map<String, int[]> coverage2) {
        RubyHash covHash = RubyHash.newHash(runtime2);
        for (Map.Entry<String, int[]> entry : coverage2.entrySet()) {
            if (entry.getKey().equals("")) continue;
            int[] val = entry.getValue();
            RubyArray ary = RubyArray.newArray(runtime2, val.length);
            for (int i2 = 0; i2 < val.length; ++i2) {
                int integer = val[i2];
                ary.store(i2, integer == -1 ? context.nil : runtime2.newFixnum(integer));
            }
            covHash.fastASetCheckString(runtime2, RubyString.newString(runtime2, entry.getKey()), ary);
        }
        return covHash;
    }
}

