"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var rect_1 = require("../../chart_types/xy_chart/renderer/canvas/primitives/rect");
var canvas_1 = require("../../renderers/canvas");
var get_internal_brush_area_1 = require("../../state/selectors/get_internal_brush_area");
var get_internal_is_brushing_1 = require("../../state/selectors/get_internal_is_brushing");
var get_internal_is_brushing_available_1 = require("../../state/selectors/get_internal_is_brushing_available");
var get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
var get_internal_main_projection_area_1 = require("../../state/selectors/get_internal_main_projection_area");
var get_internal_projection_container_area_1 = require("../../state/selectors/get_internal_projection_container_area");
var DEFAULT_FILL_COLOR = {
    r: 128,
    g: 128,
    b: 128,
    opacity: 0.6,
};
var BrushToolComponent = (function (_super) {
    __extends(BrushToolComponent, _super);
    function BrushToolComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.drawCanvas = function () {
            var _a = _this.props, brushArea = _a.brushArea, mainProjectionArea = _a.mainProjectionArea, fillColor = _a.fillColor;
            if (!_this.ctx || !brushArea) {
                return;
            }
            var top = brushArea.top, left = brushArea.left, width = brushArea.width, height = brushArea.height;
            canvas_1.withContext(_this.ctx, function (ctx) {
                ctx.scale(_this.devicePixelRatio, _this.devicePixelRatio);
                canvas_1.withClip(ctx, {
                    x: mainProjectionArea.left,
                    y: mainProjectionArea.top,
                    width: mainProjectionArea.width,
                    height: mainProjectionArea.height,
                }, function (ctx) {
                    canvas_1.clearCanvas(ctx, 200000, 200000);
                    ctx.translate(mainProjectionArea.left, mainProjectionArea.top);
                    rect_1.renderRect(ctx, {
                        x: left,
                        y: top,
                        width: width,
                        height: height,
                    }, {
                        color: (fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_FILL_COLOR),
                    });
                });
            });
        };
        _this.ctx = null;
        _this.devicePixelRatio = window.devicePixelRatio;
        _this.canvasRef = react_1.default.createRef();
        return _this;
    }
    BrushToolComponent.prototype.componentDidMount = function () {
        this.tryCanvasContext();
        this.drawCanvas();
    };
    BrushToolComponent.prototype.componentDidUpdate = function () {
        if (!this.ctx) {
            this.tryCanvasContext();
        }
        if (this.props.initialized) {
            this.drawCanvas();
        }
    };
    BrushToolComponent.prototype.tryCanvasContext = function () {
        var canvas = this.canvasRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    };
    BrushToolComponent.prototype.render = function () {
        var _a = this.props, initialized = _a.initialized, isBrushAvailable = _a.isBrushAvailable, isBrushing = _a.isBrushing, projectionContainer = _a.projectionContainer;
        if (!initialized || !isBrushAvailable || !isBrushing) {
            this.ctx = null;
            return null;
        }
        var width = projectionContainer.width, height = projectionContainer.height;
        return (react_1.default.createElement("canvas", { ref: this.canvasRef, className: "echBrushTool", width: width * this.devicePixelRatio, height: height * this.devicePixelRatio, style: {
                width: width,
                height: height,
            } }));
    };
    BrushToolComponent.displayName = 'BrushTool';
    return BrushToolComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            initialized: false,
            projectionContainer: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            mainProjectionArea: {
                top: 0,
                left: 0,
                width: 0,
                height: 0,
            },
            isBrushing: false,
            isBrushAvailable: false,
            brushArea: null,
        };
    }
    return {
        initialized: state.specsInitialized,
        projectionContainer: get_internal_projection_container_area_1.getInternalProjectionContainerAreaSelector(state),
        mainProjectionArea: get_internal_main_projection_area_1.getInternalMainProjectionAreaSelector(state),
        isBrushAvailable: get_internal_is_brushing_available_1.getInternalIsBrushingAvailableSelector(state),
        isBrushing: get_internal_is_brushing_1.getInternalIsBrushingSelector(state),
        brushArea: get_internal_brush_area_1.getInternalBrushAreaSelector(state),
    };
};
exports.BrushTool = react_redux_1.connect(mapStateToProps)(BrushToolComponent);
//# sourceMappingURL=brush.js.map