"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function cssFontShorthand(_a, fontSize) {
    var fontStyle = _a.fontStyle, fontVariant = _a.fontVariant, fontWeight = _a.fontWeight, fontFamily = _a.fontFamily;
    return fontStyle + " " + fontVariant + " " + fontWeight + " " + fontSize + "px " + fontFamily;
}
exports.cssFontShorthand = cssFontShorthand;
function measureText(ctx) {
    return function (fontSize, boxes) {
        return boxes.map(function (box) {
            ctx.font = cssFontShorthand(box, fontSize);
            return ctx.measureText(box.text);
        });
    };
}
exports.measureText = measureText;
//# sourceMappingURL=measure.js.map