"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = require("../..");
var constants_1 = require("../../../scales/constants");
var constants_2 = require("../../../specs/constants");
var spec_factory_1 = require("../../../state/spec_factory");
var config_1 = require("../layout/config/config");
var commons_1 = require("../utils/commons");
var defaultProps = {
    chartType: __1.ChartTypes.Heatmap,
    specType: constants_2.SpecTypes.Series,
    data: [],
    colors: ['red', 'yellow', 'green'],
    colorScale: constants_1.ScaleType.Linear,
    xAccessor: function (_a) {
        var x = _a.x;
        return x;
    },
    yAccessor: function (_a) {
        var y = _a.y;
        return y;
    },
    xScaleType: constants_1.ScaleType.Ordinal,
    valueAccessor: function (_a) {
        var value = _a.value;
        return value;
    },
    valueFormatter: function (value) { return "" + value; },
    xSortPredicate: commons_1.Predicate.AlphaAsc,
    ySortPredicate: commons_1.Predicate.AlphaAsc,
    config: config_1.config,
};
exports.Heatmap = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(defaultProps));
//# sourceMappingURL=heatmap.js.map