/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class AnnotationFinder {
    private static final String CONSTRUCTOR_PROPERTIES_ANNOTATION = "java.beans.ConstructorProperties";
    private static final Logger LOGGER = Logger.getLogger(AnnotationFinder.class.getName());
    private final String annotationClassName;
    private final Class<? extends Annotation> annotationClass;

    public static final AnnotationFinder findAnnotation(Class<?> annotation) {
        return AnnotationFinder.findAnnotationByName(annotation.getName());
    }

    public static final AnnotationFinder findAnnotationByName(String annotationClassName) {
        return new AnnotationFinder(annotationClassName, AnnotationFinder.getOptionalAnnotationClass(annotationClassName));
    }

    public static final AnnotationFinder findConstructorProperties() {
        return AnnotationFinder.findAnnotationByName(CONSTRUCTOR_PROPERTIES_ANNOTATION);
    }

    private AnnotationFinder(String annotationClassName, Class<? extends Annotation> annotationClass) {
        this.annotationClassName = annotationClassName;
        this.annotationClass = annotationClass;
    }

    public <T extends Annotation> T in(Annotation[] annotations) {
        if (this.annotationClass == null) {
            return null;
        }
        return (T)AnnotationFinder.findAnnotation(annotations, this.annotationClass, new HashSet<Annotation>());
    }

    public Object valueIn(Annotation[] annotations) {
        return this.invocateValueMethod((Annotation)this.in(annotations));
    }

    private Object invocateValueMethod(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        try {
            return annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String message = Messages.getMessage(MessageKeys.MISSING_VALUE_PROPERTY_IN_ANNOTATION, annotation.annotationType().getName());
            LOGGER.finest(message);
            return null;
        }
    }

    private static <T extends Annotation> Class<T> getOptionalAnnotationClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            String message = Messages.getMessage(MessageKeys.ANNOTATION_NOT_AVAILABLE, classname);
            LOGGER.finest(message);
            return null;
        }
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] declaredAnnotations, Class<T> annotationClass, Set<Annotation> processed) {
        for (Annotation candidate : declaredAnnotations) {
            T inherited;
            Class<? extends Annotation> annType = candidate.annotationType();
            if (annType.equals(annotationClass)) {
                return (T)candidate;
            }
            processed.add(candidate);
            ArrayList<Annotation> inheritedAnnotations = new ArrayList<Annotation>(Arrays.asList(annType.getDeclaredAnnotations()));
            inheritedAnnotations.removeAll(processed);
            if (inheritedAnnotations.size() <= 0 || (inherited = AnnotationFinder.findAnnotation(inheritedAnnotations.toArray(new Annotation[inheritedAnnotations.size()]), annotationClass, processed)) == null) continue;
            return inherited;
        }
        return null;
    }

    public String toString() {
        return "AnnotationFinder [annotationClassName=" + this.annotationClassName + ", annotationClass=" + this.annotationClass + "]";
    }
}

