/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.util.EnumSet;
import javax.sql.DataSource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceOperations;
import org.wildfly.extension.datasources.agroal.AgroalExtension;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;

abstract class AbstractDataSourceDefinition
extends PersistentResourceDefinition {
    private static final String DATA_SOURCE_CAPABILITY_NAME = "org.wildfly.data-source";
    public static final RuntimeCapability<Void> DATA_SOURCE_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.data-source", (boolean)true, DataSource.class).build();
    static final String AUTHENTICATION_CONTEXT_CAPABILITY = "org.wildfly.security.authentication-context";
    static final SimpleAttributeDefinition JNDI_NAME_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jndi-name", (ModelType)ModelType.STRING).setAllowExpression(true)).setRestartAllServices()).setValidator(new ParameterValidator(){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (value.getType() != ModelType.EXPRESSION) {
                String str = value.asString();
                if (!str.startsWith("java:/") && !str.startsWith("java:jboss/")) {
                    throw AgroalLogger.SERVICE_LOGGER.jndiNameInvalidFormat();
                }
                if (str.endsWith("/") || str.contains("//")) {
                    throw AgroalLogger.SERVICE_LOGGER.jndiNameShouldValidate();
                }
            }
        }
    })).build();
    static final SimpleAttributeDefinition STATISTICS_ENABLED_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"statistics-enabled", (ModelType)ModelType.BOOLEAN).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    static final SimpleAttributeDefinition DRIVER_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"driver", (ModelType)ModelType.STRING).setRequires(new String[0])).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    static final SimpleAttributeDefinition URL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"url", (ModelType)ModelType.STRING).setAllowExpression(true)).setRestartAllServices()).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    static final SimpleAttributeDefinition TRANSACTION_ISOLATION_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-isolation", (ModelType)ModelType.STRING).setAllowExpression(true)).setAllowedValues(new String[]{AgroalConnectionFactoryConfiguration.TransactionIsolation.NONE.name(), AgroalConnectionFactoryConfiguration.TransactionIsolation.READ_UNCOMMITTED.name(), AgroalConnectionFactoryConfiguration.TransactionIsolation.READ_COMMITTED.name(), AgroalConnectionFactoryConfiguration.TransactionIsolation.REPEATABLE_READ.name(), AgroalConnectionFactoryConfiguration.TransactionIsolation.SERIALIZABLE.name()})).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)EnumValidator.create(AgroalConnectionFactoryConfiguration.TransactionIsolation.class, EnumSet.allOf(AgroalConnectionFactoryConfiguration.TransactionIsolation.class)))).build();
    static final SimpleAttributeDefinition NEW_CONNECTION_SQL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"new-connection-sql", (ModelType)ModelType.STRING).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition USERNAME_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"username", (ModelType)ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAlternatives(new String[]{"elytron-domain"})).setAllowExpression(true)).setAttributeGroup("security")).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    static final SimpleAttributeDefinition PASSWORD_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAlternatives(new String[]{"credential-reference"})).setAllowExpression(true)).setAttributeGroup("security")).setRequired(false)).setRequires(new String[]{USERNAME_ATTRIBUTE.getName()})).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    static SimpleAttributeDefinition AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-context", ModelType.STRING, true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_CLIENT_REF)).addAlternatives(new String[]{USERNAME_ATTRIBUTE.getName()})).setCapabilityReference("org.wildfly.security.authentication-context", DATA_SOURCE_CAPABILITY)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).addAlternatives(new String[]{PASSWORD_ATTRIBUTE.getName()})).setAttributeGroup("security")).build();
    static final PropertiesAttributeDefinition CONNECTION_PROPERTIES_ATTRIBUTE = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("connection-properties", true).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CONNECTION_FACTORY_ATTRIBUTE = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"connection-factory", (AttributeDefinition[])new AttributeDefinition[]{DRIVER_ATTRIBUTE, URL_ATTRIBUTE, TRANSACTION_ISOLATION_ATTRIBUTE, NEW_CONNECTION_SQL_ATTRIBUTE, USERNAME_ATTRIBUTE, PASSWORD_ATTRIBUTE, AUTHENTICATION_CONTEXT, CREDENTIAL_REFERENCE, CONNECTION_PROPERTIES_ATTRIBUTE}).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAX_SIZE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-size", (ModelType)ModelType.INT).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    static final SimpleAttributeDefinition MIN_SIZE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-size", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    static final SimpleAttributeDefinition INITIAL_SIZE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-size", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    static final SimpleAttributeDefinition BLOCKING_TIMEOUT_MILLIS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking-timeout", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).build();
    static final SimpleAttributeDefinition BACKGROUND_VALIDATION_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"background-validation", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LEAK_DETECTION_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"leak-detection", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition IDLE_REMOVAL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"idle-removal", (ModelType)ModelType.INT).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MINUTES)).setRequired(false)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CONNECTION_POOL_ATTRIBUTE = ObjectTypeAttributeDefinition.create((String)"connection-pool", (AttributeDefinition[])new AttributeDefinition[]{MAX_SIZE_ATTRIBUTE, MIN_SIZE_ATTRIBUTE, INITIAL_SIZE_ATTRIBUTE, BLOCKING_TIMEOUT_MILLIS_ATTRIBUTE, BACKGROUND_VALIDATION_ATTRIBUTE, LEAK_DETECTION_ATTRIBUTE, IDLE_REMOVAL_ATTRIBUTE}).build();
    private static final OperationDefinition FLUSH_ALL = new SimpleOperationDefinitionBuilder("flush-all", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    private static final OperationDefinition FLUSH_GRACEFUL = new SimpleOperationDefinitionBuilder("flush-graceful", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    private static final OperationDefinition FLUSH_INVALID = new SimpleOperationDefinitionBuilder("flush-invalid", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    private static final OperationDefinition FLUSH_IDLE = new SimpleOperationDefinitionBuilder("flush-idle", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    private static final OperationDefinition RESET_STATISTICS = new SimpleOperationDefinitionBuilder("reset-statistics", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    private static final OperationDefinition TEST_CONNECTION = new SimpleOperationDefinitionBuilder("test-connection", (ResourceDescriptionResolver)AgroalExtension.getResolver(new String[0])).build();
    static final SimpleAttributeDefinition STATISTICS_ACQUIRE_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"acquire-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_ACTIVE_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"active-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_AVAILABLE_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"available-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_AWAITING_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"awaiting-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_CREATION_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"creation-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_DESTOY_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"destroy-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_FLUSH_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"flush-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_INVALID_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"invalid-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_LEAK_DETECTION_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"leak-detection-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_MAX_USED_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-used-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_REAP_COUNT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reap-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_BLOCKING_TIME_AVERAGE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking-time-average-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_BLOCKING_TIME_MAX_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking-time-max-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_BLOCKING_TIME_TOTAL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking-time-total-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_CREATION_TIME_AVERAGE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"creation-time-average-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_CREATION_TIME_MAX_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"creation-time-max-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition STATISTICS_CREATION_TIME_TOTAL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"creation-time-total-ms", (ModelType)ModelType.INT).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    private static final ObjectTypeAttributeDefinition STATISTICS = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"statistics", (AttributeDefinition[])new AttributeDefinition[]{STATISTICS_ACQUIRE_COUNT_ATTRIBUTE, STATISTICS_ACTIVE_COUNT_ATTRIBUTE, STATISTICS_AVAILABLE_COUNT_ATTRIBUTE, STATISTICS_AWAITING_COUNT_ATTRIBUTE, STATISTICS_CREATION_COUNT_ATTRIBUTE, STATISTICS_DESTOY_COUNT_ATTRIBUTE, STATISTICS_FLUSH_COUNT_ATTRIBUTE, STATISTICS_INVALID_COUNT_ATTRIBUTE, STATISTICS_LEAK_DETECTION_COUNT_ATTRIBUTE, STATISTICS_MAX_USED_COUNT_ATTRIBUTE, STATISTICS_REAP_COUNT_ATTRIBUTE, STATISTICS_BLOCKING_TIME_AVERAGE_ATTRIBUTE, STATISTICS_BLOCKING_TIME_MAX_ATTRIBUTE, STATISTICS_BLOCKING_TIME_TOTAL_ATTRIBUTE, STATISTICS_CREATION_TIME_AVERAGE_ATTRIBUTE, STATISTICS_CREATION_TIME_MAX_ATTRIBUTE, STATISTICS_CREATION_TIME_TOTAL_ATTRIBUTE}).setRequired(false)).setStorageRuntime()).build();

    AbstractDataSourceDefinition(PersistentResourceDefinition.Parameters parameters) {
        super(parameters.setCapabilities(new RuntimeCapability[]{DATA_SOURCE_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            ReloadRequiredWriteAttributeHandler writeHandler = handler;
            if (attributeDefinition == STATISTICS_ENABLED_ATTRIBUTE) {
                writeHandler = AbstractDataSourceOperations.STATISTICS_ENABLED_WRITE_OPERATION;
            }
            if (attributeDefinition == CONNECTION_FACTORY_ATTRIBUTE) {
                writeHandler = AbstractDataSourceOperations.CONNECTION_FACTORY_WRITE_OPERATION;
            }
            if (attributeDefinition == CONNECTION_POOL_ATTRIBUTE) {
                writeHandler = AbstractDataSourceOperations.CONNECTION_POOL_WRITE_OPERATION;
            }
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)writeHandler);
        }
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)STATISTICS, AbstractDataSourceOperations.STATISTICS_GET_OPERATION);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerOperationHandler(FLUSH_ALL, AbstractDataSourceOperations.FLUSH_ALL_OPERATION);
            resourceRegistration.registerOperationHandler(FLUSH_GRACEFUL, AbstractDataSourceOperations.FLUSH_GRACEFUL_OPERATION);
            resourceRegistration.registerOperationHandler(FLUSH_INVALID, AbstractDataSourceOperations.FLUSH_INVALID_OPERATION);
            resourceRegistration.registerOperationHandler(FLUSH_IDLE, AbstractDataSourceOperations.FLUSH_IDLE_OPERATION);
            resourceRegistration.registerOperationHandler(RESET_STATISTICS, AbstractDataSourceOperations.RESET_STATISTICS_OPERATION);
            resourceRegistration.registerOperationHandler(TEST_CONNECTION, AbstractDataSourceOperations.TEST_CONNECTION_OPERATION);
        }
    }
}

