/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import io.smallrye.config.DirConfigSource;
import java.io.File;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;

class DirConfigSourceService
implements Service<ConfigSource> {
    private final String name;
    private final String path;
    private final String relativeTo;
    private final int ordinal;
    private final Supplier<PathManager> pathManager;
    private ConfigSource configSource;

    DirConfigSourceService(String name, String path, String relativeTo, int ordinal, Supplier<PathManager> pathManager) {
        this.name = name;
        this.path = path;
        this.relativeTo = relativeTo;
        this.ordinal = ordinal;
        this.pathManager = pathManager;
    }

    static void install(OperationContext context, String name, String path, String relativeTo, int ordinal) {
        ServiceBuilder builder = context.getServiceTarget().addService(ServiceNames.CONFIG_SOURCE.append(new String[]{name}));
        Supplier pathManager = builder.requires(context.getCapabilityServiceName("org.wildfly.management.path-manager", PathManager.class));
        builder.setInstance((org.jboss.msc.Service)new DirConfigSourceService(name, path, relativeTo, ordinal, pathManager)).install();
    }

    public void start(StartContext startContext) {
        String relativeToPath = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)this.path) ? null : this.relativeTo;
        String dirPath = this.pathManager.get().resolveRelativePathEntry(this.path, relativeToPath);
        File dir = new File(dirPath);
        MicroProfileConfigLogger.ROOT_LOGGER.loadConfigSourceFromDir(dir.getAbsolutePath());
        this.configSource = new DirConfigSource(dir, this.ordinal);
    }

    public void stop(StopContext stopContext) {
        this.configSource = null;
    }

    public ConfigSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.configSource;
    }
}

