/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.ExternalBrokerConfigurationService;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemAdd;

public class MessagingSubsystemRootResourceDefinition
extends PersistentResourceDefinition {
    private static final String GLOBAL_CLIENT_PREFIX = "global-client-thread-pool-";
    private static final String GLOBAL_CLIENT_SCHEDULED_PREFIX = "global-client-scheduled-thread-pool-";
    public static final RuntimeCapability<Void> CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.external.configuration", (boolean)false).setServiceType(ExternalBrokerConfigurationService.class).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-max-size", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setXmlName("thread-pool-max-size")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_ACTIVE_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-active-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.GAUGE_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_COMPLETED_TASK_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-completed-task-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_CURRENT_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-current-thread-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.GAUGE_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_LARGEST_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-largest-thread-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_TASK_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-task-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_KEEPALIVE_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-keepalive-time", (ModelType)ModelType.LONG).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setXmlName("scheduled-thread-pool-max-size")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_ACTIVE_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-active-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.GAUGE_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_COMPLETED_TASK_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-completed-task-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_CURRENT_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-current-thread-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.GAUGE_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_LARGEST_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-largest-thread-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_TASK_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-task-count", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_KEEPALIVE_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-keepalive-time", (ModelType)ModelType.LONG).setAttributeGroup("global-client")).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE};
    public static final AttributeDefinition[] METRICS = new AttributeDefinition[]{GLOBAL_CLIENT_THREAD_POOL_ACTIVE_COUNT, GLOBAL_CLIENT_THREAD_POOL_COMPLETED_TASK_COUNT, GLOBAL_CLIENT_THREAD_POOL_CURRENT_THREAD_COUNT, GLOBAL_CLIENT_THREAD_POOL_LARGEST_THREAD_COUNT, GLOBAL_CLIENT_THREAD_POOL_TASK_COUNT, GLOBAL_CLIENT_THREAD_POOL_KEEPALIVE_TIME, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_ACTIVE_COUNT, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_COMPLETED_TASK_COUNT, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_CURRENT_THREAD_COUNT, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_LARGEST_THREAD_COUNT, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_TASK_COUNT, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_KEEPALIVE_TIME};
    public static final MessagingSubsystemRootResourceDefinition INSTANCE = new MessagingSubsystemRootResourceDefinition();

    private MessagingSubsystemRootResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(MessagingExtension.SUBSYSTEM_PATH, MessagingExtension.getResourceDescriptionResolver("messaging-activemq")).setAddHandler((OperationStepHandler)MessagingSubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setCapabilities(new RuntimeCapability[]{CONFIGURATION_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition metric : METRICS) {
            resourceRegistration.registerMetric(metric, (OperationStepHandler)ClientThreadPoolMetricReader.INSTANCE);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static final class ClientThreadPoolMetricReader
    implements OperationStepHandler {
        private static final ClientThreadPoolMetricReader INSTANCE = new ClientThreadPoolMetricReader();

        private ClientThreadPoolMetricReader() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String metric;
            ThreadPoolExecutor pool;
            String attributeName = operation.require("name").asString();
            if (attributeName.startsWith(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_PREFIX)) {
                pool = (ThreadPoolExecutor)ActiveMQClient.getGlobalThreadPool();
                metric = attributeName.substring(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_PREFIX.length());
            } else {
                pool = (ThreadPoolExecutor)((Object)ActiveMQClient.getGlobalScheduledThreadPool());
                metric = attributeName.substring(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_SCHEDULED_PREFIX.length());
            }
            switch (metric) {
                case "active-count": {
                    context.getResult().set(pool.getActiveCount());
                    break;
                }
                case "completed-task-count": {
                    context.getResult().set(pool.getCompletedTaskCount());
                    break;
                }
                case "current-thread-count": {
                    context.getResult().set(pool.getPoolSize());
                    break;
                }
                case "largest-thread-count": {
                    context.getResult().set(pool.getLargestPoolSize());
                    break;
                }
                case "task-count": {
                    context.getResult().set(pool.getTaskCount());
                    break;
                }
                case "keepalive-time": {
                    context.getResult().set(pool.getKeepAliveTime(TimeUnit.NANOSECONDS));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(metric);
                }
            }
        }
    }
}

