/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.picketlink.Identity;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public class AuthenticatedAccountContextInitializer
implements ContextInitializer {
    @Inject
    private BeanManager beanManager;

    public void initContextForStore(IdentityContext context, IdentityStore<?> store) {
        Object credentials;
        Identity identity = this.getIdentity();
        if (identity != null) {
            context.setParameter("AUTHENTICATED_ACCOUNT", (Object)identity.getAccount());
        }
        if ((credentials = this.getCredentials()) != null) {
            context.setParameter("CREDENTIALS", credentials);
        }
    }

    private Identity getIdentity() {
        Bean bean = (Bean)this.beanManager.getBeans(Identity.class, new Annotation[0]).iterator().next();
        try {
            Context context = this.beanManager.getContext(bean.getScope());
            return (Identity)context.get((Contextual)bean);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return null;
        }
    }

    private Object getCredentials() {
        Bean bean = (Bean)this.beanManager.getBeans(DefaultLoginCredentials.class, new Annotation[0]).iterator().next();
        try {
            Context context = this.beanManager.getContext(bean.getScope());
            DefaultLoginCredentials credentials = (DefaultLoginCredentials)context.get((Contextual)bean);
            if (credentials != null) {
                return credentials.getCredential();
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        return null;
    }
}

