/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Month;
import java.time.MonthDay;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class MonthDayExternalizer
implements Externalizer<MonthDay> {
    public void writeObject(ObjectOutput output, MonthDay monthDay) throws IOException {
        DefaultExternalizer.MONTH.cast(Month.class).writeObject(output, (Object)monthDay.getMonth());
        IndexSerializer.UNSIGNED_BYTE.writeInt(output, monthDay.getDayOfMonth());
    }

    public MonthDay readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Month month = (Month)DefaultExternalizer.MONTH.cast(Month.class).readObject(input);
        int day = IndexSerializer.UNSIGNED_BYTE.readInt(input);
        return MonthDay.of(month, day);
    }

    public Class<MonthDay> getTargetClass() {
        return MonthDay.class;
    }
}

