/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.md.providers;

import java.io.InputStream;
import java.security.PublicKey;
import java.util.Map;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.saml.md.providers.AbstractMetadataProvider;

public abstract class AbstractFileBasedMetadataProvider<T>
extends AbstractMetadataProvider
implements IMetadataProvider<T> {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String FILENAME_KEY = "FileName";
    private String fileName;
    protected InputStream metadataFileStream;
    private PublicKey encryptionKey;
    private PublicKey signingKey;

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.fileName = options.get(FILENAME_KEY);
        if (this.fileName == null) {
            throw logger.optionNotSet(FILENAME_KEY);
        }
    }

    @Override
    public void injectEncryptionKey(PublicKey publicKey) {
        this.encryptionKey = publicKey;
    }

    @Override
    public void injectFileStream(InputStream fileStream) {
        this.metadataFileStream = fileStream;
    }

    @Override
    public void injectSigningKey(PublicKey publicKey) {
        this.signingKey = publicKey;
    }

    @Override
    public String requireFileInjection() {
        return this.fileName;
    }
}

