/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProducerAwareProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.util.DeferredUtil;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractNestedRuntimeBeanNode
extends RuntimeBeanNode<Object> {
    protected AbstractNestedRuntimeBeanNode(@Nullable RuntimeBeanNode<?> parentNode, @Nullable String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
    }

    public void visitProperties(PropertyVisitor visitor, PropertySpecFactory specFactory, final Queue<RuntimeBeanNode<?>> queue, final RuntimeBeanNodeFactory nodeFactory) {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
            PropertyAnnotationHandler annotationHandler = typeMetadata.getAnnotationHandlerFor(propertyMetadata);
            if (annotationHandler == null || !annotationHandler.shouldVisit(visitor)) continue;
            String propertyName = this.getQualifiedPropertyName(propertyMetadata.getFieldName());
            DefaultPropertyValue propertyValue = new DefaultPropertyValue(propertyName, propertyMetadata, this.getBean());
            annotationHandler.visitPropertyValue(propertyValue, visitor, specFactory, new BeanPropertyContext(){

                @Override
                public void addNested(String propertyName, Object bean) {
                    queue.add(nodeFactory.create(AbstractNestedRuntimeBeanNode.this, propertyName, bean));
                }
            });
        }
    }

    private static class DefaultPropertyValue
    implements PropertyValue {
        private final String propertyName;
        private final PropertyMetadata propertyMetadata;
        private final Object bean;
        private final Supplier<Object> valueSupplier = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                return DeprecationLogger.whileDisabled((Factory)new Factory<Object>(){

                    public Object create() {
                        Method method = DefaultPropertyValue.this.propertyMetadata.getGetterMethod();
                        try {
                            return method.invoke(DefaultPropertyValue.this.bean, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Could not call %s.%s() on %s", method.getDeclaringClass().getSimpleName(), method.getName(), DefaultPropertyValue.this.bean), (Throwable)e);
                        }
                    }
                });
            }
        });

        public DefaultPropertyValue(String propertyName, PropertyMetadata propertyMetadata, Object bean) {
            this.propertyName = propertyName;
            this.propertyMetadata = propertyMetadata;
            this.bean = bean;
            propertyMetadata.getGetterMethod().setAccessible(true);
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.propertyMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.propertyMetadata.getAnnotation(annotationType);
        }

        @Override
        public boolean isOptional() {
            return this.isAnnotationPresent(Optional.class);
        }

        @Override
        public void attachProducer(Task producer) {
            Object value;
            if (this.isProvider() && (value = this.valueSupplier.get()) instanceof ProducerAwareProperty) {
                ((ProducerAwareProperty)value).attachProducer(producer);
            }
        }

        @Override
        public void maybeFinalizeValue() {
            Object value;
            if (this.isProvider() && (value = this.valueSupplier.get()) instanceof PropertyInternal) {
                ((PropertyInternal)value).finalizeValueOnReadAndWarnAboutChanges();
            }
        }

        private boolean isProvider() {
            return Provider.class.isAssignableFrom(this.propertyMetadata.getDeclaredType());
        }

        @Override
        @Nullable
        public Object getValue() {
            Object value = this.valueSupplier.get();
            if (value instanceof Provider && !((Provider)value).isPresent()) {
                return null;
            }
            return value;
        }

        @Override
        @Nullable
        public Object call() {
            return this.getValue();
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            Object unpacked = DeferredUtil.unpack((Object)this.getValue());
            if (unpacked == null) {
                if (!optional) {
                    context.recordValidationMessage(String.format("No value has been specified for property '%s'.", propertyName));
                }
            } else {
                valueValidator.validate(propertyName, unpacked, context);
            }
        }
    }
}

