/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import org.bouncycastle.jcajce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410PublicKeySpec;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvGOST3410PublicKey
implements GOST3410PublicKey,
ProvKey<AsymmetricGOST3410PublicKey> {
    private static final long serialVersionUID = -6251023343619275990L;
    private transient AsymmetricGOST3410PublicKey baseKey;

    ProvGOST3410PublicKey(Algorithm algorithm, GOST3410PublicKey gOST3410PublicKey) {
        this.baseKey = new AsymmetricGOST3410PublicKey(algorithm, GOST3410Util.convertToParams(gOST3410PublicKey.getParams()), gOST3410PublicKey.getY());
    }

    ProvGOST3410PublicKey(Algorithm algorithm, GOST3410PublicKeySpec gOST3410PublicKeySpec) {
        this.baseKey = new AsymmetricGOST3410PublicKey(algorithm, GOST3410Util.convertToParams(gOST3410PublicKeySpec.getParams()), gOST3410PublicKeySpec.getY());
    }

    ProvGOST3410PublicKey(AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey) {
        this.baseKey = asymmetricGOST3410PublicKey;
    }

    @Override
    public AsymmetricGOST3410PublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getY() {
        return this.baseKey.getY();
    }

    @Override
    public GOST3410ParameterSpec<GOST3410DomainParameterSpec> getParams() {
        return GOST3410Util.convertToSpec(this.baseKey.getParameters());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvGOST3410PublicKey)) {
            return false;
        }
        ProvGOST3410PublicKey provGOST3410PublicKey = (ProvGOST3410PublicKey)object;
        return this.baseKey.equals(provGOST3410PublicKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricGOST3410PublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("GOST3410 Public Key").append(string);
        stringBuilder.append("    Y: ").append(this.getY().toString(16)).append(string);
        return stringBuilder.toString();
    }
}

