/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.jcajce.provider.DHUtils;
import org.bouncycastle.util.Strings;

class ProvDHPublicKey
implements DHPublicKey {
    static final long serialVersionUID = -216691575254424324L;
    private transient AsymmetricDHPublicKey baseKey;

    ProvDHPublicKey(Algorithm algorithm, DHPublicKey dHPublicKey) {
        this.baseKey = new AsymmetricDHPublicKey(algorithm, DHUtils.extractParams(dHPublicKey.getParams()), dHPublicKey.getY());
    }

    ProvDHPublicKey(Algorithm algorithm, DHPublicKeySpec dHPublicKeySpec) {
        this.baseKey = new AsymmetricDHPublicKey(algorithm, DHUtils.extractParams(dHPublicKeySpec), dHPublicKeySpec.getY());
    }

    ProvDHPublicKey(AsymmetricDHPublicKey asymmetricDHPublicKey) {
        this.baseKey = asymmetricDHPublicKey;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public DHParameterSpec getParams() {
        return DHUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public BigInteger getY() {
        return this.baseKey.getY();
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    AsymmetricDHPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("DH Public Key").append(string);
        stringBuilder.append("    Y: ").append(this.getY().toString(16)).append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDHPublicKey)) {
            return false;
        }
        ProvDHPublicKey provDHPublicKey = (ProvDHPublicKey)object;
        return this.baseKey.equals(provDHPublicKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDHPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

