/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.apache.bzip2.BZip2Constants;
import org.bouncycastle.apache.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    protected static final int QSORT_STACK_SIZE = 1000;
    private boolean finished;
    int last;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bytesOut;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private char[] block = null;
    private int[] quadrant = null;
    private int[] zptr = null;
    private short[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int nBlocksRandomised;
    private int currentChar = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    private static void panic() {
        System.out.println("panic");
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(char[] len, int[] freq, int alphaSize, int maxLen) {
        int i;
        int[] heap = new int[260];
        int[] weight = new int[516];
        int[] parent = new int[516];
        for (i = 0; i < alphaSize; ++i) {
            weight[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
        }
        block1: while (true) {
            int j;
            int tmp;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            for (i = 1; i <= alphaSize; ++i) {
                parent[i] = -1;
                heap[++nHeap] = i;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                parent[n1] = parent[n2] = ++nNodes;
                weight[nNodes] = (weight[n1] & 0xFFFFFF00) + (weight[n2] & 0xFFFFFF00) | 1 + ((weight[n1] & 0xFF) > (weight[n2] & 0xFF) ? weight[n1] & 0xFF : weight[n2] & 0xFF);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                zz = 0;
                tmp = 0;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            for (i = 1; i <= alphaSize; ++i) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                len[i - 1] = (char)j;
                if (j <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) break;
            i = 1;
            while (true) {
                if (i >= alphaSize) continue block1;
                j = weight[i] >> 8;
                j = 1 + j / 2;
                weight[i] = j << 8;
                ++i;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream inStream) throws IOException {
        this(inStream, 9);
    }

    public CBZip2OutputStream(OutputStream inStream, int inBlockSize) throws IOException {
        inStream.write(66);
        inStream.write(90);
        this.bsSetStream(inStream);
        this.workFactor = 50;
        if (inBlockSize > 9) {
            inBlockSize = 9;
        }
        if (inBlockSize < 1) {
            inBlockSize = 1;
        }
        this.blockSize100k = inBlockSize;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int bv) throws IOException {
        int b = (256 + bv) % 256;
        if (this.currentChar != -1) {
            if (this.currentChar == b) {
                ++this.runLength;
                if (this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = b;
            }
        } else {
            this.currentChar = b;
            ++this.runLength;
        }
    }

    private void writeRun() throws IOException {
        if (this.last < this.allowableBlockSize) {
            this.inUse[this.currentChar] = true;
            for (int i = 0; i < this.runLength; ++i) {
                this.mCrc.updateCRC((char)this.currentChar);
            }
            switch (this.runLength) {
                case 1: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 2: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 3: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                default: {
                    this.inUse[this.runLength - 4] = true;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)(this.runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bytesOut = 0;
        this.nBlocksRandomised = 0;
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.last = -1;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        if (this.blockRandomised) {
            this.bsW(1, 1);
            ++this.nBlocksRandomised;
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] code, char[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n = minLen; n <= maxLen; ++n) {
            for (int i = 0; i < alphaSize; ++i) {
                if (length[i] != n) continue;
                code[i] = vec++;
            }
            vec <<= 1;
        }
    }

    private void bsSetStream(OutputStream f) {
        this.bsStream = f;
        this.bsLive = 0;
        this.bsBuff = 0;
        this.bytesOut = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int ch = this.bsBuff >> 24;
            this.bsStream.write(ch);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
    }

    private void bsW(int n, int v) throws IOException {
        while (this.bsLive >= 8) {
            int ch = this.bsBuff >> 24;
            this.bsStream.write(ch);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
        this.bsBuff |= v << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void bsPutUChar(int c) throws IOException {
        this.bsW(8, c);
    }

    private void bsPutint(int u) throws IOException {
        this.bsW(8, u >> 24 & 0xFF);
        this.bsW(8, u >> 16 & 0xFF);
        this.bsW(8, u >> 8 & 0xFF);
        this.bsW(8, u & 0xFF);
    }

    private void bsPutIntVS(int numBits, int c) throws IOException {
        this.bsW(numBits, c);
    }

    private void sendMTFValues() throws IOException {
        int j;
        int i;
        int ge;
        int v;
        int t;
        char[][] len = new char[6][258];
        int nSelectors = 0;
        int alphaSize = this.nInUse + 2;
        for (t = 0; t < 6; ++t) {
            for (v = 0; v < alphaSize; ++v) {
                len[t][v] = 15;
            }
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int nGroups = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int nPart = nGroups;
        int remF = this.nMTF;
        int gs = 0;
        while (nPart > 0) {
            int aFreq;
            int tFreq = remF / nPart;
            ge = gs - 1;
            for (aFreq = 0; aFreq < tFreq && ge < alphaSize - 1; aFreq += this.mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.mtfFreq[ge];
                --ge;
            }
            for (v = 0; v < alphaSize; ++v) {
                len[nPart - 1][v] = v >= gs && v <= ge ? 0 : 15;
            }
            --nPart;
            gs = ge + 1;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        for (int iter = 0; iter < 4; ++iter) {
            for (t = 0; t < nGroups; ++t) {
                fave[t] = 0;
            }
            for (t = 0; t < nGroups; ++t) {
                for (v = 0; v < alphaSize; ++v) {
                    rfreq[t][v] = 0;
                }
            }
            nSelectors = 0;
            int totc = 0;
            gs = 0;
            while (gs < this.nMTF) {
                ge = gs + 50 - 1;
                if (ge >= this.nMTF) {
                    ge = this.nMTF - 1;
                }
                for (t = 0; t < nGroups; ++t) {
                    cost[t] = 0;
                }
                if (nGroups == 6) {
                    short cost5 = 0;
                    short cost4 = 0;
                    short cost3 = 0;
                    short cost2 = 0;
                    short cost1 = 0;
                    short cost0 = 0;
                    for (i = gs; i <= ge; ++i) {
                        short icv = this.szptr[i];
                        cost0 = (short)(cost0 + len[0][icv]);
                        cost1 = (short)(cost1 + len[1][icv]);
                        cost2 = (short)(cost2 + len[2][icv]);
                        cost3 = (short)(cost3 + len[3][icv]);
                        cost4 = (short)(cost4 + len[4][icv]);
                        cost5 = (short)(cost5 + len[5][icv]);
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (i = gs; i <= ge; ++i) {
                        short icv = this.szptr[i];
                        for (t = 0; t < nGroups; ++t) {
                            int n = t;
                            cost[n] = (short)(cost[n] + len[t][icv]);
                        }
                    }
                }
                short s = 999999999;
                int bt = -1;
                for (t = 0; t < nGroups; ++t) {
                    if (cost[t] >= s) continue;
                    s = cost[t];
                    bt = t;
                }
                totc += s;
                int n = bt;
                fave[n] = fave[n] + 1;
                this.selector[nSelectors] = (char)bt;
                ++nSelectors;
                for (i = gs; i <= ge; ++i) {
                    int[] nArray = rfreq[bt];
                    short s2 = this.szptr[i];
                    nArray[s2] = nArray[s2] + 1;
                }
                gs = ge + 1;
            }
            for (t = 0; t < nGroups; ++t) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], alphaSize, 20);
            }
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        char[] pos = new char[6];
        for (i = 0; i < nGroups; ++i) {
            pos[i] = (char)i;
        }
        for (i = 0; i < nSelectors; ++i) {
            char ll_i = this.selector[i];
            j = 0;
            char tmp = pos[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = pos[++j];
                pos[j] = tmp2;
            }
            pos[0] = tmp;
            this.selectorMtf[i] = (char)j;
        }
        int[][] code = new int[6][258];
        for (t = 0; t < nGroups; ++t) {
            char minLen = ' ';
            char maxLen = '\u0000';
            for (i = 0; i < alphaSize; ++i) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] >= minLen) continue;
                minLen = len[t][i];
            }
            if (maxLen > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (minLen < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t], len[t], minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = false;
            for (j = 0; j < 16; ++j) {
                if (!this.inUse[i * 16 + j]) continue;
                inUse16[i] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (inUse16[i]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.inUse[i * 16 + j]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        for (i = 0; i < nSelectors; ++i) {
            for (j = 0; j < this.selectorMtf[i]; ++j) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = len[t][0];
            this.bsW(5, curr);
            for (i = 0; i < alphaSize; ++i) {
                while (curr < len[t][i]) {
                    this.bsW(2, 2);
                    ++curr;
                }
                while (curr > len[t][i]) {
                    this.bsW(2, 3);
                    --curr;
                }
                this.bsW(1, 0);
            }
        }
        int selCtr = 0;
        gs = 0;
        while (gs < this.nMTF) {
            ge = gs + 50 - 1;
            if (ge >= this.nMTF) {
                ge = this.nMTF - 1;
            }
            for (i = gs; i <= ge; ++i) {
                this.bsW(len[this.selector[selCtr]][this.szptr[i]], code[this.selector[selCtr]][this.szptr[i]]);
            }
            gs = ge + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h = this.incs[hp];
            for (int i = lo + h; i <= hi; ++i) {
                int v = this.zptr[i];
                int j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n) {
        int temp = 0;
        while (n > 0) {
            temp = this.zptr[p1];
            this.zptr[p1] = this.zptr[p2];
            this.zptr[p2] = temp;
            ++p1;
            ++p2;
            --n;
        }
    }

    private char med3(char a, char b, char c) {
        char t;
        if (a > b) {
            t = a;
            a = b;
            b = t;
        }
        if (b > c) {
            t = b;
            b = c;
            c = t;
        }
        if (a > b) {
            b = a;
        }
        return b;
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        StackElem[] stack = new StackElem[1000];
        for (int count = 0; count < 1000; ++count) {
            stack[count] = new StackElem();
        }
        int sp = 0;
        stack[sp].ll = loSt;
        stack[sp].hh = hiSt;
        stack[sp].dd = dSt;
        ++sp;
        while (sp > 0) {
            int n;
            int gtHi;
            int ltLo;
            if (sp >= 1000) {
                CBZip2OutputStream.panic();
            }
            int lo = stack[--sp].ll;
            int hi = stack[sp].hh;
            int d = stack[sp].dd;
            if (hi - lo < 20 || d > 10) {
                this.simpleSort(lo, hi, d);
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            char med = this.med3(this.block[this.zptr[lo] + d + 1], this.block[this.zptr[hi] + d + 1], this.block[this.zptr[lo + hi >> 1] + d + 1]);
            int unLo = ltLo = lo;
            int unHi = gtHi = hi;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n = this.block[this.zptr[unLo] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.zptr[unLo];
                        this.zptr[unLo] = this.zptr[ltLo];
                        this.zptr[ltLo] = temp;
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n = this.block[this.zptr[unHi] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.zptr[unHi];
                        this.zptr[unHi] = this.zptr[gtHi];
                        this.zptr[gtHi] = temp;
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                temp = 0;
                temp = this.zptr[unLo];
                this.zptr[unLo] = this.zptr[unHi];
                this.zptr[unHi] = temp;
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) {
                stack[sp].ll = lo;
                stack[sp].hh = hi;
                stack[sp].dd = d + 1;
                ++sp;
                continue;
            }
            n = ltLo - lo < unLo - ltLo ? ltLo - lo : unLo - ltLo;
            this.vswap(lo, unLo - n, n);
            int m = hi - gtHi < gtHi - unHi ? hi - gtHi : gtHi - unHi;
            this.vswap(unLo, hi - m + 1, m);
            n = lo + unLo - ltLo - 1;
            m = hi - (gtHi - unHi) + 1;
            stack[sp].ll = lo;
            stack[sp].hh = n;
            stack[sp].dd = d;
            stack[++sp].ll = n + 1;
            stack[sp].hh = m - 1;
            stack[sp].dd = d + 1;
            stack[++sp].ll = m;
            stack[sp].hh = hi;
            stack[sp].dd = d;
            ++sp;
        }
    }

    private void mainSort() {
        int i;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i = 0; i < 20; ++i) {
            this.block[this.last + i + 2] = this.block[i % (this.last + 1) + 1];
        }
        for (i = 0; i <= this.last + 20; ++i) {
            this.quadrant[i] = 0;
        }
        this.block[0] = this.block[this.last + 1];
        if (this.last < 4000) {
            for (i = 0; i <= this.last; ++i) {
                this.zptr[i] = i;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.last, 0);
        } else {
            int j;
            char c2;
            int numQSorted = 0;
            for (i = 0; i <= 255; ++i) {
                bigDone[i] = false;
            }
            for (i = 0; i <= 65536; ++i) {
                this.ftab[i] = 0;
            }
            char c1 = this.block[0];
            for (i = 0; i <= this.last; ++i) {
                c2 = this.block[i + 1];
                int n = (c1 << 8) + c2;
                this.ftab[n] = this.ftab[n] + 1;
                c1 = c2;
            }
            for (i = 1; i <= 65536; ++i) {
                int n = i;
                this.ftab[n] = this.ftab[n] + this.ftab[i - 1];
            }
            c1 = this.block[1];
            i = 0;
            while (i < this.last) {
                c2 = this.block[i + 2];
                j = (c1 << 8) + c2;
                c1 = c2;
                int n = j;
                this.ftab[n] = this.ftab[n] - 1;
                this.zptr[this.ftab[j]] = i++;
            }
            int n = j = (this.block[this.last + 1] << 8) + this.block[1];
            this.ftab[n] = this.ftab[n] - 1;
            this.zptr[this.ftab[j]] = this.last;
            for (i = 0; i <= 255; ++i) {
                runningOrder[i] = i;
            }
            int h = 1;
            while ((h = 3 * h + 1) <= 256) {
            }
            do {
                for (i = h /= 3; i <= 255; ++i) {
                    int vv = runningOrder[i];
                    j = i;
                    while (this.ftab[runningOrder[j - h] + 1 << 8] - this.ftab[runningOrder[j - h] << 8] > this.ftab[vv + 1 << 8] - this.ftab[vv << 8]) {
                        runningOrder[j] = runningOrder[j - h];
                        if ((j -= h) > h - 1) continue;
                    }
                    runningOrder[j] = vv;
                }
            } while (h != 1);
            for (i = 0; i <= 255; ++i) {
                int ss = runningOrder[i];
                for (j = 0; j <= 255; ++j) {
                    int sb = (ss << 8) + j;
                    if ((this.ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi = (this.ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.ftab[sb] & 0xFFDFFFFF;
                    if (hi > lo) {
                        this.qSort3(lo, hi, 2);
                        numQSorted += hi - lo + 1;
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n2 = sb;
                    this.ftab[n2] = this.ftab[n2] | 0x200000;
                }
                bigDone[ss] = true;
                if (i < 255) {
                    int bbStart = this.ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j = 0; j < bbSize; ++j) {
                        int qVal;
                        int a2update = this.zptr[bbStart + j];
                        this.quadrant[a2update] = qVal = j >> shifts;
                        if (a2update >= 20) continue;
                        this.quadrant[a2update + this.last + 1] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (j = 0; j <= 255; ++j) {
                    copy[j] = this.ftab[(j << 8) + ss] & 0xFFDFFFFF;
                }
                for (j = this.ftab[ss << 8] & 0xFFDFFFFF; j < (this.ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j) {
                    c1 = this.block[this.zptr[j]];
                    if (bigDone[c1]) continue;
                    this.zptr[copy[c1]] = this.zptr[j] == 0 ? this.last : this.zptr[j] - 1;
                    char c = c1;
                    copy[c] = copy[c] + 1;
                }
                for (j = 0; j <= 255; ++j) {
                    int n3 = (j << 8) + ss;
                    this.ftab[n3] = this.ftab[n3] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int i;
        int rNToGo = 0;
        int rTPos = 0;
        for (i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i <= this.last; ++i) {
            if (rNToGo == 0) {
                rNToGo = (char)rNums[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n = i + 1;
            this.block[n] = (char)(this.block[n] ^ (--rNToGo == 1 ? (char)'\u0001' : '\u0000'));
            int n2 = i + 1;
            this.block[n2] = (char)(this.block[n2] & 0xFF);
            this.inUse[this.block[i + 1]] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i <= this.last; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private boolean fullGtU(int i1, int i2) {
        char c1 = this.block[i1 + 1];
        char c2 = this.block[i2 + 1];
        if (c1 != c2) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        ++i1;
        ++i2;
        int k = this.last + 1;
        do {
            if ((c1 = this.block[i1 + 1]) != (c2 = this.block[i2 + 1])) {
                return c1 > c2;
            }
            int s1 = this.quadrant[i1];
            int s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            ++i2;
            if (++i1 > this.last) {
                i1 -= this.last;
                --i1;
            }
            if (i2 > this.last) {
                i2 -= this.last;
                --i2;
            }
            ++this.workDone;
        } while ((k -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.block = new char[n + 1 + 20];
        this.quadrant = new int[n + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        if (this.block == null || this.quadrant == null || this.zptr == null || this.ftab == null) {
            // empty if block
        }
        this.szptr = new short[2 * n];
    }

    private void generateMTFValues() {
        int i;
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.nInUse + 1;
        for (i = 0; i <= EOB; ++i) {
            this.mtfFreq[i] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i = 0; i < this.nInUse; ++i) {
            yy[i] = (char)i;
        }
        for (i = 0; i <= this.last; ++i) {
            char ll_i = this.unseqToSeq[this.block[this.zptr[i]]];
            int j = 0;
            char tmp = yy[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j];
                yy[j] = tmp2;
            }
            yy[0] = tmp;
            if (j == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    switch (zPend % 2) {
                        case 0: {
                            this.szptr[wr] = 0;
                            ++wr;
                            this.mtfFreq[0] = this.mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.szptr[wr] = 1;
                            ++wr;
                            this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        }
                    }
                    if (zPend < 2) break;
                    zPend = (zPend - 2) / 2;
                }
                zPend = 0;
            }
            this.szptr[wr] = (short)(j + 1);
            ++wr;
            int n = j + 1;
            this.mtfFreq[n] = this.mtfFreq[n] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.szptr[wr] = 0;
                        ++wr;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[wr] = 1;
                        ++wr;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.szptr[wr] = (short)EOB;
        int n = EOB;
        this.mtfFreq[n] = this.mtfFreq[n] + 1;
        this.nMTF = ++wr;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

