/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.UpdatableBoardsLibsFakeURLsHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchController;
import processing.app.SketchFile;
import processing.app.Theme;
import processing.app.helpers.DocumentTextChangeListener;
import processing.app.syntax.ArduinoTokenMakerFactory;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SketchTextArea;
import processing.app.tools.DiscourseFormat;

public class EditorTab
extends JPanel
implements SketchFile.TextStorage {
    protected Editor editor;
    protected SketchTextArea textarea;
    protected RTextScrollPane scrollPane;
    protected SketchFile file;
    protected boolean modified;
    protected boolean external;

    public EditorTab(Editor editor, SketchFile file, String contents) throws IOException {
        super(new BorderLayout());
        if (contents == null) {
            contents = file.load();
            this.modified = false;
        } else {
            this.modified = true;
        }
        this.editor = editor;
        this.file = file;
        RSyntaxDocument document = this.createDocument(contents);
        this.textarea = this.createTextArea(document);
        this.scrollPane = this.createScrollPane(this.textarea);
        file.setStorage((SketchFile.TextStorage)this);
        this.applyPreferences();
        this.add((Component)this.scrollPane, "Center");
        editor.base.addEditorFontResizeMouseWheelListener((Component)((Object)this.textarea));
    }

    private RSyntaxDocument createDocument(String contents) {
        RSyntaxDocument document = new RSyntaxDocument((TokenMakerFactory)new ArduinoTokenMakerFactory(this.editor.base.getPdeKeywords()), "text/cpp");
        document.putProperty((Object)"tabSize", (Object)PreferencesData.getInteger((String)"editor.tabs.size"));
        try {
            document.insertString(0, contents, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        document.addDocumentListener((DocumentListener)new DocumentTextChangeListener(() -> this.setModified(true)));
        return document;
    }

    private RTextScrollPane createScrollPane(SketchTextArea textArea) throws IOException {
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)textArea, true);
        scrollPane.setBorder((Border)new MatteBorder(0, 6, 0, 0, Theme.getColor("editor.bgcolor")));
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setLineNumbersEnabled(PreferencesData.getBoolean((String)"editor.linenumbers"));
        scrollPane.setIconRowHeaderEnabled(false);
        Gutter gutter = scrollPane.getGutter();
        gutter.setBookmarkingEnabled(false);
        gutter.setIconRowHeaderInheritsGutterBackground(true);
        return scrollPane;
    }

    private SketchTextArea createTextArea(RSyntaxDocument document) throws IOException {
        final SketchTextArea textArea = new SketchTextArea(document, this.editor.base.getPdeKeywords());
        textArea.setName("editor");
        textArea.setFocusTraversalKeysEnabled(false);
        textArea.setMarkOccurrences(PreferencesData.getBoolean((String)"editor.advanced"));
        textArea.setMarginLineEnabled(false);
        textArea.setCodeFoldingEnabled(PreferencesData.getBoolean((String)"editor.code_folding"));
        textArea.setAutoIndentEnabled(PreferencesData.getBoolean((String)"editor.indent"));
        textArea.setCloseCurlyBraces(PreferencesData.getBoolean((String)"editor.auto_close_braces", (boolean)true));
        textArea.setAntiAliasingEnabled(PreferencesData.getBoolean((String)"editor.antialias"));
        textArea.setTabsEmulated(PreferencesData.getBoolean((String)"editor.tabs.expand"));
        textArea.setTabSize(PreferencesData.getInteger((String)"editor.tabs.size"));
        textArea.addHyperlinkListener(evt -> {
            try {
                UpdatableBoardsLibsFakeURLsHandler boardLibHandler = new UpdatableBoardsLibsFakeURLsHandler(this.editor.base);
                boardLibHandler.openBoardLibManager(evt.getURL());
            }
            catch (Exception e) {
                try {
                    this.editor.platform.openURL(this.editor.getSketch().getFolder(), evt.getURL().toExternalForm());
                }
                catch (Exception f) {
                    Base.showWarning(f.getMessage(), f.getMessage(), f);
                }
            }
        });
        textArea.addCaretListener(e -> {
            Element root = textArea.getDocument().getDefaultRootElement();
            int lineStart = root.getElementIndex(e.getMark());
            int lineEnd = root.getElementIndex(e.getDot());
            this.editor.lineStatus.set(lineStart, lineEnd);
        });
        textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Element root = textArea.getDocument().getDefaultRootElement();
                int lineStart = root.getElementIndex(textArea.getCaret().getMark());
                int lineEnd = root.getElementIndex(textArea.getCaret().getDot());
                EditorTab.this.editor.lineStatus.set(lineStart, lineEnd);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)textArea));
        this.configurePopupMenu(textArea);
        return textArea;
    }

    private void configurePopupMenu(final SketchTextArea textarea) {
        JPopupMenu menu = textarea.getPopupMenu();
        menu.addSeparator();
        JMenuItem item = this.editor.createToolMenuItem("cc.arduino.packages.formatter.AStyle");
        if (item == null) {
            throw new NullPointerException("Tool cc.arduino.packages.formatter.AStyle unavailable");
        }
        item.setName("menuToolsAutoFormat");
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Comment/Uncomment"), 47);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTab.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Increase Indent"), 93);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTab.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Decrease Indent"), 91);
        item.setName("menuDecreaseIndent");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTab.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Copy for Forum"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTab.this.handleDiscourseCopy();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Copy as HTML"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTab.this.handleHTMLCopy();
            }
        });
        menu.add(item);
        final JMenuItem referenceItem = new JMenuItem(I18n.tr((String)"Find in Reference"));
        referenceItem.addActionListener(ev -> this.editor.handleFindReference(this.getCurrentKeyword()));
        menu.add(referenceItem);
        final JMenuItem openURLItem = new JMenuItem(I18n.tr((String)"Open URL"));
        openURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL(e.getActionCommand());
            }
        });
        menu.add(openURLItem);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                String referenceFile = EditorTab.this.editor.base.getPdeKeywords().getReference(EditorTab.this.getCurrentKeyword());
                referenceItem.setEnabled(referenceFile != null);
                int offset = textarea.getCaretPosition();
                Token token = RSyntaxUtilities.getTokenAtOffset((RSyntaxTextArea)textarea, (int)offset);
                if (token != null && token.isHyperlink()) {
                    openURLItem.setEnabled(true);
                    openURLItem.setActionCommand(token.getLexeme());
                } else {
                    openURLItem.setEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void applyPreferences() {
        String defaultFontName;
        this.textarea.setCodeFoldingEnabled(PreferencesData.getBoolean((String)"editor.code_folding"));
        this.scrollPane.setFoldIndicatorEnabled(PreferencesData.getBoolean((String)"editor.code_folding"));
        this.scrollPane.setLineNumbersEnabled(PreferencesData.getBoolean((String)"editor.linenumbers"));
        if (this.external != PreferencesData.getBoolean((String)"editor.external")) {
            boolean bl = this.external = !this.external;
            if (this.external) {
                this.textarea.setBackground(Theme.getColor("editor.external.bgcolor"));
                this.textarea.setHighlightCurrentLine(false);
                this.textarea.setEditable(false);
                this.file.setStorage(null);
                this.reload();
            } else {
                this.textarea.setBackground(Theme.getColor("editor.bgcolor"));
                this.textarea.setHighlightCurrentLine(Theme.getBoolean("editor.linehighlight"));
                this.textarea.setEditable(true);
                this.file.setStorage((SketchFile.TextStorage)this);
                this.reload();
            }
        }
        Font editorFont = Theme.scale(PreferencesData.getFont((String)"editor.font"));
        Font themeFont = Theme.getFont("editor.font");
        if (themeFont != null && (defaultFontName = ((String)StringUtils.defaultIfEmpty((CharSequence)PreferencesData.getDefault((String)"editor.font"), (CharSequence)"")).split(",")[0]).equals(editorFont.getName())) {
            editorFont = new Font(themeFont.getName(), themeFont.getStyle(), editorFont.getSize());
        }
        this.textarea.setFont(editorFont);
        this.scrollPane.getGutter().setLineNumberFont(editorFont);
    }

    public void updateKeywords(PdeKeywords keywords) {
        this.textarea.setKeywords(keywords);
        RSyntaxDocument document = (RSyntaxDocument)this.textarea.getDocument();
        document.setTokenMakerFactory((TokenMakerFactory)new ArduinoTokenMakerFactory(keywords));
        document.setSyntaxStyle("text/cpp");
    }

    public void activated() {
        if (this.external) {
            this.reload();
        }
    }

    public void reload() {
        String text;
        try {
            text = this.file.load();
        }
        catch (IOException e) {
            System.err.println(I18n.format((String)"Warning: Failed to reload file: \"{0}\"", (Object[])new Object[]{this.file.getFileName()}));
            return;
        }
        this.setText(text);
        this.setModified(false);
    }

    public SketchTextArea getTextArea() {
        return this.textarea;
    }

    public SketchController getSketch() {
        return this.editor.getSketchController();
    }

    public SketchFile getSketchFile() {
        return this.file;
    }

    public String getText() {
        return this.textarea.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String what) {
        this.textarea.removeAllLineHighlights();
        DefaultCaret caret = (DefaultCaret)this.textarea.getCaret();
        int policy = caret.getUpdatePolicy();
        caret.setUpdatePolicy(1);
        try {
            Document doc = this.textarea.getDocument();
            int oldLength = doc.getLength();
            this.textarea.beginAtomicEdit();
            try {
                doc.insertString(oldLength, what, null);
                doc.remove(0, oldLength);
            }
            catch (BadLocationException e) {
                System.err.println("Unexpected failure replacing text");
            }
            finally {
                this.textarea.endAtomicEdit();
            }
        }
        finally {
            caret.setUpdatePolicy(policy);
        }
        this.textarea.setLineWrap(this.textarea.getLineWrap());
    }

    public boolean isModified() {
        return this.modified;
    }

    public void clearModified() {
        this.setModified(false);
    }

    private void setModified(boolean value) {
        if (value != this.modified) {
            this.modified = value;
            this.editor.getSketchController().calcModified();
        }
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.replaceSelection(what);
    }

    public void setSelection(int start, int stop) {
        this.textarea.select(start, stop);
    }

    public int getScrollPosition() {
        return this.scrollPane.getVerticalScrollBar().getValue();
    }

    public void setScrollPosition(int pos) {
        this.scrollPane.getVerticalScrollBar().setValue(pos);
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionEnd();
    }

    public String getLineText(int line) {
        try {
            return this.textarea.getText(this.textarea.getLineStartOffset(line), this.textarea.getLineEndOffset(line));
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public void goToLine(int line) {
        if (line <= 0) {
            return;
        }
        try {
            this.textarea.setCaretPosition(this.textarea.getLineStartOffset(line - 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void handleCut() {
        this.textarea.cut();
    }

    void handleCopy() {
        this.textarea.copy();
    }

    void handlePaste() {
        this.textarea.paste();
    }

    void handleSelectAll() {
        this.textarea.selectAll();
    }

    void handleCommentUncomment() {
        Action action = this.textarea.getActionMap().get("RSTA.ToggleCommentAction");
        action.actionPerformed(null);
        this.editor.updateUndoRedoState();
    }

    void handleDiscourseCopy() {
        new DiscourseFormat(this.editor, this, false).show();
    }

    void handleHTMLCopy() {
        new DiscourseFormat(this.editor, this, true).show();
    }

    void handleIndentOutdent(boolean indent) {
        if (indent) {
            Action action = this.textarea.getActionMap().get("RTA.IncreaseIndentAction");
            action.actionPerformed(null);
        } else {
            Action action = this.textarea.getActionMap().get("RSTA.DecreaseIndentAction");
            action.actionPerformed(null);
        }
        this.editor.updateUndoRedoState();
    }

    void handleUndo() {
        this.textarea.undoLastAction();
    }

    void handleRedo() {
        this.textarea.redoLastAction();
    }

    public String getCurrentKeyword() {
        String text = "";
        if (this.textarea.getSelectedText() != null) {
            text = this.textarea.getSelectedText().trim();
        }
        try {
            int current = this.textarea.getCaretPosition();
            int startOffset = 0;
            int endIndex = current;
            String tmp = this.textarea.getDocument().getText(current, 1);
            String regexp = "[\\s\\n();\\\\.!='\\[\\]{}]";
            while (!tmp.matches(regexp)) {
                tmp = this.textarea.getDocument().getText(++endIndex, 1);
            }
            tmp = "";
            while (!tmp.matches(regexp)) {
                if (current - ++startOffset < 0) {
                    tmp = this.textarea.getDocument().getText(0, 1);
                    break;
                }
                tmp = this.textarea.getDocument().getText(current - startOffset, 1);
            }
            int length = endIndex - current + --startOffset;
            text = this.textarea.getDocument().getText(current - startOffset, length);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        return text;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textarea.requestFocusInWindow();
    }
}

